/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;

public final class TypeAdapters {
    public static final TypeAdapter<AtomicBoolean> ATOMIC_BOOLEAN;
    public static final TypeAdapterFactory ATOMIC_BOOLEAN_FACTORY;
    public static final TypeAdapter<AtomicInteger> ATOMIC_INTEGER;
    public static final TypeAdapter<AtomicIntegerArray> ATOMIC_INTEGER_ARRAY;
    public static final TypeAdapterFactory ATOMIC_INTEGER_ARRAY_FACTORY;
    public static final TypeAdapterFactory ATOMIC_INTEGER_FACTORY;
    public static final TypeAdapter<BigDecimal> BIG_DECIMAL;
    public static final TypeAdapter<BigInteger> BIG_INTEGER;
    public static final TypeAdapter<BitSet> BIT_SET;
    public static final TypeAdapterFactory BIT_SET_FACTORY;
    public static final TypeAdapter<Boolean> BOOLEAN;
    public static final TypeAdapter<Boolean> BOOLEAN_AS_STRING;
    public static final TypeAdapterFactory BOOLEAN_FACTORY;
    public static final TypeAdapter<Number> BYTE;
    public static final TypeAdapterFactory BYTE_FACTORY;
    public static final TypeAdapter<Calendar> CALENDAR;
    public static final TypeAdapterFactory CALENDAR_FACTORY;
    public static final TypeAdapter<Character> CHARACTER;
    public static final TypeAdapterFactory CHARACTER_FACTORY;
    public static final TypeAdapter<Class> CLASS;
    public static final TypeAdapterFactory CLASS_FACTORY;
    public static final TypeAdapter<Currency> CURRENCY;
    public static final TypeAdapterFactory CURRENCY_FACTORY;
    public static final TypeAdapter<Number> DOUBLE;
    public static final TypeAdapterFactory ENUM_FACTORY;
    public static final TypeAdapter<Number> FLOAT;
    public static final TypeAdapter<InetAddress> INET_ADDRESS;
    public static final TypeAdapterFactory INET_ADDRESS_FACTORY;
    public static final TypeAdapter<Number> INTEGER;
    public static final TypeAdapterFactory INTEGER_FACTORY;
    public static final TypeAdapter<JsonElement> JSON_ELEMENT;
    public static final TypeAdapterFactory JSON_ELEMENT_FACTORY;
    public static final TypeAdapter<LazilyParsedNumber> LAZILY_PARSED_NUMBER;
    public static final TypeAdapter<Locale> LOCALE;
    public static final TypeAdapterFactory LOCALE_FACTORY;
    public static final TypeAdapter<Number> LONG;
    public static final TypeAdapter<Number> SHORT;
    public static final TypeAdapterFactory SHORT_FACTORY;
    public static final TypeAdapter<String> STRING;
    public static final TypeAdapter<StringBuffer> STRING_BUFFER;
    public static final TypeAdapterFactory STRING_BUFFER_FACTORY;
    public static final TypeAdapter<StringBuilder> STRING_BUILDER;
    public static final TypeAdapterFactory STRING_BUILDER_FACTORY;
    public static final TypeAdapterFactory STRING_FACTORY;
    public static final TypeAdapter<URI> URI;
    public static final TypeAdapterFactory URI_FACTORY;
    public static final TypeAdapter<URL> URL;
    public static final TypeAdapterFactory URL_FACTORY;
    public static final TypeAdapter<UUID> UUID;
    public static final TypeAdapterFactory UUID_FACTORY;

    static {
        TypeAdapter<Object> typeAdapter = new TypeAdapter<Class>(){

            @Override
            public Class read(JsonReader jsonReader) throws IOException {
                throw new UnsupportedOperationException("Attempted to deserialize a java.lang.Class. Forgot to register a type adapter?");
            }

            @Override
            public void write(JsonWriter object, Class clazz) throws IOException {
                object = new StringBuilder();
                ((StringBuilder)object).append("Attempted to serialize java.lang.Class: ");
                ((StringBuilder)object).append(clazz.getName());
                ((StringBuilder)object).append(". Forgot to register a type adapter?");
                throw new UnsupportedOperationException(((StringBuilder)object).toString());
            }
        }.nullSafe();
        CLASS = typeAdapter;
        CLASS_FACTORY = TypeAdapters.newFactory(Class.class, typeAdapter);
        typeAdapter = new TypeAdapter<BitSet>(){

            @Override
            public BitSet read(JsonReader jsonReader) throws IOException {
                Serializable serializable = new BitSet();
                jsonReader.beginArray();
                Object object = jsonReader.peek();
                int n = 0;
                while (object != JsonToken.END_ARRAY) {
                    int n2;
                    block9: {
                        boolean bl;
                        block7: {
                            block8: {
                                block5: {
                                    block6: {
                                        n2 = 35.$SwitchMap$com$google$gson$stream$JsonToken[((Enum)object).ordinal()];
                                        bl = true;
                                        if (n2 == 1 || n2 == 2) break block5;
                                        if (n2 != 3) break block6;
                                        bl = jsonReader.nextBoolean();
                                        break block7;
                                    }
                                    serializable = new StringBuilder();
                                    ((StringBuilder)serializable).append("Invalid bitset value type: ");
                                    ((StringBuilder)serializable).append(object);
                                    ((StringBuilder)serializable).append("; at path ");
                                    ((StringBuilder)serializable).append(jsonReader.getPath());
                                    throw new JsonSyntaxException(((StringBuilder)serializable).toString());
                                }
                                n2 = jsonReader.nextInt();
                                if (n2 != 0) break block8;
                                bl = false;
                                break block7;
                            }
                            if (n2 != 1) break block9;
                        }
                        if (bl) {
                            ((BitSet)serializable).set(n);
                        }
                        ++n;
                        object = jsonReader.peek();
                        continue;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Invalid bitset value ");
                    ((StringBuilder)object).append(n2);
                    ((StringBuilder)object).append(", expected 0 or 1; at path ");
                    ((StringBuilder)object).append(jsonReader.getPreviousPath());
                    throw new JsonSyntaxException(((StringBuilder)object).toString());
                }
                jsonReader.endArray();
                return serializable;
            }

            @Override
            public void write(JsonWriter jsonWriter, BitSet bitSet) throws IOException {
                jsonWriter.beginArray();
                int n = bitSet.length();
                for (int i = 0; i < n; ++i) {
                    jsonWriter.value((long)bitSet.get(i));
                }
                jsonWriter.endArray();
            }
        }.nullSafe();
        BIT_SET = typeAdapter;
        BIT_SET_FACTORY = TypeAdapters.newFactory(BitSet.class, typeAdapter);
        BOOLEAN = typeAdapter = new TypeAdapter<Boolean>(){

            @Override
            public Boolean read(JsonReader jsonReader) throws IOException {
                JsonToken jsonToken = jsonReader.peek();
                if (jsonToken == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                if (jsonToken == JsonToken.STRING) {
                    return Boolean.parseBoolean(jsonReader.nextString());
                }
                return jsonReader.nextBoolean();
            }

            @Override
            public void write(JsonWriter jsonWriter, Boolean bl) throws IOException {
                jsonWriter.value(bl);
            }
        };
        BOOLEAN_AS_STRING = new TypeAdapter<Boolean>(){

            @Override
            public Boolean read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return Boolean.valueOf(jsonReader.nextString());
            }

            @Override
            public void write(JsonWriter jsonWriter, Boolean object) throws IOException {
                object = object == null ? "null" : ((Boolean)object).toString();
                jsonWriter.value((String)object);
            }
        };
        BOOLEAN_FACTORY = TypeAdapters.newFactory(Boolean.TYPE, Boolean.class, typeAdapter);
        BYTE = typeAdapter = new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader jsonReader) throws IOException {
                int n;
                block3: {
                    if (jsonReader.peek() == JsonToken.NULL) {
                        jsonReader.nextNull();
                        return null;
                    }
                    try {
                        n = jsonReader.nextInt();
                        if (n > 255 || n < -128) break block3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new JsonSyntaxException(numberFormatException);
                    }
                    return (byte)n;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Lossy conversion from ");
                stringBuilder.append(n);
                stringBuilder.append(" to byte; at path ");
                stringBuilder.append(jsonReader.getPreviousPath());
                throw new JsonSyntaxException(stringBuilder.toString());
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        BYTE_FACTORY = TypeAdapters.newFactory(Byte.TYPE, Byte.class, typeAdapter);
        SHORT = typeAdapter = new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader jsonReader) throws IOException {
                int n;
                block3: {
                    if (jsonReader.peek() == JsonToken.NULL) {
                        jsonReader.nextNull();
                        return null;
                    }
                    try {
                        n = jsonReader.nextInt();
                        if (n > 65535 || n < Short.MIN_VALUE) break block3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new JsonSyntaxException(numberFormatException);
                    }
                    return (short)n;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Lossy conversion from ");
                stringBuilder.append(n);
                stringBuilder.append(" to short; at path ");
                stringBuilder.append(jsonReader.getPreviousPath());
                throw new JsonSyntaxException(stringBuilder.toString());
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        SHORT_FACTORY = TypeAdapters.newFactory(Short.TYPE, Short.class, typeAdapter);
        INTEGER = typeAdapter = new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader jsonReader) throws IOException {
                int n;
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                try {
                    n = jsonReader.nextInt();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
                return n;
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        INTEGER_FACTORY = TypeAdapters.newFactory(Integer.TYPE, Integer.class, typeAdapter);
        ATOMIC_INTEGER = typeAdapter = new TypeAdapter<AtomicInteger>(){

            @Override
            public AtomicInteger read(JsonReader object) throws IOException {
                try {
                    object = new AtomicInteger(((JsonReader)object).nextInt());
                    return object;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
            }

            @Override
            public void write(JsonWriter jsonWriter, AtomicInteger atomicInteger) throws IOException {
                jsonWriter.value(atomicInteger.get());
            }
        }.nullSafe();
        ATOMIC_INTEGER_FACTORY = TypeAdapters.newFactory(AtomicInteger.class, typeAdapter);
        ATOMIC_BOOLEAN = typeAdapter = new TypeAdapter<AtomicBoolean>(){

            @Override
            public AtomicBoolean read(JsonReader jsonReader) throws IOException {
                return new AtomicBoolean(jsonReader.nextBoolean());
            }

            @Override
            public void write(JsonWriter jsonWriter, AtomicBoolean atomicBoolean) throws IOException {
                jsonWriter.value(atomicBoolean.get());
            }
        }.nullSafe();
        ATOMIC_BOOLEAN_FACTORY = TypeAdapters.newFactory(AtomicBoolean.class, typeAdapter);
        ATOMIC_INTEGER_ARRAY = typeAdapter = new TypeAdapter<AtomicIntegerArray>(){

            @Override
            public AtomicIntegerArray read(JsonReader object) throws IOException {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                ((JsonReader)object).beginArray();
                while (((JsonReader)object).hasNext()) {
                    try {
                        arrayList.add(((JsonReader)object).nextInt());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new JsonSyntaxException(numberFormatException);
                    }
                }
                ((JsonReader)object).endArray();
                int n = arrayList.size();
                object = new AtomicIntegerArray(n);
                for (int i = 0; i < n; ++i) {
                    ((AtomicIntegerArray)object).set(i, (Integer)arrayList.get(i));
                }
                return object;
            }

            @Override
            public void write(JsonWriter jsonWriter, AtomicIntegerArray atomicIntegerArray) throws IOException {
                jsonWriter.beginArray();
                int n = atomicIntegerArray.length();
                for (int i = 0; i < n; ++i) {
                    jsonWriter.value(atomicIntegerArray.get(i));
                }
                jsonWriter.endArray();
            }
        }.nullSafe();
        ATOMIC_INTEGER_ARRAY_FACTORY = TypeAdapters.newFactory(AtomicIntegerArray.class, typeAdapter);
        LONG = new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader jsonReader) throws IOException {
                long l;
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                try {
                    l = jsonReader.nextLong();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JsonSyntaxException(numberFormatException);
                }
                return l;
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        FLOAT = new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return Float.valueOf((float)jsonReader.nextDouble());
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        DOUBLE = new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return jsonReader.nextDouble();
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                jsonWriter.value(number);
            }
        };
        CHARACTER = typeAdapter = new TypeAdapter<Character>(){

            @Override
            public Character read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                String string2 = jsonReader.nextString();
                if (string2.length() == 1) {
                    return Character.valueOf(string2.charAt(0));
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Expecting character, got: ");
                stringBuilder.append(string2);
                stringBuilder.append("; at ");
                stringBuilder.append(jsonReader.getPreviousPath());
                throw new JsonSyntaxException(stringBuilder.toString());
            }

            @Override
            public void write(JsonWriter jsonWriter, Character object) throws IOException {
                object = object == null ? null : String.valueOf(object);
                jsonWriter.value((String)object);
            }
        };
        CHARACTER_FACTORY = TypeAdapters.newFactory(Character.TYPE, Character.class, typeAdapter);
        STRING = typeAdapter = new TypeAdapter<String>(){

            @Override
            public String read(JsonReader jsonReader) throws IOException {
                JsonToken jsonToken = jsonReader.peek();
                if (jsonToken == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                if (jsonToken == JsonToken.BOOLEAN) {
                    return Boolean.toString(jsonReader.nextBoolean());
                }
                return jsonReader.nextString();
            }

            @Override
            public void write(JsonWriter jsonWriter, String string2) throws IOException {
                jsonWriter.value(string2);
            }
        };
        BIG_DECIMAL = new TypeAdapter<BigDecimal>(){

            @Override
            public BigDecimal read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                String string2 = jsonReader.nextString();
                try {
                    BigDecimal bigDecimal = new BigDecimal(string2);
                    return bigDecimal;
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Failed parsing '");
                    stringBuilder.append(string2);
                    stringBuilder.append("' as BigDecimal; at path ");
                    stringBuilder.append(jsonReader.getPreviousPath());
                    throw new JsonSyntaxException(stringBuilder.toString(), numberFormatException);
                }
            }

            @Override
            public void write(JsonWriter jsonWriter, BigDecimal bigDecimal) throws IOException {
                jsonWriter.value(bigDecimal);
            }
        };
        BIG_INTEGER = new TypeAdapter<BigInteger>(){

            @Override
            public BigInteger read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                String string2 = jsonReader.nextString();
                try {
                    BigInteger bigInteger = new BigInteger(string2);
                    return bigInteger;
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Failed parsing '");
                    stringBuilder.append(string2);
                    stringBuilder.append("' as BigInteger; at path ");
                    stringBuilder.append(jsonReader.getPreviousPath());
                    throw new JsonSyntaxException(stringBuilder.toString(), numberFormatException);
                }
            }

            @Override
            public void write(JsonWriter jsonWriter, BigInteger bigInteger) throws IOException {
                jsonWriter.value(bigInteger);
            }
        };
        LAZILY_PARSED_NUMBER = new TypeAdapter<LazilyParsedNumber>(){

            @Override
            public LazilyParsedNumber read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return new LazilyParsedNumber(jsonReader.nextString());
            }

            @Override
            public void write(JsonWriter jsonWriter, LazilyParsedNumber lazilyParsedNumber) throws IOException {
                jsonWriter.value(lazilyParsedNumber);
            }
        };
        STRING_FACTORY = TypeAdapters.newFactory(String.class, typeAdapter);
        STRING_BUILDER = typeAdapter = new TypeAdapter<StringBuilder>(){

            @Override
            public StringBuilder read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return new StringBuilder(jsonReader.nextString());
            }

            @Override
            public void write(JsonWriter jsonWriter, StringBuilder charSequence) throws IOException {
                charSequence = charSequence == null ? null : charSequence.toString();
                jsonWriter.value((String)charSequence);
            }
        };
        STRING_BUILDER_FACTORY = TypeAdapters.newFactory(StringBuilder.class, typeAdapter);
        STRING_BUFFER = typeAdapter = new TypeAdapter<StringBuffer>(){

            @Override
            public StringBuffer read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return new StringBuffer(jsonReader.nextString());
            }

            @Override
            public void write(JsonWriter jsonWriter, StringBuffer charSequence) throws IOException {
                charSequence = charSequence == null ? null : charSequence.toString();
                jsonWriter.value((String)charSequence);
            }
        };
        STRING_BUFFER_FACTORY = TypeAdapters.newFactory(StringBuffer.class, typeAdapter);
        URL = typeAdapter = new TypeAdapter<URL>(){

            @Override
            public URL read(JsonReader object) throws IOException {
                JsonToken jsonToken = ((JsonReader)object).peek();
                JsonToken jsonToken2 = JsonToken.NULL;
                Object var4_4 = null;
                if (jsonToken == jsonToken2) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                object = "null".equals(object = ((JsonReader)object).nextString()) ? var4_4 : new URL((String)object);
                return object;
            }

            @Override
            public void write(JsonWriter jsonWriter, URL object) throws IOException {
                object = object == null ? null : ((URL)object).toExternalForm();
                jsonWriter.value((String)object);
            }
        };
        URL_FACTORY = TypeAdapters.newFactory(URL.class, typeAdapter);
        URI = typeAdapter = new TypeAdapter<URI>(){

            @Override
            public URI read(JsonReader object) throws IOException {
                block5: {
                    block4: {
                        JsonToken jsonToken = ((JsonReader)object).peek();
                        JsonToken jsonToken2 = JsonToken.NULL;
                        Object var4_5 = null;
                        if (jsonToken == jsonToken2) {
                            ((JsonReader)object).nextNull();
                            return null;
                        }
                        try {
                            object = ((JsonReader)object).nextString();
                            if (!"null".equals(object)) break block4;
                            object = var4_5;
                            break block5;
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            throw new JsonIOException(uRISyntaxException);
                        }
                    }
                    object = new URI((String)object);
                }
                return object;
            }

            @Override
            public void write(JsonWriter jsonWriter, URI object) throws IOException {
                object = object == null ? null : ((URI)object).toASCIIString();
                jsonWriter.value((String)object);
            }
        };
        URI_FACTORY = TypeAdapters.newFactory(URI.class, typeAdapter);
        INET_ADDRESS = typeAdapter = new TypeAdapter<InetAddress>(){

            @Override
            public InetAddress read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return InetAddress.getByName(jsonReader.nextString());
            }

            @Override
            public void write(JsonWriter jsonWriter, InetAddress object) throws IOException {
                object = object == null ? null : ((InetAddress)object).getHostAddress();
                jsonWriter.value((String)object);
            }
        };
        INET_ADDRESS_FACTORY = TypeAdapters.newTypeHierarchyFactory(InetAddress.class, typeAdapter);
        UUID = typeAdapter = new TypeAdapter<UUID>(){

            @Override
            public UUID read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                String string2 = jsonReader.nextString();
                try {
                    UUID uUID = java.util.UUID.fromString(string2);
                    return uUID;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Failed parsing '");
                    stringBuilder.append(string2);
                    stringBuilder.append("' as UUID; at path ");
                    stringBuilder.append(jsonReader.getPreviousPath());
                    throw new JsonSyntaxException(stringBuilder.toString(), illegalArgumentException);
                }
            }

            @Override
            public void write(JsonWriter jsonWriter, UUID object) throws IOException {
                object = object == null ? null : ((UUID)object).toString();
                jsonWriter.value((String)object);
            }
        };
        UUID_FACTORY = TypeAdapters.newFactory(UUID.class, typeAdapter);
        CURRENCY = typeAdapter = new TypeAdapter<Currency>(){

            @Override
            public Currency read(JsonReader jsonReader) throws IOException {
                String string2 = jsonReader.nextString();
                try {
                    Currency currency = Currency.getInstance(string2);
                    return currency;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Failed parsing '");
                    stringBuilder.append(string2);
                    stringBuilder.append("' as Currency; at path ");
                    stringBuilder.append(jsonReader.getPreviousPath());
                    throw new JsonSyntaxException(stringBuilder.toString(), illegalArgumentException);
                }
            }

            @Override
            public void write(JsonWriter jsonWriter, Currency currency) throws IOException {
                jsonWriter.value(currency.getCurrencyCode());
            }
        }.nullSafe();
        CURRENCY_FACTORY = TypeAdapters.newFactory(Currency.class, typeAdapter);
        CALENDAR = typeAdapter = new TypeAdapter<Calendar>(){
            private static final String DAY_OF_MONTH = "dayOfMonth";
            private static final String HOUR_OF_DAY = "hourOfDay";
            private static final String MINUTE = "minute";
            private static final String MONTH = "month";
            private static final String SECOND = "second";
            private static final String YEAR = "year";

            @Override
            public Calendar read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                jsonReader.beginObject();
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                while (jsonReader.peek() != JsonToken.END_OBJECT) {
                    String string2 = jsonReader.nextName();
                    int n7 = jsonReader.nextInt();
                    if (YEAR.equals(string2)) {
                        n = n7;
                        continue;
                    }
                    if (MONTH.equals(string2)) {
                        n2 = n7;
                        continue;
                    }
                    if (DAY_OF_MONTH.equals(string2)) {
                        n3 = n7;
                        continue;
                    }
                    if (HOUR_OF_DAY.equals(string2)) {
                        n4 = n7;
                        continue;
                    }
                    if (MINUTE.equals(string2)) {
                        n5 = n7;
                        continue;
                    }
                    if (!SECOND.equals(string2)) continue;
                    n6 = n7;
                }
                jsonReader.endObject();
                return new GregorianCalendar(n, n2, n3, n4, n5, n6);
            }

            @Override
            public void write(JsonWriter jsonWriter, Calendar calendar) throws IOException {
                if (calendar == null) {
                    jsonWriter.nullValue();
                    return;
                }
                jsonWriter.beginObject();
                jsonWriter.name(YEAR);
                jsonWriter.value(calendar.get(1));
                jsonWriter.name(MONTH);
                jsonWriter.value(calendar.get(2));
                jsonWriter.name(DAY_OF_MONTH);
                jsonWriter.value(calendar.get(5));
                jsonWriter.name(HOUR_OF_DAY);
                jsonWriter.value(calendar.get(11));
                jsonWriter.name(MINUTE);
                jsonWriter.value(calendar.get(12));
                jsonWriter.name(SECOND);
                jsonWriter.value(calendar.get(13));
                jsonWriter.endObject();
            }
        };
        CALENDAR_FACTORY = TypeAdapters.newFactoryForMultipleTypes(Calendar.class, GregorianCalendar.class, typeAdapter);
        LOCALE = typeAdapter = new TypeAdapter<Locale>(){

            @Override
            public Locale read(JsonReader object) throws IOException {
                Object object2 = ((JsonReader)object).peek();
                Object object3 = JsonToken.NULL;
                String string2 = null;
                if (object2 == object3) {
                    ((JsonReader)object).nextNull();
                    return null;
                }
                object3 = new StringTokenizer(((JsonReader)object).nextString(), "_");
                object = ((StringTokenizer)object3).hasMoreElements() ? ((StringTokenizer)object3).nextToken() : null;
                object2 = ((StringTokenizer)object3).hasMoreElements() ? ((StringTokenizer)object3).nextToken() : null;
                if (((StringTokenizer)object3).hasMoreElements()) {
                    string2 = ((StringTokenizer)object3).nextToken();
                }
                if (object2 == null && string2 == null) {
                    return new Locale((String)object);
                }
                if (string2 == null) {
                    return new Locale((String)object, (String)object2);
                }
                return new Locale((String)object, (String)object2, string2);
            }

            @Override
            public void write(JsonWriter jsonWriter, Locale object) throws IOException {
                object = object == null ? null : ((Locale)object).toString();
                jsonWriter.value((String)object);
            }
        };
        LOCALE_FACTORY = TypeAdapters.newFactory(Locale.class, typeAdapter);
        JSON_ELEMENT = typeAdapter = new TypeAdapter<JsonElement>(){

            @Override
            public JsonElement read(JsonReader jsonReader) throws IOException {
                if (jsonReader instanceof JsonTreeReader) {
                    return ((JsonTreeReader)jsonReader).nextJsonElement();
                }
                switch (35.$SwitchMap$com$google$gson$stream$JsonToken[jsonReader.peek().ordinal()]) {
                    default: {
                        throw new IllegalArgumentException();
                    }
                    case 6: {
                        JsonObject jsonObject = new JsonObject();
                        jsonReader.beginObject();
                        while (jsonReader.hasNext()) {
                            jsonObject.add(jsonReader.nextName(), this.read(jsonReader));
                        }
                        jsonReader.endObject();
                        return jsonObject;
                    }
                    case 5: {
                        JsonArray jsonArray = new JsonArray();
                        jsonReader.beginArray();
                        while (jsonReader.hasNext()) {
                            jsonArray.add(this.read(jsonReader));
                        }
                        jsonReader.endArray();
                        return jsonArray;
                    }
                    case 4: {
                        jsonReader.nextNull();
                        return JsonNull.INSTANCE;
                    }
                    case 3: {
                        return new JsonPrimitive(jsonReader.nextBoolean());
                    }
                    case 2: {
                        return new JsonPrimitive(jsonReader.nextString());
                    }
                    case 1: 
                }
                return new JsonPrimitive(new LazilyParsedNumber(jsonReader.nextString()));
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void write(JsonWriter object, JsonElement object2) throws IOException {
                if (object2 != null && !((JsonElement)object2).isJsonNull()) {
                    if (((JsonElement)object2).isJsonPrimitive()) {
                        if (((JsonPrimitive)(object2 = ((JsonElement)object2).getAsJsonPrimitive())).isNumber()) {
                            ((JsonWriter)object).value(((JsonPrimitive)object2).getAsNumber());
                            return;
                        }
                        if (((JsonPrimitive)object2).isBoolean()) {
                            ((JsonWriter)object).value(((JsonPrimitive)object2).getAsBoolean());
                            return;
                        }
                        ((JsonWriter)object).value(((JsonPrimitive)object2).getAsString());
                        return;
                    }
                    if (((JsonElement)object2).isJsonArray()) {
                        ((JsonWriter)object).beginArray();
                        object2 = ((JsonElement)object2).getAsJsonArray().iterator();
                        while (true) {
                            if (!object2.hasNext()) {
                                ((JsonWriter)object).endArray();
                                return;
                            }
                            this.write((JsonWriter)object, object2.next());
                        }
                    }
                    if (!((JsonElement)object2).isJsonObject()) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Couldn't write ");
                        ((StringBuilder)object).append(object2.getClass());
                        throw new IllegalArgumentException(((StringBuilder)object).toString());
                    }
                    ((JsonWriter)object).beginObject();
                    Iterator<Map.Entry<String, JsonElement>> iterator2 = ((JsonElement)object2).getAsJsonObject().entrySet().iterator();
                    while (true) {
                        if (!iterator2.hasNext()) {
                            ((JsonWriter)object).endObject();
                            return;
                        }
                        object2 = iterator2.next();
                        ((JsonWriter)object).name((String)object2.getKey());
                        this.write((JsonWriter)object, (JsonElement)object2.getValue());
                    }
                }
                ((JsonWriter)object).nullValue();
            }
        };
        JSON_ELEMENT_FACTORY = TypeAdapters.newTypeHierarchyFactory(JsonElement.class, typeAdapter);
        ENUM_FACTORY = new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson clazz, TypeToken<T> object) {
                if (Enum.class.isAssignableFrom((Class<?>)(object = ((TypeToken)object).getRawType())) && object != Enum.class) {
                    clazz = object;
                    if (!((Class)object).isEnum()) {
                        clazz = ((Class)object).getSuperclass();
                    }
                    return new EnumTypeAdapter(clazz);
                }
                return null;
            }
        };
    }

    private TypeAdapters() {
        throw new UnsupportedOperationException();
    }

    public static <TT> TypeAdapterFactory newFactory(final TypeToken<TT> typeToken, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson typeAdapter2, TypeToken<T> typeToken2) {
                typeAdapter2 = typeToken2.equals(typeToken) ? typeAdapter : null;
                return typeAdapter2;
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final Class<TT> clazz, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson typeAdapter2, TypeToken<T> typeToken) {
                typeAdapter2 = typeToken.getRawType() == clazz ? typeAdapter : null;
                return typeAdapter2;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Factory[type=");
                stringBuilder.append(clazz.getName());
                stringBuilder.append(",adapter=");
                stringBuilder.append(typeAdapter);
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final Class<TT> clazz, final Class<TT> clazz2, final TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson clazz3, TypeToken<T> typeToken) {
                clazz3 = typeToken.getRawType();
                clazz3 = clazz3 != clazz && clazz3 != clazz2 ? null : typeAdapter;
                return clazz3;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Factory[type=");
                stringBuilder.append(clazz2.getName());
                stringBuilder.append("+");
                stringBuilder.append(clazz.getName());
                stringBuilder.append(",adapter=");
                stringBuilder.append(typeAdapter);
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactoryForMultipleTypes(final Class<TT> clazz, final Class<? extends TT> clazz2, final TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson clazz3, TypeToken<T> typeToken) {
                clazz3 = typeToken.getRawType();
                clazz3 = clazz3 != clazz && clazz3 != clazz2 ? null : typeAdapter;
                return clazz3;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Factory[type=");
                stringBuilder.append(clazz.getName());
                stringBuilder.append("+");
                stringBuilder.append(clazz2.getName());
                stringBuilder.append(",adapter=");
                stringBuilder.append(typeAdapter);
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
        };
    }

    public static <T1> TypeAdapterFactory newTypeHierarchyFactory(final Class<T1> clazz, final TypeAdapter<T1> typeAdapter) {
        return new TypeAdapterFactory(){

            public <T2> TypeAdapter<T2> create(final Gson clazz2, TypeToken<T2> typeToken) {
                clazz2 = typeToken.getRawType();
                if (!clazz.isAssignableFrom(clazz2)) {
                    return null;
                }
                return new TypeAdapter<T1>(){

                    @Override
                    public T1 read(JsonReader jsonReader) throws IOException {
                        Object t = typeAdapter.read(jsonReader);
                        if (t != null && !clazz2.isInstance(t)) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("Expected a ");
                            stringBuilder.append(clazz2.getName());
                            stringBuilder.append(" but was ");
                            stringBuilder.append(t.getClass().getName());
                            stringBuilder.append("; at path ");
                            stringBuilder.append(jsonReader.getPreviousPath());
                            throw new JsonSyntaxException(stringBuilder.toString());
                        }
                        return t;
                    }

                    @Override
                    public void write(JsonWriter jsonWriter, T1 T1) throws IOException {
                        typeAdapter.write(jsonWriter, T1);
                    }
                };
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Factory[typeHierarchy=");
                stringBuilder.append(clazz.getName());
                stringBuilder.append(",adapter=");
                stringBuilder.append(typeAdapter);
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
        };
    }

    private static final class EnumTypeAdapter<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final Map<T, String> constantToName;
        private final Map<String, T> nameToConstant = new HashMap<String, T>();

        public EnumTypeAdapter(Class<T> object) {
            PrivilegedAction<Field[]> privilegedAction;
            this.constantToName = new HashMap<T, String>();
            try {
                privilegedAction = new PrivilegedAction<Field[]>((Class)object){
                    final /* synthetic */ Class val$classOfT;
                    {
                        this.val$classOfT = clazz;
                    }

                    @Override
                    public Field[] run() {
                        AccessibleObject[] accessibleObjectArray = this.val$classOfT.getDeclaredFields();
                        ArrayList<Field> arrayList = new ArrayList<Field>(accessibleObjectArray.length);
                        for (Field field : accessibleObjectArray) {
                            if (!field.isEnumConstant()) continue;
                            arrayList.add(field);
                        }
                        accessibleObjectArray = arrayList.toArray(new Field[0]);
                        AccessibleObject.setAccessible(accessibleObjectArray, true);
                        return accessibleObjectArray;
                    }
                };
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            for (Field field : AccessController.doPrivileged(privilegedAction)) {
                Enum enum_;
                block8: {
                    enum_ = (Enum)field.get(null);
                    object = enum_.name();
                    String[] stringArray = field.getAnnotation(SerializedName.class);
                    if (stringArray == null) break block8;
                    String string2 = stringArray.value();
                    stringArray = stringArray.alternate();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (true) {
                        object = string2;
                        if (n2 >= n) break;
                        object = stringArray[n2];
                        this.nameToConstant.put((String)object, enum_);
                        ++n2;
                        continue;
                        break;
                    }
                }
                this.nameToConstant.put((String)object, enum_);
                this.constantToName.put(enum_, (String)object);
            }
            return;
        }

        @Override
        public T read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return (T)((Enum)this.nameToConstant.get(jsonReader.nextString()));
        }

        @Override
        public void write(JsonWriter jsonWriter, T object) throws IOException {
            object = object == null ? null : this.constantToName.get(object);
            jsonWriter.value((String)object);
        }
    }
}

