/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Objects;

public class JsonReader
implements Closeable {
    static final int BUFFER_SIZE = 1024;
    private static final long MIN_INCOMPLETE_INTEGER = -922337203685477580L;
    private static final int NUMBER_CHAR_DECIMAL = 3;
    private static final int NUMBER_CHAR_DIGIT = 2;
    private static final int NUMBER_CHAR_EXP_DIGIT = 7;
    private static final int NUMBER_CHAR_EXP_E = 5;
    private static final int NUMBER_CHAR_EXP_SIGN = 6;
    private static final int NUMBER_CHAR_FRACTION_DIGIT = 4;
    private static final int NUMBER_CHAR_NONE = 0;
    private static final int NUMBER_CHAR_SIGN = 1;
    private static final int PEEKED_BEGIN_ARRAY = 3;
    private static final int PEEKED_BEGIN_OBJECT = 1;
    private static final int PEEKED_BUFFERED = 11;
    private static final int PEEKED_DOUBLE_QUOTED = 9;
    private static final int PEEKED_DOUBLE_QUOTED_NAME = 13;
    private static final int PEEKED_END_ARRAY = 4;
    private static final int PEEKED_END_OBJECT = 2;
    private static final int PEEKED_EOF = 17;
    private static final int PEEKED_FALSE = 6;
    private static final int PEEKED_LONG = 15;
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_NULL = 7;
    private static final int PEEKED_NUMBER = 16;
    private static final int PEEKED_SINGLE_QUOTED = 8;
    private static final int PEEKED_SINGLE_QUOTED_NAME = 12;
    private static final int PEEKED_TRUE = 5;
    private static final int PEEKED_UNQUOTED = 10;
    private static final int PEEKED_UNQUOTED_NAME = 14;
    private final char[] buffer = new char[1024];
    private final Reader in;
    private boolean lenient = false;
    private int limit = 0;
    private int lineNumber = 0;
    private int lineStart = 0;
    private int[] pathIndices;
    private String[] pathNames;
    int peeked = 0;
    private long peekedLong;
    private int peekedNumberLength;
    private String peekedString;
    private int pos = 0;
    private int[] stack;
    private int stackSize;

    static {
        JsonReaderInternalAccess.INSTANCE = new JsonReaderInternalAccess(){

            @Override
            public void promoteNameToValue(JsonReader jsonReader) throws IOException {
                block8: {
                    block6: {
                        int n;
                        block7: {
                            block5: {
                                int n2;
                                if (jsonReader instanceof JsonTreeReader) {
                                    ((JsonTreeReader)jsonReader).promoteNameToValue();
                                    return;
                                }
                                n = n2 = jsonReader.peeked;
                                if (n2 == 0) {
                                    n = jsonReader.doPeek();
                                }
                                if (n != 13) break block5;
                                jsonReader.peeked = 9;
                                break block6;
                            }
                            if (n != 12) break block7;
                            jsonReader.peeked = 8;
                            break block6;
                        }
                        if (n != 14) break block8;
                        jsonReader.peeked = 10;
                    }
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Expected a name but was ");
                stringBuilder.append((Object)jsonReader.peek());
                stringBuilder.append(jsonReader.locationString());
                throw new IllegalStateException(stringBuilder.toString());
            }
        };
    }

    public JsonReader(Reader reader) {
        int[] nArray = new int[32];
        this.stack = nArray;
        this.stackSize = 0;
        this.stackSize = 0 + 1;
        nArray[0] = 6;
        this.pathNames = new String[32];
        this.pathIndices = new int[32];
        Objects.requireNonNull(reader, "in == null");
        this.in = reader;
    }

    private void checkLenient() throws IOException {
        if (this.lenient) {
            return;
        }
        throw this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
    }

    private void consumeNonExecutePrefix() throws IOException {
        int n;
        this.nextNonWhitespace(true);
        this.pos = n = this.pos - 1;
        if (n + 5 > this.limit && !this.fillBuffer(5)) {
            return;
        }
        char[] cArray = this.buffer;
        n = this.pos;
        if (cArray[n] == ')' && cArray[n + 1] == ']' && cArray[n + 2] == '}' && cArray[n + 3] == '\'' && cArray[n + 4] == '\n') {
            this.pos = n + 5;
        }
    }

    private boolean fillBuffer(int n) throws IOException {
        block7: {
            char[] cArray = this.buffer;
            int n2 = this.lineStart;
            int n3 = this.pos;
            this.lineStart = n2 - n3;
            n2 = this.limit;
            if (n2 != n3) {
                this.limit = n2 -= n3;
                System.arraycopy(cArray, n3, cArray, 0, n2);
            } else {
                this.limit = 0;
            }
            this.pos = 0;
            do {
                Reader reader = this.in;
                n3 = this.limit;
                if ((n3 = reader.read(cArray, n3, cArray.length - n3)) == -1) break block7;
                this.limit = n2 = this.limit + n3;
                n3 = n;
                if (this.lineNumber == 0) {
                    int n4 = this.lineStart;
                    n3 = n;
                    if (n4 == 0) {
                        n3 = n;
                        if (n2 > 0) {
                            n3 = n;
                            if (cArray[0] == '\ufeff') {
                                ++this.pos;
                                this.lineStart = n4 + 1;
                                n3 = n + 1;
                            }
                        }
                    }
                }
                n = n3;
            } while (n2 < n3);
            return true;
        }
        return false;
    }

    private String getPath(boolean bl) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('$');
        for (int i = 0; i < (n = this.stackSize); ++i) {
            int n2;
            int n3 = this.stack[i];
            if (n3 != 1 && n3 != 2) {
                if (n3 != 3 && n3 != 4 && n3 != 5) continue;
                stringBuilder.append('.');
                String[] stringArray = this.pathNames;
                if (stringArray[i] == null) continue;
                stringBuilder.append(stringArray[i]);
                continue;
            }
            n3 = n2 = this.pathIndices[i];
            if (bl) {
                n3 = n2;
                if (n2 > 0) {
                    n3 = n2;
                    if (i == n - 1) {
                        n3 = n2 - 1;
                    }
                }
            }
            stringBuilder.append('[');
            stringBuilder.append(n3);
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    /*
     * Unable to fully structure code
     */
    private boolean isLiteral(char var1_1) throws IOException {
        block4: {
            if (var1_1 == '\t' || var1_1 == '\n' || var1_1 == '\f' || var1_1 == '\r' || var1_1 == ' ') break block4;
            if (var1_1 == '#') ** GOTO lbl-1000
            if (var1_1 == ',') break block4;
            if (var1_1 == '/' || var1_1 == '=') ** GOTO lbl-1000
            if (var1_1 == '{' || var1_1 == '}' || var1_1 == ':') break block4;
            if (var1_1 == ';') ** GOTO lbl-1000
            switch (var1_1) {
                default: {
                    return true;
                }
                case '\\': lbl-1000:
                // 4 sources

                {
                    this.checkLenient();
                }
                case '[': 
                case ']': 
            }
        }
        return false;
    }

    private int nextNonWhitespace(boolean bl) throws IOException {
        Object object = this.buffer;
        Object object2 = this.pos;
        int n = this.limit;
        while (true) {
            int n2 = object2;
            int n3 = n;
            if (object2 == n) {
                this.pos = object2;
                if (!this.fillBuffer(1)) {
                    if (!bl) {
                        return -1;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("End of input");
                    ((StringBuilder)object).append(this.locationString());
                    throw new EOFException(((StringBuilder)object).toString());
                }
                n2 = this.pos;
                n3 = this.limit;
            }
            object2 = n2 + 1;
            n = object[n2];
            if (n == 10) {
                ++this.lineNumber;
                this.lineStart = object2;
            } else if (n != 32 && n != 13 && n != 9) {
                if (n == 47) {
                    this.pos = object2;
                    if (object2 == n3) {
                        this.pos = object2 - 1;
                        boolean bl2 = this.fillBuffer(2);
                        ++this.pos;
                        if (!bl2) {
                            return n;
                        }
                    }
                    this.checkLenient();
                    n3 = this.pos;
                    object2 = object[n3];
                    if (object2 != 42) {
                        if (object2 != 47) {
                            return n;
                        }
                        this.pos = n3 + 1;
                        this.skipToEndOfLine();
                        object2 = this.pos;
                        n = this.limit;
                        continue;
                    }
                    this.pos = n3 + 1;
                    if (this.skipTo("*/")) {
                        object2 = this.pos + 2;
                        n = this.limit;
                        continue;
                    }
                    throw this.syntaxError("Unterminated comment");
                }
                if (n == 35) {
                    this.pos = object2;
                    this.checkLenient();
                    this.skipToEndOfLine();
                    object2 = this.pos;
                    n = this.limit;
                    continue;
                }
                this.pos = object2;
                return n;
            }
            n = n3;
        }
    }

    private String nextQuotedValue(char c) throws IOException {
        char[] cArray = this.buffer;
        StringBuilder stringBuilder = null;
        while (true) {
            StringBuilder stringBuilder2;
            int n;
            int n2 = this.pos;
            int n3 = this.limit;
            block1: while (true) {
                int n4 = n2;
                while ((n = n4) < n3) {
                    n4 = n + 1;
                    if ((n = cArray[n]) == c) {
                        this.pos = n4;
                        c = (char)(n4 - n2 - 1);
                        if (stringBuilder == null) {
                            return new String(cArray, n2, (int)c);
                        }
                        stringBuilder.append(cArray, n2, (int)c);
                        return stringBuilder.toString();
                    }
                    if (n == 92) {
                        this.pos = n4;
                        n4 = n4 - n2 - 1;
                        stringBuilder2 = stringBuilder;
                        if (stringBuilder == null) {
                            stringBuilder2 = new StringBuilder(Math.max((n4 + 1) * 2, 16));
                        }
                        stringBuilder2.append(cArray, n2, n4);
                        stringBuilder2.append(this.readEscapeCharacter());
                        n2 = this.pos;
                        n3 = this.limit;
                        stringBuilder = stringBuilder2;
                        continue block1;
                    }
                    if (n != 10) continue;
                    ++this.lineNumber;
                    this.lineStart = n4;
                }
                break;
            }
            stringBuilder2 = stringBuilder;
            if (stringBuilder == null) {
                stringBuilder2 = new StringBuilder(Math.max((n - n2) * 2, 16));
            }
            stringBuilder2.append(cArray, n2, n - n2);
            this.pos = n;
            if (!this.fillBuffer(1)) break;
            stringBuilder = stringBuilder2;
        }
        throw this.syntaxError("Unterminated string");
    }

    /*
     * Unable to fully structure code
     */
    private String nextUnquotedValue() throws IOException {
        block10: {
            var1_1 = 0;
            var2_2 = null;
            do {
                var3_3 = 0;
                block5: while (true) {
                    block11: {
                        if ((var4_4 = this.pos) + var3_3 >= this.limit) break block11;
                        if ((var4_4 = this.buffer[var4_4 + var3_3]) == 9 || var4_4 == 10 || var4_4 == 12 || var4_4 == 13 || var4_4 == 32) break block10;
                        if (var4_4 == 35) ** GOTO lbl-1000
                        if (var4_4 == 44) break block10;
                        if (var4_4 == 47 || var4_4 == 61) ** GOTO lbl-1000
                        if (var4_4 == 123 || var4_4 == 125 || var4_4 == 58) break block10;
                        if (var4_4 == 59) ** GOTO lbl-1000
                        switch (var4_4) {
                            default: {
                                ++var3_3;
                                continue block5;
                            }
                            case 92: lbl-1000:
                            // 4 sources

                            {
                                this.checkLenient();
                                break block10;
                            }
                            case 91: 
                            case 93: {
                                break block10;
                            }
                        }
                    }
                    if (var3_3 >= this.buffer.length) break;
                    if (this.fillBuffer(var3_3 + 1)) {
                        continue;
                    }
                    break block10;
                    break;
                }
                var5_5 = var2_2;
                if (var2_2 == null) {
                    var5_5 = new StringBuilder(Math.max(var3_3, 16));
                }
                var5_5.append(this.buffer, this.pos, var3_3);
                this.pos += var3_3;
                var2_2 = var5_5;
            } while (this.fillBuffer(1));
            var2_2 = var5_5;
            var3_3 = var1_1;
        }
        if (var2_2 == null) {
            var2_2 = new String(this.buffer, this.pos, var3_3);
        } else {
            var2_2.append(this.buffer, this.pos, var3_3);
            var2_2 = var2_2.toString();
        }
        this.pos += var3_3;
        return var2_2;
    }

    private int peekKeyword() throws IOException {
        String string2;
        String string3;
        int n = this.buffer[this.pos];
        if (n != 116 && n != 84) {
            if (n != 102 && n != 70) {
                if (n != 110 && n != 78) {
                    return 0;
                }
                n = 7;
                string3 = "null";
                string2 = "NULL";
            } else {
                n = 6;
                string3 = "false";
                string2 = "FALSE";
            }
        } else {
            n = 5;
            string3 = "true";
            string2 = "TRUE";
        }
        int n2 = string3.length();
        for (int i = 1; i < n2; ++i) {
            if (this.pos + i >= this.limit && !this.fillBuffer(i + 1)) {
                return 0;
            }
            char c = this.buffer[this.pos + i];
            if (c == string3.charAt(i) || c == string2.charAt(i)) continue;
            return 0;
        }
        if ((this.pos + n2 < this.limit || this.fillBuffer(n2 + 1)) && this.isLiteral(this.buffer[this.pos + n2])) {
            return 0;
        }
        this.pos += n2;
        this.peeked = n;
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private int peekNumber() throws IOException {
        var1_1 = this.buffer;
        var2_2 = this.pos;
        var3_3 = this.limit;
        var4_4 = 0;
        var5_5 = 0;
        var6_6 = 1;
        var7_7 = 0L;
        var9_8 = false;
        while (true) {
            block25: {
                block29: {
                    block17: {
                        block18: {
                            block28: {
                                block19: {
                                    block27: {
                                        block20: {
                                            block26: {
                                                block16: {
                                                    block21: {
                                                        block22: {
                                                            block24: {
                                                                block23: {
                                                                    block15: {
                                                                        var10_9 = var2_2;
                                                                        var11_10 = var3_3;
                                                                        if (var2_2 + var4_4 != var3_3) break block15;
                                                                        if (var4_4 == var1_1.length) {
                                                                            return 0;
                                                                        }
                                                                        if (!this.fillBuffer(var4_4 + 1)) break block16;
                                                                        var10_9 = this.pos;
                                                                        var11_10 = this.limit;
                                                                    }
                                                                    if ((var12_11 = var1_1[var10_9 + var4_4]) == '+') break block17;
                                                                    if (var12_11 == 'E' || var12_11 == 'e') break block18;
                                                                    if (var12_11 == '-') break block19;
                                                                    if (var12_11 == '.') break block20;
                                                                    if (var12_11 < '0' || var12_11 > '9') break block21;
                                                                    if (var5_5 == 1 || var5_5 == 0) break block22;
                                                                    if (var5_5 != 2) break block23;
                                                                    if (var7_7 == 0L) {
                                                                        return 0;
                                                                    }
                                                                    var13_12 = 10L * var7_7 - (long)(var12_11 - 48);
                                                                    cfr_temp_0 = var7_7 - -922337203685477580L;
                                                                    var3_3 = cfr_temp_0 == 0L ? 0 : (cfr_temp_0 < 0L ? -1 : 1);
                                                                    var3_3 = var3_3 <= 0 && (var3_3 != 0 || var13_12 >= var7_7) ? 0 : 1;
                                                                    var3_3 = var6_6 & var3_3;
                                                                    ** GOTO lbl-1000
                                                                }
                                                                if (var5_5 != 3) break block24;
                                                                var5_5 = 4;
                                                                break block25;
                                                            }
                                                            if (var5_5 != 5) {
                                                                var3_3 = var6_6;
                                                                var13_12 = var7_7;
                                                                ** if (var5_5 == 6) goto lbl-1000
                                                            }
                                                            ** GOTO lbl-1000
lbl-1000:
                                                            // 2 sources

                                                            {
                                                                var6_6 = var3_3;
                                                                var7_7 = var13_12;
                                                                ** GOTO lbl94
                                                            }
lbl-1000:
                                                            // 2 sources

                                                            {
                                                                var5_5 = 7;
                                                            }
                                                            break block25;
                                                        }
                                                        var7_7 = -(var12_11 - 48);
                                                        var5_5 = 2;
                                                        break block25;
                                                    }
                                                    if (this.isLiteral(var12_11)) break block26;
                                                }
                                                if (!(var5_5 != 2 || var6_6 == 0 || var7_7 == -9223372036854775808L && !var9_8 || var7_7 == 0L && var9_8)) {
                                                    if (!var9_8) {
                                                        var7_7 = -var7_7;
                                                    }
                                                    this.peekedLong = var7_7;
                                                    this.pos += var4_4;
                                                    this.peeked = 15;
                                                    return 15;
                                                }
                                                if (var5_5 != 2 && var5_5 != 4 && var5_5 != 7) {
                                                    return 0;
                                                }
                                                this.peekedNumberLength = var4_4;
                                                this.peeked = 16;
                                                return 16;
                                            }
                                            return 0;
                                        }
                                        if (var5_5 != 2) break block27;
                                        var5_5 = 3;
                                        break block25;
                                    }
                                    return 0;
                                }
                                if (var5_5 != 0) break block28;
                                var5_5 = 1;
                                var9_8 = true;
                                break block25;
                            }
                            if (var5_5 != 5) {
                                return 0;
                            }
                            break block29;
                        }
                        if (var5_5 != 2 && var5_5 != 4) {
                            return 0;
                        }
                        var5_5 = 5;
                        break block25;
                    }
                    if (var5_5 != 5) break;
                }
                var5_5 = 6;
            }
            ++var4_4;
            var2_2 = var10_9;
            var3_3 = var11_10;
        }
        return 0;
    }

    private void push(int n) {
        int n2 = this.stackSize;
        int[] nArray = this.stack;
        if (n2 == nArray.length) {
            this.stack = Arrays.copyOf(nArray, n2 *= 2);
            this.pathIndices = Arrays.copyOf(this.pathIndices, n2);
            this.pathNames = Arrays.copyOf(this.pathNames, n2);
        }
        nArray = this.stack;
        n2 = this.stackSize;
        this.stackSize = n2 + 1;
        nArray[n2] = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private char readEscapeCharacter() throws IOException {
        int n;
        int n2;
        int n3;
        Object object;
        block16: {
            block15: {
                block14: {
                    if (this.pos == this.limit && !this.fillBuffer(1)) {
                        throw this.syntaxError("Unterminated escape sequence");
                    }
                    object = this.buffer;
                    n3 = this.pos;
                    this.pos = n2 = n3 + 1;
                    n = object[n3];
                    if (n == 10) break block14;
                    if (n == 34 || n == 39 || n == 47 || n == 92) break block15;
                    if (n == 98) {
                        return '\b';
                    }
                    if (n == 102) {
                        return '\f';
                    }
                    if (n == 110) {
                        return '\n';
                    }
                    if (n == 114) {
                        return '\r';
                    }
                    if (n == 116) {
                        return '\t';
                    }
                    if (n != 117) {
                        throw this.syntaxError("Invalid escape sequence");
                    }
                    if (n2 + 4 > this.limit && !this.fillBuffer(4)) {
                        throw this.syntaxError("Unterminated escape sequence");
                    }
                    break block16;
                }
                ++this.lineNumber;
                this.lineStart = n2;
            }
            return (char)n;
        }
        int n4 = 0;
        n3 = n2 = this.pos;
        n = n4;
        while (true) {
            if ((n4 = n3) >= n2 + 4) {
                this.pos += 4;
                return (char)n;
            }
            n3 = this.buffer[n4];
            char c = (char)(n << 4);
            if (n3 >= 48 && n3 <= 57) {
                n3 -= 48;
            } else {
                if (n3 >= 97 && n3 <= 102) {
                    n3 -= 97;
                } else {
                    if (n3 < 65 || n3 > 70) break;
                    n3 -= 65;
                }
                n3 += 10;
            }
            c = (char)(c + n3);
            n3 = n4 + 1;
            n = c;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("\\u");
        ((StringBuilder)object).append(new String(this.buffer, this.pos, 4));
        throw new NumberFormatException(((StringBuilder)object).toString());
    }

    private void skipQuotedValue(char c) throws IOException {
        char[] cArray = this.buffer;
        do {
            int n = this.pos;
            int n2 = this.limit;
            while (n < n2) {
                int n3 = n + 1;
                if ((n = cArray[n]) == c) {
                    this.pos = n3;
                    return;
                }
                if (n == 92) {
                    this.pos = n3;
                    this.readEscapeCharacter();
                    n = this.pos;
                    n2 = this.limit;
                    continue;
                }
                if (n == 10) {
                    ++this.lineNumber;
                    this.lineStart = n3;
                }
                n = n3;
            }
            this.pos = n;
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    private boolean skipTo(String string2) throws IOException {
        int n = string2.length();
        block0: while (true) {
            int n2 = ++this.pos;
            int n3 = this.limit;
            if (n2 + n > n3 && !this.fillBuffer(n)) {
                return false;
            }
            char[] cArray = this.buffer;
            n3 = this.pos;
            if (cArray[n3] == '\n') {
                ++this.lineNumber;
                this.lineStart = n3 + 1;
                continue;
            }
            for (int i = 0; i < n; ++i) {
                if (this.buffer[this.pos + i] == string2.charAt(i)) continue;
                continue block0;
            }
            break;
        }
        return true;
    }

    private void skipToEndOfLine() throws IOException {
        while (this.pos < this.limit || this.fillBuffer(1)) {
            int n;
            char[] cArray = this.buffer;
            int n2 = this.pos;
            this.pos = n = n2 + 1;
            if ((n2 = cArray[n2]) == 10) {
                ++this.lineNumber;
                this.lineStart = n;
                break;
            }
            if (n2 != 13) continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void skipUnquotedValue() throws IOException {
        do {
            var1_1 = 0;
            block5: while ((var2_2 = this.pos) + var1_1 < this.limit) {
                block6: {
                    if ((var2_2 = this.buffer[var2_2 + var1_1]) == 9 || var2_2 == 10 || var2_2 == 12 || var2_2 == 13 || var2_2 == 32) break block6;
                    if (var2_2 == 35) ** GOTO lbl-1000
                    if (var2_2 == 44) break block6;
                    if (var2_2 == 47 || var2_2 == 61) ** GOTO lbl-1000
                    if (var2_2 == 123 || var2_2 == 125 || var2_2 == 58) break block6;
                    if (var2_2 == 59) ** GOTO lbl-1000
                    switch (var2_2) {
                        default: {
                            ++var1_1;
                            continue block5;
                        }
                        case 92: lbl-1000:
                        // 4 sources

                        {
                            this.checkLenient();
                        }
                        case 91: 
                        case 93: 
                    }
                }
                this.pos += var1_1;
                return;
            }
            this.pos = var2_2 + var1_1;
        } while (this.fillBuffer(1));
    }

    private IOException syntaxError(String string2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(this.locationString());
        throw new MalformedJsonException(stringBuilder.toString());
    }

    public void beginArray() throws IOException {
        int n;
        int n2 = n = this.peeked;
        if (n == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 3) {
            this.push(1);
            this.pathIndices[this.stackSize - 1] = 0;
            this.peeked = 0;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected BEGIN_ARRAY but was ");
        stringBuilder.append((Object)this.peek());
        stringBuilder.append(this.locationString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public void beginObject() throws IOException {
        int n;
        int n2 = n = this.peeked;
        if (n == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 1) {
            this.push(3);
            this.peeked = 0;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected BEGIN_OBJECT but was ");
        stringBuilder.append((Object)this.peek());
        stringBuilder.append(this.locationString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    @Override
    public void close() throws IOException {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
        this.in.close();
    }

    int doPeek() throws IOException {
        int n;
        int n2;
        block32: {
            block37: {
                block30: {
                    block36: {
                        block35: {
                            block33: {
                                block34: {
                                    Object[] objectArray;
                                    block31: {
                                        block29: {
                                            objectArray = this.stack;
                                            n2 = this.stackSize;
                                            n = objectArray[n2 - 1];
                                            if (n != 1) break block29;
                                            objectArray[n2 - 1] = 2;
                                            break block30;
                                        }
                                        if (n != 2) break block31;
                                        n2 = this.nextNonWhitespace(true);
                                        if (n2 != 44) {
                                            if (n2 != 59) {
                                                if (n2 == 93) {
                                                    this.peeked = 4;
                                                    return 4;
                                                }
                                                throw this.syntaxError("Unterminated array");
                                            }
                                            this.checkLenient();
                                        }
                                        break block30;
                                    }
                                    if (n == 3 || n == 5) break block32;
                                    if (n != 4) break block33;
                                    objectArray[n2 - 1] = 5;
                                    n2 = this.nextNonWhitespace(true);
                                    if (n2 == 58) break block30;
                                    if (n2 != 61) break block34;
                                    this.checkLenient();
                                    if ((this.pos < this.limit || this.fillBuffer(1)) && (objectArray = (Object[])this.buffer)[n2 = this.pos] == 62) {
                                        this.pos = n2 + 1;
                                    }
                                    break block30;
                                }
                                throw this.syntaxError("Expected ':'");
                            }
                            if (n != 6) break block35;
                            if (this.lenient) {
                                this.consumeNonExecutePrefix();
                            }
                            this.stack[this.stackSize - 1] = 7;
                            break block30;
                        }
                        if (n != 7) break block36;
                        if (this.nextNonWhitespace(false) == -1) {
                            this.peeked = 17;
                            return 17;
                        }
                        this.checkLenient();
                        --this.pos;
                        break block30;
                    }
                    if (n == 8) break block37;
                }
                n2 = this.nextNonWhitespace(true);
                if (n2 != 34) {
                    if (n2 != 39) {
                        if (n2 != 44 && n2 != 59) {
                            if (n2 != 91) {
                                if (n2 != 93) {
                                    if (n2 != 123) {
                                        --this.pos;
                                        n = this.peekKeyword();
                                        if (n != 0) {
                                            return n;
                                        }
                                        n = this.peekNumber();
                                        if (n != 0) {
                                            return n;
                                        }
                                        if (this.isLiteral(this.buffer[this.pos])) {
                                            this.checkLenient();
                                            this.peeked = 10;
                                            return 10;
                                        }
                                        throw this.syntaxError("Expected value");
                                    }
                                    this.peeked = 1;
                                    return 1;
                                }
                                if (n == 1) {
                                    this.peeked = 4;
                                    return 4;
                                }
                            } else {
                                this.peeked = 3;
                                return 3;
                            }
                        }
                        if (n != 1 && n != 2) {
                            throw this.syntaxError("Unexpected value");
                        }
                        this.checkLenient();
                        --this.pos;
                        this.peeked = 7;
                        return 7;
                    }
                    this.checkLenient();
                    this.peeked = 8;
                    return 8;
                }
                this.peeked = 9;
                return 9;
            }
            throw new IllegalStateException("JsonReader is closed");
        }
        objectArray[n2 - 1] = 4;
        if (n == 5 && (n2 = this.nextNonWhitespace(true)) != 44) {
            if (n2 != 59) {
                if (n2 == 125) {
                    this.peeked = 2;
                    return 2;
                }
                throw this.syntaxError("Unterminated object");
            }
            this.checkLenient();
        }
        if ((n2 = this.nextNonWhitespace(true)) != 34) {
            if (n2 != 39) {
                if (n2 != 125) {
                    this.checkLenient();
                    --this.pos;
                    if (this.isLiteral((char)n2)) {
                        this.peeked = 14;
                        return 14;
                    }
                    throw this.syntaxError("Expected name");
                }
                if (n != 5) {
                    this.peeked = 2;
                    return 2;
                }
                throw this.syntaxError("Expected name");
            }
            this.checkLenient();
            this.peeked = 12;
            return 12;
        }
        this.peeked = 13;
        return 13;
    }

    public void endArray() throws IOException {
        int n;
        int n2 = n = this.peeked;
        if (n == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 4) {
            n2 = this.stackSize - 1;
            this.stackSize = n2--;
            int[] nArray = this.pathIndices;
            nArray[n2] = nArray[n2] + 1;
            this.peeked = 0;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected END_ARRAY but was ");
        stringBuilder.append((Object)this.peek());
        stringBuilder.append(this.locationString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public void endObject() throws IOException {
        int n;
        int n2 = n = this.peeked;
        if (n == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 2) {
            this.stackSize = n2 = this.stackSize - 1;
            this.pathNames[n2] = null;
            int[] nArray = this.pathIndices;
            nArray[--n2] = nArray[n2] + 1;
            this.peeked = 0;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected END_OBJECT but was ");
        stringBuilder.append((Object)this.peek());
        stringBuilder.append(this.locationString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public String getPath() {
        return this.getPath(false);
    }

    public String getPreviousPath() {
        return this.getPath(true);
    }

    public boolean hasNext() throws IOException {
        int n;
        int n2 = n = this.peeked;
        if (n == 0) {
            n2 = this.doPeek();
        }
        boolean bl = n2 != 2 && n2 != 4 && n2 != 17;
        return bl;
    }

    public final boolean isLenient() {
        return this.lenient;
    }

    String locationString() {
        int n = this.lineNumber;
        int n2 = this.pos;
        int n3 = this.lineStart;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" at line ");
        stringBuilder.append(n + 1);
        stringBuilder.append(" column ");
        stringBuilder.append(n2 - n3 + 1);
        stringBuilder.append(" path ");
        stringBuilder.append(this.getPath());
        return stringBuilder.toString();
    }

    public boolean nextBoolean() throws IOException {
        int n;
        int n2 = n = this.peeked;
        if (n == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 5) {
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            n2 = this.stackSize - 1;
            nArray[n2] = nArray[n2] + 1;
            return true;
        }
        if (n2 == 6) {
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            n2 = this.stackSize - 1;
            nArray[n2] = nArray[n2] + 1;
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected a boolean but was ");
        stringBuilder.append((Object)this.peek());
        stringBuilder.append(this.locationString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public double nextDouble() throws IOException {
        int n;
        int n2 = n = this.peeked;
        if (n == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 15) {
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            n2 = this.stackSize - 1;
            nArray[n2] = nArray[n2] + 1;
            return this.peekedLong;
        }
        if (n2 == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (n2 != 8 && n2 != 9) {
            if (n2 == 10) {
                this.peekedString = this.nextUnquotedValue();
            } else if (n2 != 11) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Expected a double but was ");
                stringBuilder.append((Object)this.peek());
                stringBuilder.append(this.locationString());
                throw new IllegalStateException(stringBuilder.toString());
            }
        } else {
            int n3 = n2 == 8 ? (n2 = 39) : (n2 = 34);
            this.peekedString = this.nextQuotedValue((char)n3);
        }
        this.peeked = 11;
        double d = Double.parseDouble(this.peekedString);
        if (!this.lenient && (Double.isNaN(d) || Double.isInfinite(d))) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("JSON forbids NaN and infinities: ");
            stringBuilder.append(d);
            stringBuilder.append(this.locationString());
            throw new MalformedJsonException(stringBuilder.toString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        n2 = this.stackSize - 1;
        nArray[n2] = nArray[n2] + 1;
        return d;
    }

    public int nextInt() throws IOException {
        int n;
        int n2 = n = this.peeked;
        if (n == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 15) {
            long l = this.peekedLong;
            n = (int)l;
            if (l == (long)n) {
                this.peeked = 0;
                int[] nArray = this.pathIndices;
                n2 = this.stackSize - 1;
                nArray[n2] = nArray[n2] + 1;
                return n;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Expected an int but was ");
            stringBuilder.append(this.peekedLong);
            stringBuilder.append(this.locationString());
            throw new NumberFormatException(stringBuilder.toString());
        }
        if (n2 == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else {
            int[] nArray;
            if (n2 != 8 && n2 != 9 && n2 != 10) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Expected an int but was ");
                stringBuilder.append((Object)this.peek());
                stringBuilder.append(this.locationString());
                throw new IllegalStateException(stringBuilder.toString());
            }
            if (n2 == 10) {
                this.peekedString = this.nextUnquotedValue();
            } else {
                int n3 = n2 == 8 ? (n2 = 39) : (n2 = 34);
                this.peekedString = this.nextQuotedValue((char)n3);
            }
            try {
                n = Integer.parseInt(this.peekedString);
                this.peeked = 0;
                nArray = this.pathIndices;
                n2 = this.stackSize - 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            nArray[n2] = nArray[n2] + 1;
            return n;
        }
        this.peeked = 11;
        double d = Double.parseDouble(this.peekedString);
        n2 = (int)d;
        if ((double)n2 == d) {
            this.peekedString = null;
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            n = this.stackSize - 1;
            nArray[n] = nArray[n] + 1;
            return n2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected an int but was ");
        stringBuilder.append(this.peekedString);
        stringBuilder.append(this.locationString());
        throw new NumberFormatException(stringBuilder.toString());
    }

    public long nextLong() throws IOException {
        int n;
        int n2 = n = this.peeked;
        if (n == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 15) {
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            n2 = this.stackSize - 1;
            nArray[n2] = nArray[n2] + 1;
            return this.peekedLong;
        }
        if (n2 == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else {
            int[] nArray;
            long l;
            if (n2 != 8 && n2 != 9 && n2 != 10) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Expected a long but was ");
                stringBuilder.append((Object)this.peek());
                stringBuilder.append(this.locationString());
                throw new IllegalStateException(stringBuilder.toString());
            }
            if (n2 == 10) {
                this.peekedString = this.nextUnquotedValue();
            } else {
                int n3 = n2 == 8 ? (n2 = 39) : (n2 = 34);
                this.peekedString = this.nextQuotedValue((char)n3);
            }
            try {
                l = Long.parseLong(this.peekedString);
                this.peeked = 0;
                nArray = this.pathIndices;
                n2 = this.stackSize - 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            nArray[n2] = nArray[n2] + 1;
            return l;
        }
        this.peeked = 11;
        double d = Double.parseDouble(this.peekedString);
        long l = (long)d;
        if ((double)l == d) {
            this.peekedString = null;
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            n2 = this.stackSize - 1;
            nArray[n2] = nArray[n2] + 1;
            return l;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected a long but was ");
        stringBuilder.append(this.peekedString);
        stringBuilder.append(this.locationString());
        throw new NumberFormatException(stringBuilder.toString());
    }

    public String nextName() throws IOException {
        block7: {
            String string2;
            block5: {
                int n;
                block6: {
                    block4: {
                        int n2;
                        n = n2 = this.peeked;
                        if (n2 == 0) {
                            n = this.doPeek();
                        }
                        if (n != 14) break block4;
                        string2 = this.nextUnquotedValue();
                        break block5;
                    }
                    if (n != 12) break block6;
                    string2 = this.nextQuotedValue('\'');
                    break block5;
                }
                if (n != 13) break block7;
                string2 = this.nextQuotedValue('\"');
            }
            this.peeked = 0;
            this.pathNames[this.stackSize - 1] = string2;
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected a name but was ");
        stringBuilder.append((Object)this.peek());
        stringBuilder.append(this.locationString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public void nextNull() throws IOException {
        int n;
        int n2 = n = this.peeked;
        if (n == 0) {
            n2 = this.doPeek();
        }
        if (n2 == 7) {
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            n2 = this.stackSize - 1;
            nArray[n2] = nArray[n2] + 1;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected null but was ");
        stringBuilder.append((Object)this.peek());
        stringBuilder.append(this.locationString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public String nextString() throws IOException {
        block10: {
            String string2;
            int n;
            block5: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    int n2;
                                    n = n2 = this.peeked;
                                    if (n2 == 0) {
                                        n = this.doPeek();
                                    }
                                    if (n != 10) break block4;
                                    string2 = this.nextUnquotedValue();
                                    break block5;
                                }
                                if (n != 8) break block6;
                                string2 = this.nextQuotedValue('\'');
                                break block5;
                            }
                            if (n != 9) break block7;
                            string2 = this.nextQuotedValue('\"');
                            break block5;
                        }
                        if (n != 11) break block8;
                        string2 = this.peekedString;
                        this.peekedString = null;
                        break block5;
                    }
                    if (n != 15) break block9;
                    string2 = Long.toString(this.peekedLong);
                    break block5;
                }
                if (n != 16) break block10;
                string2 = new String(this.buffer, this.pos, this.peekedNumberLength);
                this.pos += this.peekedNumberLength;
            }
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            n = this.stackSize - 1;
            nArray[n] = nArray[n] + 1;
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected a string but was ");
        stringBuilder.append((Object)this.peek());
        stringBuilder.append(this.locationString());
        throw new IllegalStateException(stringBuilder.toString());
    }

    public JsonToken peek() throws IOException {
        int n;
        int n2 = n = this.peeked;
        if (n == 0) {
            n2 = this.doPeek();
        }
        switch (n2) {
            default: {
                throw new AssertionError();
            }
            case 17: {
                return JsonToken.END_DOCUMENT;
            }
            case 15: 
            case 16: {
                return JsonToken.NUMBER;
            }
            case 12: 
            case 13: 
            case 14: {
                return JsonToken.NAME;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return JsonToken.STRING;
            }
            case 7: {
                return JsonToken.NULL;
            }
            case 5: 
            case 6: {
                return JsonToken.BOOLEAN;
            }
            case 4: {
                return JsonToken.END_ARRAY;
            }
            case 3: {
                return JsonToken.BEGIN_ARRAY;
            }
            case 2: {
                return JsonToken.END_OBJECT;
            }
            case 1: 
        }
        return JsonToken.BEGIN_OBJECT;
    }

    public final void setLenient(boolean bl) {
        this.lenient = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void skipValue() throws IOException {
        int n;
        int n2 = 0;
        do {
            block8: {
                block12: {
                    block13: {
                        int n3;
                        block11: {
                            block10: {
                                block9: {
                                    block7: {
                                        block6: {
                                            block5: {
                                                n3 = n = this.peeked;
                                                if (n == 0) {
                                                    n3 = this.doPeek();
                                                }
                                                if (n3 != 3) break block5;
                                                this.push(1);
                                                break block6;
                                            }
                                            if (n3 != 1) break block7;
                                            this.push(3);
                                        }
                                        n = n2 + 1;
                                        break block8;
                                    }
                                    if (n3 != 4) break block9;
                                    --this.stackSize;
                                    break block10;
                                }
                                if (n3 != 2) break block11;
                                --this.stackSize;
                            }
                            n = n2 - 1;
                            break block8;
                        }
                        if (n3 == 14 || n3 == 10) break block12;
                        if (n3 == 8 || n3 == 12) break block13;
                        if (n3 != 9 && n3 != 13) {
                            n = n2;
                            if (n3 == 16) {
                                this.pos += this.peekedNumberLength;
                                n = n2;
                            }
                            break block8;
                        } else {
                            this.skipQuotedValue('\"');
                            n = n2;
                        }
                        break block8;
                    }
                    this.skipQuotedValue('\'');
                    n = n2;
                    break block8;
                }
                this.skipUnquotedValue();
                n = n2;
            }
            this.peeked = 0;
            n2 = n;
        } while (n != 0);
        int[] nArray = this.pathIndices;
        n2 = this.stackSize;
        n = n2 - 1;
        nArray[n] = nArray[n] + 1;
        this.pathNames[n2 - 1] = "null";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(this.locationString());
        return stringBuilder.toString();
    }
}

