/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.graphhopper.Trip;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointList;
import com.graphhopper.util.details.PathDetail;
import com.graphhopper.util.shapes.BBox;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PathWrapper {
    private double ascend;
    private String debugInfo = "";
    private double descend;
    private List<String> description;
    private double distance;
    private final List<Throwable> errors = new ArrayList<Throwable>(4);
    private BigDecimal fare;
    private boolean impossible = false;
    private InstructionList instructions;
    private final List<Trip.Leg> legs;
    private int numChanges;
    private Map<String, List<PathDetail>> pathDetails;
    private PointList pointList;
    private double routeWeight;
    private long time;
    private PointList waypointList = PointList.EMPTY;

    public PathWrapper() {
        this.pointList = PointList.EMPTY;
        this.legs = new ArrayList<Trip.Leg>();
        this.pathDetails = new HashMap<String, List<PathDetail>>();
    }

    private void check(String string2) {
        if (!this.hasErrors()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("You cannot call ");
        stringBuilder.append(string2);
        stringBuilder.append(" if response contains errors. Check this with ghResponse.hasErrors(). Errors are: ");
        stringBuilder.append(this.getErrors());
        throw new RuntimeException(stringBuilder.toString());
    }

    public static void merge(List<PathDetail> list, List<PathDetail> list2) {
        PathDetail pathDetail;
        if (!list.isEmpty() && !list2.isEmpty() && (pathDetail = list.get(list.size() - 1)).getValue().equals(list2.get(0).getValue())) {
            pathDetail.setLast(list2.get(0).getLast());
            list2.remove(0);
        }
        list.addAll(list2);
    }

    public PathWrapper addDebugInfo(String string2) {
        if (string2 != null) {
            StringBuilder stringBuilder;
            if (!this.debugInfo.isEmpty()) {
                stringBuilder = new StringBuilder();
                stringBuilder.append(this.debugInfo);
                stringBuilder.append(";");
                this.debugInfo = stringBuilder.toString();
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append(this.debugInfo);
            stringBuilder.append(string2);
            this.debugInfo = stringBuilder.toString();
            return this;
        }
        throw new IllegalStateException("Debug information has to be none null");
    }

    public PathWrapper addError(Throwable throwable) {
        this.errors.add(throwable);
        return this;
    }

    public PathWrapper addErrors(List<Throwable> list) {
        this.errors.addAll(list);
        return this;
    }

    public void addPathDetails(Map<String, List<PathDetail>> object) {
        if (!this.pathDetails.isEmpty() && !object.isEmpty() && this.pathDetails.size() != object.size()) {
            throw new IllegalStateException("Details have to be the same size");
        }
        for (Map.Entry entry : object.entrySet()) {
            if (this.pathDetails.containsKey(entry.getKey())) {
                PathWrapper.merge(this.pathDetails.get(entry.getKey()), (List)entry.getValue());
                continue;
            }
            this.pathDetails.put((String)entry.getKey(), (List<PathDetail>)entry.getValue());
        }
    }

    public BBox calcBBox2D() {
        this.check("calcRouteBBox");
        BBox bBox = BBox.createInverse(false);
        for (int i = 0; i < this.pointList.getSize(); ++i) {
            bBox.update(this.pointList.getLatitude(i), this.pointList.getLongitude(i));
        }
        return bBox;
    }

    public double getAscend() {
        return this.ascend;
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public double getDescend() {
        return this.descend;
    }

    public List<String> getDescription() {
        List<String> list;
        List<String> list2 = list = this.description;
        if (list == null) {
            list2 = Collections.emptyList();
        }
        return list2;
    }

    public double getDistance() {
        this.check("getDistance");
        return this.distance;
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public BigDecimal getFare() {
        return this.fare;
    }

    public InstructionList getInstructions() {
        this.check("getInstructions");
        InstructionList instructionList = this.instructions;
        if (instructionList != null) {
            return instructionList;
        }
        throw new IllegalArgumentException("To access instructions you need to enable creation before routing");
    }

    public List<Trip.Leg> getLegs() {
        return this.legs;
    }

    public int getNumChanges() {
        return this.numChanges;
    }

    public Map<String, List<PathDetail>> getPathDetails() {
        return this.pathDetails;
    }

    public PointList getPoints() {
        this.check("getPoints");
        return this.pointList;
    }

    public double getRouteWeight() {
        this.check("getRouteWeight");
        return this.routeWeight;
    }

    public long getTime() {
        this.check("getTimes");
        return this.time;
    }

    public PointList getWaypoints() {
        this.check("getWaypoints");
        return this.waypointList;
    }

    public boolean hasErrors() {
        return this.errors.isEmpty() ^ true;
    }

    public boolean isImpossible() {
        return this.impossible;
    }

    public PathWrapper setAscend(double d) {
        if (!(d < 0.0) && !Double.isNaN(d)) {
            this.ascend = d;
            return this;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ascend has to be positive but was ");
        stringBuilder.append(d);
        throw new IllegalStateException(stringBuilder.toString());
    }

    public PathWrapper setDescend(double d) {
        if (!(d < 0.0) && !Double.isNaN(d)) {
            this.descend = d;
            return this;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("descend has to be positive but was ");
        stringBuilder.append(d);
        throw new IllegalStateException(stringBuilder.toString());
    }

    public PathWrapper setDescription(List<String> list) {
        this.description = list;
        return this;
    }

    public PathWrapper setDistance(double d) {
        this.distance = d;
        return this;
    }

    public void setFare(BigDecimal bigDecimal) {
        this.fare = bigDecimal;
    }

    public void setImpossible(boolean bl) {
        this.impossible = bl;
    }

    public void setInstructions(InstructionList instructionList) {
        this.instructions = instructionList;
    }

    public void setNumChanges(int n) {
        this.numChanges = n;
    }

    public PathWrapper setPoints(PointList pointList) {
        if (this.pointList == PointList.EMPTY) {
            this.pointList = pointList;
            return this;
        }
        throw new IllegalStateException("Cannot call setPoint twice");
    }

    public PathWrapper setRouteWeight(double d) {
        this.routeWeight = d;
        return this;
    }

    public PathWrapper setTime(long l) {
        this.time = l;
        return this;
    }

    public void setWaypoints(PointList pointList) {
        if (this.waypointList == PointList.EMPTY) {
            this.waypointList = pointList;
            return;
        }
        throw new IllegalStateException("Cannot call setWaypoints twice");
    }

    public String toString() {
        CharSequence charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("nodes:");
        ((StringBuilder)charSequence).append(this.pointList.getSize());
        ((StringBuilder)charSequence).append("; ");
        ((StringBuilder)charSequence).append(this.pointList.toString());
        CharSequence charSequence2 = ((StringBuilder)charSequence).toString();
        InstructionList instructionList = this.instructions;
        charSequence = charSequence2;
        if (instructionList != null) {
            charSequence = charSequence2;
            if (!instructionList.isEmpty()) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append((String)charSequence2);
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append(this.instructions.toString());
                charSequence = ((StringBuilder)charSequence).toString();
            }
        }
        charSequence2 = charSequence;
        if (this.hasErrors()) {
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append((String)charSequence);
            ((StringBuilder)charSequence2).append(", ");
            ((StringBuilder)charSequence2).append(this.errors.toString());
            charSequence2 = ((StringBuilder)charSequence2).toString();
        }
        return charSequence2;
    }
}

