/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.graphhopper.util.InstructionList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.Date;
import java.util.List;

public class Trip {

    public static abstract class Leg {
        public final String departureLocation;
        public final double distance;
        public final Geometry geometry;
        public final String type;

        public Leg(String string2, String string3, Geometry geometry, double d) {
            this.type = string2;
            this.departureLocation = string3;
            this.geometry = geometry;
            this.distance = d;
        }

        public abstract Date getArrivalTime();

        public abstract Date getDepartureTime();

        public double getDistance() {
            return this.distance;
        }
    }

    public static class PtLeg
    extends Leg {
        public final String feed_id;
        public final boolean isInSameVehicleAsPrevious;
        public final String route_id;
        public final List<Stop> stops;
        public final long travelTime;
        public final String trip_headsign;
        public final String trip_id;

        public PtLeg(String string2, boolean bl, String string3, String string4, String string5, List<Stop> list, double d, long l, Geometry geometry) {
            super("pt", list.get((int)0).stop_name, geometry, d);
            this.feed_id = string2;
            this.isInSameVehicleAsPrevious = bl;
            this.trip_id = string3;
            this.route_id = string4;
            this.trip_headsign = string5;
            this.travelTime = l;
            this.stops = list;
        }

        @Override
        public Date getArrivalTime() {
            List<Stop> list = this.stops;
            return list.get((int)(list.size() - 1)).arrivalTime;
        }

        @Override
        public Date getDepartureTime() {
            return this.stops.get((int)0).departureTime;
        }
    }

    public static class Stop {
        public final boolean arrivalCancelled;
        public final Date arrivalTime;
        public final boolean departureCancelled;
        public final Date departureTime;
        public final Point geometry;
        public final Date plannedArrivalTime;
        public final Date plannedDepartureTime;
        public final Date predictedArrivalTime;
        public final Date predictedDepartureTime;
        public final String stop_id;
        public final String stop_name;

        public Stop(String string2, String string3, Point point, Date date, Date date2, Date date3, boolean bl, Date date4, Date date5, Date date6, boolean bl2) {
            this.stop_id = string2;
            this.stop_name = string3;
            this.geometry = point;
            this.arrivalTime = date;
            this.plannedArrivalTime = date2;
            this.predictedArrivalTime = date3;
            this.arrivalCancelled = bl;
            this.departureTime = date4;
            this.plannedDepartureTime = date5;
            this.predictedDepartureTime = date6;
            this.departureCancelled = bl2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Stop{stop_id='");
            stringBuilder.append(this.stop_id);
            stringBuilder.append('\'');
            stringBuilder.append(", arrivalTime=");
            stringBuilder.append(this.arrivalTime);
            stringBuilder.append(", departureTime=");
            stringBuilder.append(this.departureTime);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    public static class WalkLeg
    extends Leg {
        private final Date arrivalTime;
        private final Date departureTime;
        public final InstructionList instructions;

        public WalkLeg(String string2, Date date, Geometry geometry, double d, InstructionList instructionList, Date date2) {
            super("walk", string2, geometry, d);
            this.instructions = instructionList;
            this.departureTime = date;
            this.arrivalTime = date2;
        }

        @Override
        public Date getArrivalTime() {
            return this.arrivalTime;
        }

        @Override
        public Date getDepartureTime() {
            return this.departureTime;
        }
    }
}

