/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.coll;

import com.graphhopper.geohash.SpatialKeyAlgo;
import com.graphhopper.storage.VLongStorage;
import com.graphhopper.util.shapes.GHPoint;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class CompressedArray {
    private SpatialKeyAlgo algo;
    private int approxBytesPerEntry;
    private int compressionLevel = 5;
    private int currentEntry = 0;
    private VLongStorage currentWriter;
    private int entriesPerSegment;
    private List<byte[]> segments;

    public CompressedArray() {
        this(100, 200, 4);
    }

    public CompressedArray(int n, int n2, int n3) {
        if (n2 >= 1) {
            this.entriesPerSegment = n2;
            this.approxBytesPerEntry = n3;
            this.segments = new ArrayList<byte[]>(n);
            this.algo = new SpatialKeyAlgo(63);
            return;
        }
        throw new IllegalArgumentException("at least one entry should be per segment");
    }

    public static byte[] compress(byte[] byArray, int n, int n2, int n3) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        Deflater deflater = new Deflater();
        try {
            deflater.setLevel(n3);
            deflater.setInput(byArray, n, n2);
            deflater.finish();
            byArray = new byte[1024];
            while (!deflater.finished()) {
                byteArrayOutputStream.write(byArray, 0, deflater.deflate(byArray));
            }
            return byteArrayOutputStream.toByteArray();
        }
        finally {
            deflater.end();
        }
    }

    public static byte[] decompress(byte[] byArray) throws DataFormatException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        Inflater inflater = new Inflater();
        try {
            inflater.setInput(byArray);
            byArray = new byte[1024];
            while (!inflater.finished()) {
                byteArrayOutputStream.write(byArray, 0, inflater.inflate(byArray));
            }
            return byteArrayOutputStream.toByteArray();
        }
        finally {
            inflater.end();
        }
    }

    public float calcMemInMB() {
        long l = 0L;
        for (int i = 0; i < this.segments.size(); ++i) {
            l += (long)this.segments.get(i).length;
        }
        return (float)((long)(this.segments.size() * 4) + l) / 1048576.0f;
    }

    public void flush() {
        Object object = this.currentWriter;
        if (object == null) {
            return;
        }
        try {
            ((VLongStorage)object).trimToSize();
            object = this.currentWriter.getBytes();
            this.segments.add(CompressedArray.compress((byte[])object, 0, ((Object)object).length, this.compressionLevel));
            this.currentWriter = null;
            this.currentEntry = 0;
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public GHPoint get(long l) {
        long l2;
        Object object;
        int n;
        int n2;
        int n3;
        block7: {
            n3 = this.entriesPerSegment;
            n2 = (int)(l / (long)n3);
            n = (int)(l % (long)n3);
            if (n2 < this.segments.size()) break block7;
            return null;
        }
        try {
            byte[] byArray = this.segments.get(n2);
            object = new VLongStorage(CompressedArray.decompress(byArray));
            l2 = ((VLongStorage)object).getLength();
            n3 = 0;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            object = new StringBuilder();
            ((StringBuilder)object).append("index ");
            ((StringBuilder)object).append(l);
            ((StringBuilder)object).append("=> segNo:");
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append(", entry=");
            ((StringBuilder)object).append(n);
            ((StringBuilder)object).append(", segments:");
            ((StringBuilder)object).append(this.segments.size());
            throw new RuntimeException(((StringBuilder)object).toString(), arrayIndexOutOfBoundsException);
        }
        while (true) {
            block8: {
                if (((VLongStorage)object).getPosition() >= l2) break;
                long l3 = ((VLongStorage)object).readVLong();
                if (n3 != n) break block8;
                object = new GHPoint();
                this.algo.decode(l3, (GHPoint)object);
                return object;
            }
            ++n3;
        }
        return null;
    }

    public CompressedArray setCompressionLevel(int n) {
        this.compressionLevel = n;
        return this;
    }

    public void write(double d, double d2) {
        try {
            int n;
            Object object;
            if (this.currentWriter == null) {
                this.currentWriter = object = new VLongStorage(this.entriesPerSegment * this.approxBytesPerEntry);
            }
            object = this.algo;
            GHPoint gHPoint = new GHPoint(d, d2);
            long l = ((SpatialKeyAlgo)object).encode(gHPoint);
            this.currentWriter.writeVLong(l);
            this.currentEntry = n = this.currentEntry + 1;
            if (n >= this.entriesPerSegment) {
                this.flush();
            }
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

