/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.coll;

import com.graphhopper.util.BitUtil;
import java.util.Comparator;
import java.util.TreeMap;

public class GHTreeMapComposed {
    private static final Integer NOT_EMPTY = -3;
    private final BitUtil bitUtil = BitUtil.BIG;
    private final TreeMap<Long, Integer> map = new TreeMap(new Comparator<Long>(){

        @Override
        public int compare(Long l, Long l2) {
            int n;
            if (l.equals(l2)) {
                return 0;
            }
            int n2 = GHTreeMapComposed.this.bitUtil.getIntHigh(l);
            if (n2 == (n = GHTreeMapComposed.this.bitUtil.getIntHigh(l2))) {
                n2 = GHTreeMapComposed.this.bitUtil.getIntLow(l);
                if (n2 == (n = GHTreeMapComposed.this.bitUtil.getIntLow(l2))) {
                    return 0;
                }
                n = n2 < n ? -1 : 1;
                return n;
            }
            return Float.compare(Float.intBitsToFloat(n2), Float.intBitsToFloat(n));
        }
    });

    public void clear() {
        this.map.clear();
    }

    public int getSize() {
        return this.map.size();
    }

    public void insert(int n, float f) {
        long l = this.bitUtil.toLong(Float.floatToRawIntBits(f), n);
        this.map.put(l, NOT_EMPTY);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int peekKey() {
        long l = this.map.firstEntry().getKey();
        return this.bitUtil.getIntLow(l);
    }

    public float peekValue() {
        long l = this.map.firstEntry().getKey();
        return Float.intBitsToFloat(this.bitUtil.getIntHigh(l));
    }

    public int pollKey() {
        if (!this.map.isEmpty()) {
            long l = this.map.pollFirstEntry().getKey();
            return this.bitUtil.getIntLow(l);
        }
        throw new IllegalStateException("Cannot poll collection is empty!");
    }

    void remove(int n, float f) {
        long l = this.bitUtil.toLong(Float.floatToRawIntBits(f), n);
        if (this.map.remove(l) != null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("cannot remove key ");
        stringBuilder.append(n);
        stringBuilder.append(" with value ");
        stringBuilder.append(f);
        stringBuilder.append(" - did you insert this key with this value before ?");
        throw new IllegalStateException(stringBuilder.toString());
    }

    public String toString() {
        return this.map.toString();
    }

    public void update(int n, float f, float f2) {
        this.remove(n, f);
        this.insert(n, f2);
    }
}

