/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.coll;

import com.graphhopper.coll.LongIntMap;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.util.BitUtil;

public class OSMIDMap
implements LongIntMap {
    private static final BitUtil bitUtil = BitUtil.LITTLE;
    private final Directory dir;
    private final DataAccess keys;
    private long lastKey = Long.MIN_VALUE;
    private final int noEntryValue;
    private long size;
    private final DataAccess values;

    public OSMIDMap(Directory directory) {
        this(directory, -1);
    }

    public OSMIDMap(Directory object, int n) {
        DataAccess dataAccess;
        this.dir = object;
        this.noEntryValue = n;
        this.keys = dataAccess = object.find("osmid_map_keys");
        dataAccess.create(2000L);
        this.values = object = object.find("osmid_map_values");
        object.create(1000L);
    }

    static long binarySearch(DataAccess dataAccess, long l, long l2, long l3) {
        long l4 = l + l2;
        l2 = l - 1L;
        byte[] byArray = new byte[8];
        l = l4;
        while (l - l2 > 1L) {
            long l5 = l + l2 >>> 1;
            dataAccess.getBytes(l5 << 3, byArray, 8);
            if (bitUtil.toLong(byArray) < l3) {
                l2 = l5;
                continue;
            }
            l = l5;
        }
        if (l == l4) {
            return l4;
        }
        dataAccess.getBytes(l << 3, byArray, 8);
        if (bitUtil.toLong(byArray) == l3) {
            return l;
        }
        return l;
    }

    @Override
    public int get(long l) {
        l = OSMIDMap.binarySearch(this.keys, 0L, this.getSize(), l);
        if (l < 0L) {
            return this.noEntryValue;
        }
        return this.values.getInt(l * 4L);
    }

    public long getCapacity() {
        return this.keys.getCapacity();
    }

    @Override
    public int getMemoryUsage() {
        return Math.round(this.getCapacity() / 0x100000L);
    }

    @Override
    public long getSize() {
        return this.size / 4L;
    }

    @Override
    public void optimize() {
    }

    @Override
    public int put(long l, int n) {
        if (l <= this.lastKey) {
            long l2 = OSMIDMap.binarySearch(this.keys, 0L, this.getSize(), l);
            if (l2 >= 0L) {
                l = l2 * 4L;
                int n2 = this.values.getInt(l);
                this.values.setInt(l, n);
                return n2;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot insert keys lower than the last key ");
            stringBuilder.append(l);
            stringBuilder.append(" < ");
            stringBuilder.append(this.lastKey);
            stringBuilder.append(". Only updating supported");
            throw new IllegalStateException(stringBuilder.toString());
        }
        this.values.ensureCapacity(this.size + 4L);
        this.values.setInt(this.size, n);
        long l3 = this.size * 2L;
        this.keys.ensureCapacity(8L + l3);
        byte[] byArray = bitUtil.fromLong(l);
        this.keys.setBytes(l3, byArray, 8);
        this.lastKey = l;
        this.size += 4L;
        return -1;
    }

    public void remove() {
        this.dir.remove(this.keys);
    }
}

