/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ReaderElement {
    public static final int FILEHEADER = 3;
    public static final int NODE = 0;
    public static final int RELATION = 2;
    public static final int WAY = 1;
    private final long id;
    private final Map<String, Object> properties;
    private final int type;

    protected ReaderElement(long l, int n) {
        this(l, n, 4);
    }

    protected ReaderElement(long l, int n, int n2) {
        this.id = l;
        this.type = n;
        this.properties = new HashMap<String, Object>(n2);
    }

    public void clearTags() {
        this.properties.clear();
    }

    public String getFirstPriorityTag(List<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            if (!this.hasTag(string2, new String[0])) continue;
            return this.getTag(string2);
        }
        return "";
    }

    public long getId() {
        return this.id;
    }

    public <T> T getTag(String object, T t) {
        if ((object = this.properties.get(object)) == null) {
            return t;
        }
        return (T)object;
    }

    public String getTag(String string2) {
        return (String)this.properties.get(string2);
    }

    protected Map<String, Object> getTags() {
        return this.properties;
    }

    public int getType() {
        return this.type;
    }

    public boolean hasTag(String string2, Object object) {
        return object.equals(this.getTag(string2, ""));
    }

    public final boolean hasTag(String string2, Set<String> set) {
        return set.contains(this.getTag(string2, ""));
    }

    public boolean hasTag(String object, String ... stringArray) {
        if ((object = this.properties.get(object)) == null) {
            return false;
        }
        if (stringArray.length == 0) {
            return true;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTag(List<String> object, Set<String> set) {
        object = object.iterator();
        while (object.hasNext()) {
            if (!set.contains(this.getTag((String)object.next(), ""))) continue;
            return true;
        }
        return false;
    }

    public boolean hasTags() {
        return this.properties.isEmpty() ^ true;
    }

    public boolean isType(int n) {
        boolean bl = this.type == n;
        return bl;
    }

    public void removeTag(String string2) {
        this.properties.remove(string2);
    }

    public void setTag(String string2, Object object) {
        this.properties.put(string2, object);
    }

    public void setTags(Map<String, String> object2) {
        this.properties.clear();
        if (object2 != null) {
            for (Map.Entry entry : object2.entrySet()) {
                this.setTag((String)entry.getKey(), entry.getValue());
            }
        }
    }

    protected String tagsToString() {
        if (this.properties.isEmpty()) {
            return "<empty>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.properties.toString();
    }
}

