/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader;

import com.graphhopper.reader.ReaderElement;
import com.graphhopper.util.PointAccess;

public class ReaderNode
extends ReaderElement {
    private final double lat;
    private final double lon;

    public ReaderNode(long l, double d, double d2) {
        super(l, 0);
        this.lat = d;
        this.lon = d2;
    }

    public ReaderNode(long l, PointAccess pointAccess, int n) {
        super(l, 0);
        this.lat = pointAccess.getLatitude(n);
        this.lon = pointAccess.getLongitude(n);
        if (pointAccess.is3D()) {
            this.setTag("ele", pointAccess.getElevation(n));
        }
    }

    public double getEle() {
        Object object = this.getTags().get("ele");
        if (object == null) {
            return Double.NaN;
        }
        return (Double)object;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setTag(String var1_1, Object var2_3) {
        var3_4 = var2_3;
        if ("ele".equals(var1_1)) {
            if (var2_3 == null) {
                while (true) {
                    var3_4 = null;
                    break;
                }
            } else if (var2_3 instanceof String) {
                if ((var2_3 = ((String)var2_3).trim().replaceAll("\\,", ".")).isEmpty()) ** continue;
                try {
                    var3_4 = Double.parseDouble((String)var2_3);
                }
                catch (NumberFormatException var1_2) {
                    return;
                }
            } else {
                var3_4 = ((Number)var2_3).doubleValue();
            }
        }
        super.setTag(var1_1, var3_4);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Node: ");
        stringBuilder.append(this.getId());
        stringBuilder.append(" lat=");
        stringBuilder.append(this.getLat());
        stringBuilder.append(" lon=");
        stringBuilder.append(this.getLon());
        if (!this.getTags().isEmpty()) {
            stringBuilder.append("\n");
            stringBuilder.append(this.tagsToString());
        }
        return stringBuilder.toString();
    }
}

