/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader;

import com.graphhopper.reader.ReaderElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReaderRelation
extends ReaderElement {
    protected List<Member> members;

    public ReaderRelation(long l) {
        super(l, 2, 2);
    }

    public void add(Member member) {
        if (this.members == null) {
            this.members = new ArrayList<Member>(3);
        }
        this.members.add(member);
    }

    public List<Member> getMembers() {
        List<Member> list;
        List<Member> list2 = list = this.members;
        if (list == null) {
            list2 = Collections.emptyList();
        }
        return list2;
    }

    public boolean isMetaRelation() {
        List<Member> list = this.members;
        if (list != null) {
            list = list.iterator();
            while (list.hasNext()) {
                if (((Member)list.next()).getType() != 2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Relation (");
        stringBuilder.append(this.getId());
        stringBuilder.append(", ");
        List<Member> list = this.members;
        int n = list == null ? 0 : list.size();
        stringBuilder.append(n);
        stringBuilder.append(" members)");
        return stringBuilder.toString();
    }

    public static class Member {
        public static final int NODE = 0;
        public static final int RELATION = 2;
        public static final int WAY = 1;
        private final long ref;
        private final String role;
        private final int type;

        public Member(int n, long l, String string2) {
            this.type = n;
            this.ref = l;
            this.role = string2;
        }

        public long getRef() {
            return this.ref;
        }

        public String getRole() {
            return this.role;
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Member ");
            stringBuilder.append(this.type);
            stringBuilder.append(":");
            stringBuilder.append(this.ref);
            return stringBuilder.toString();
        }
    }
}

