/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.carrotsearch.hppc.IntSet;
import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHBitSetImpl;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.reader.dem.ElevationInterpolator;
import com.graphhopper.reader.dem.NodeElevationInterpolator;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.DataFlagEncoder;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.BreadthFirstSearch;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PointList;

public abstract class AbstractEdgeElevationInterpolator {
    protected final DataFlagEncoder dataFlagEncoder;
    private final ElevationInterpolator elevationInterpolator = new ElevationInterpolator();
    private final NodeElevationInterpolator nodeElevationInterpolator;
    private final GraphHopperStorage storage;

    public AbstractEdgeElevationInterpolator(GraphHopperStorage graphHopperStorage, DataFlagEncoder dataFlagEncoder) {
        this.storage = graphHopperStorage;
        this.dataFlagEncoder = dataFlagEncoder;
        this.nodeElevationInterpolator = new NodeElevationInterpolator(graphHopperStorage);
    }

    private void interpolateEdge(EdgeIteratorState edgeIteratorState, GHBitSet gHBitSet, EdgeExplorer edgeExplorer) {
        GHIntHashSet gHIntHashSet = new GHIntHashSet();
        GHIntHashSet gHIntHashSet2 = new GHIntHashSet();
        this.gatherOuterAndInnerNodeIds(edgeExplorer, edgeIteratorState, gHBitSet, (IntSet)gHIntHashSet, gHIntHashSet2);
        this.nodeElevationInterpolator.interpolateElevationsOfInnerNodes(gHIntHashSet.toArray(), gHIntHashSet2.toArray());
    }

    private void interpolateElevationsOfPillarNodes() {
        AllEdgesIterator allEdgesIterator = this.storage.getAllEdges();
        NodeAccess nodeAccess = this.storage.getNodeAccess();
        while (allEdgesIterator.next()) {
            if (!this.isInterpolatableEdge(allEdgesIterator)) continue;
            int n = allEdgesIterator.getBaseNode();
            int n2 = allEdgesIterator.getAdjNode();
            double d = nodeAccess.getLat(n);
            double d2 = nodeAccess.getLon(n);
            double d3 = nodeAccess.getEle(n);
            double d4 = nodeAccess.getLat(n2);
            double d5 = nodeAccess.getLon(n2);
            double d6 = nodeAccess.getEle(n2);
            PointList pointList = allEdgesIterator.fetchWayGeometry(0);
            n = pointList.size();
            for (n2 = 0; n2 < n; ++n2) {
                double d7 = pointList.getLat(n2);
                double d8 = pointList.getLon(n2);
                pointList.set(n2, d7, d8, this.elevationInterpolator.calculateElevationBasedOnTwoPoints(d7, d8, d, d2, d3, d4, d5, d6));
            }
            allEdgesIterator.setWayGeometry(pointList);
        }
    }

    private void interpolateElevationsOfTowerNodes() {
        AllEdgesIterator allEdgesIterator = this.storage.getAllEdges();
        GHBitSetImpl gHBitSetImpl = new GHBitSetImpl(allEdgesIterator.length());
        EdgeExplorer edgeExplorer = this.storage.createEdgeExplorer();
        while (allEdgesIterator.next()) {
            int n = allEdgesIterator.getEdge();
            if (this.isInterpolatableEdge(allEdgesIterator) && !gHBitSetImpl.contains(n)) {
                this.interpolateEdge(allEdgesIterator, gHBitSetImpl, edgeExplorer);
            }
            gHBitSetImpl.add(n);
        }
    }

    public void execute() {
        this.interpolateElevationsOfTowerNodes();
        this.interpolateElevationsOfPillarNodes();
    }

    public void gatherOuterAndInnerNodeIds(EdgeExplorer edgeExplorer, EdgeIteratorState edgeIteratorState, final GHBitSet gHBitSet, final IntSet intSet, final GHIntHashSet gHIntHashSet) {
        new BreadthFirstSearch(){

            @Override
            protected boolean checkAdjacent(EdgeIteratorState edgeIteratorState) {
                gHBitSet.add(edgeIteratorState.getEdge());
                int n = edgeIteratorState.getBaseNode();
                boolean bl = AbstractEdgeElevationInterpolator.this.isInterpolatableEdge(edgeIteratorState);
                if (!bl) {
                    gHIntHashSet.remove(n);
                    intSet.add(n);
                } else if (!intSet.contains(n)) {
                    gHIntHashSet.add(n);
                }
                return bl;
            }
        }.start(edgeExplorer, edgeIteratorState.getBaseNode());
    }

    public GraphHopperStorage getStorage() {
        return this.storage;
    }

    protected abstract boolean isInterpolatableEdge(EdgeIteratorState var1);
}

