/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.AbstractElevationProvider;
import com.graphhopper.reader.dem.HeightTile;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.util.Downloader;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTiffElevationProvider
extends AbstractElevationProvider {
    private final int HEIGHT;
    final int LAT_DEGREE;
    final int LON_DEGREE;
    private final int WIDTH;
    private final Map<String, HeightTile> cacheData = new HashMap<String, HeightTile>();
    final double precision;

    public AbstractTiffElevationProvider(String string2, String string3, String string4, int n, int n2, int n3, int n4) {
        super(string3);
        this.precision = 1.0E7;
        this.baseUrl = string2;
        this.downloader = new Downloader(string4).setTimeout(10000);
        this.WIDTH = n;
        this.HEIGHT = n2;
        this.LAT_DEGREE = n3;
        this.LON_DEGREE = n4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void downloadFile(File file, String string2) throws IOException {
        if (!file.exists()) {
            for (int i = 0; i < 3; ++i) {
                try {
                    this.downloader.downloadFile(string2, file.getAbsolutePath());
                    return;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (i >= 2) {
                        throw new RuntimeException(socketTimeoutException);
                    }
                    try {
                        Thread.sleep(this.sleep);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
            }
        }
    }

    private void fillDataAccessWithElevationData(Raster raster, DataAccess object, int n) {
        int n2;
        int n3;
        int n4 = raster.getHeight();
        int n5 = raster.getWidth();
        int n6 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            for (n6 = 0; n6 < n5; ++n6) {
                int n7;
                block10: {
                    block9: {
                        n2 = n6;
                        int[] nArray = null;
                        n2 = n6;
                        int n8 = raster.getPixel(n6, n3, (int[])null)[0];
                        if (n8 < -1000) break block9;
                        n7 = n8;
                        if (n8 <= 12000) break block10;
                    }
                    n7 = n2 = Short.MIN_VALUE;
                }
                n2 = n6;
                object.setShort((n3 * n + n6) * 2, (short)n7);
                continue;
            }
        }
        n2 = n6;
        try {
            object.flush();
            return;
        }
        catch (Exception exception) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Problem at x:");
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append(", y:");
            ((StringBuilder)object).append(n3);
            throw new RuntimeException(((StringBuilder)object).toString(), exception);
        }
    }

    abstract Raster generateRasterFromFile(File var1, String var2);

    @Override
    public double getEle(double d, double d2) {
        if (this.isOutsideSupportedArea(d, d2)) {
            return 0.0;
        }
        d = (double)((int)(d * 1.0E7)) / 1.0E7;
        d2 = (double)((int)(d2 * 1.0E7)) / 1.0E7;
        String string2 = this.getFileName(d, d2);
        Object object = this.cacheData.get(string2);
        HeightTile heightTile = object;
        if (object == null) {
            Object object2;
            boolean bl;
            if (!this.cacheDir.exists()) {
                this.cacheDir.mkdirs();
            }
            int n = this.getMinLatForTile(d);
            int n2 = this.getMinLonForTile(d2);
            int n3 = this.WIDTH;
            int n4 = this.HEIGHT;
            int n5 = this.LON_DEGREE;
            heightTile = new HeightTile(n, n2, n3, n4, (double)n5 * 1.0E7, n5, this.LAT_DEGREE);
            heightTile.setCalcMean(this.calcMean);
            this.cacheData.put(string2, heightTile);
            object = this.getDirectory();
            Comparable<StringBuilder> comparable = new StringBuilder();
            comparable.append(string2);
            comparable.append(".gh");
            object = object.find(comparable.toString());
            heightTile.setHeights((DataAccess)object);
            boolean bl2 = false;
            try {
                bl = object.loadExisting();
            }
            catch (Exception exception) {
                object2 = this.logger;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("cannot load ");
                stringBuilder.append(string2);
                stringBuilder.append(", error: ");
                stringBuilder.append(exception.getMessage());
                object2.warn(stringBuilder.toString());
                bl = bl2;
            }
            if (!bl) {
                object2 = this.getDownloadURL(d, d2);
                comparable = new File(this.cacheDir, new File(this.getFileNameOfLocalFile(d, d2)).getName());
                try {
                    this.downloadFile((File)comparable, (String)object2);
                    object.create(this.WIDTH * 2 * this.HEIGHT);
                }
                catch (IOException iOException) {
                    heightTile.setSeaLevel(true);
                    object.setSegmentSize(100).create(10L).flush();
                    return 0.0;
                }
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(string2);
                ((StringBuilder)object2).append(".tif");
                this.fillDataAccessWithElevationData(this.generateRasterFromFile((File)comparable, ((StringBuilder)object2).toString()), (DataAccess)object, this.WIDTH);
            }
        }
        if (heightTile.isSeaLevel()) {
            return 0.0;
        }
        return heightTile.getHeight(d, d2);
    }

    abstract String getFileNameOfLocalFile(double var1, double var3);

    abstract int getMinLatForTile(double var1);

    abstract int getMinLonForTile(double var1);

    abstract boolean isOutsideSupportedArea(double var1, double var3);

    @Override
    public void release() {
        this.cacheData.clear();
        if (this.autoRemoveTemporary && this.dir != null) {
            this.dir.clear();
        }
    }

    @Override
    public void setAutoRemoveTemporaryFiles(boolean bl) {
        this.autoRemoveTemporary = bl;
    }
}

