/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;

public class ElevationInterpolator {
    public static final double EPSILON = 1.0E-5;
    public static final double EPSILON2 = 1.0000000000000002E-10;

    public double calculateElevationBasedOnPointList(double d, double d2, PointList pointList) {
        int n = pointList.size();
        if (n != 0) {
            double d3;
            int n2 = 0;
            if (n == 1) {
                return pointList.getEle(0);
            }
            if (n == 2) {
                return this.calculateElevationBasedOnTwoPoints(d, d2, pointList.getLat(0), pointList.getLon(0), pointList.getEle(0), pointList.getLat(1), pointList.getLon(1), pointList.getEle(1));
            }
            if (n == 3) {
                return this.calculateElevationBasedOnThreePoints(d, d2, pointList.getLat(0), pointList.getLon(0), pointList.getEle(0), pointList.getLat(1), pointList.getLon(1), pointList.getEle(1), pointList.getLat(2), pointList.getLon(2), pointList.getEle(2));
            }
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            double d4 = 0.0;
            double d5 = 0.0;
            int n3 = 0;
            while (true) {
                d3 = d4;
                if (n3 >= n) break;
                double d6 = pointList.getLat(n3);
                d3 = pointList.getLon(n3);
                d3 -= d2;
                d3 = (d6 -= d) * d6 + d3 * d3;
                dArray2[n3] = pointList.getEle(n3);
                if (d3 < 1.0000000000000002E-10) {
                    return dArray2[n3];
                }
                dArray[n3] = 1.0 / d3;
                d5 += dArray[n3];
                ++n3;
            }
            for (int i = n2; i < n; ++i) {
                d3 += dArray2[i] * dArray[i] / d5;
            }
            return Helper.round2(d3);
        }
        throw new IllegalArgumentException("At least one point is required in the pointList.");
    }

    public double calculateElevationBasedOnThreePoints(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11) {
        double d12 = d6 - d3;
        double d13 = d7 - d4;
        double d14 = d8 - d5;
        double d15 = d9 - d3;
        double d16 = d10 - d4;
        double d17 = d11 - d5;
        double d18 = d13 * d17 - d14 * d16;
        double d19 = d14 * d15 - d12 * d17;
        double d20 = d12 * d16 - d13 * d15;
        if (Math.abs(d20) < 1.0E-5) {
            d20 = d9 - d6;
            d19 = d10 - d7;
            d18 = d11 - d8;
            d14 = d12 * d12 + d13 * d13 + d14 * d14;
            d17 = d15 * d15 + d16 * d16 + d17 * d17;
            d16 = d20 * d20 + d19 * d19 + d18 * d18;
            if (d16 > d14 && d16 > d17) {
                return this.calculateElevationBasedOnTwoPoints(d, d2, d6, d7, d8, d9, d10, d11);
            }
            if (d17 > d14 && d17 > d16) {
                return this.calculateElevationBasedOnTwoPoints(d, d2, d3, d4, d5, d9, d10, d11);
            }
            return this.calculateElevationBasedOnTwoPoints(d, d2, d3, d4, d5, d6, d7, d8);
        }
        return Helper.round2((d18 * d3 + d19 * d4 + d20 * d5 - d18 * d - d19 * d2) / d20);
    }

    public double calculateElevationBasedOnTwoPoints(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        d3 -= d;
        d4 -= d2;
        d = d6 - d;
        d6 = d7 - d2;
        d2 = Math.sqrt(d4 * d4 + d3 * d3);
        d = d2 + (d3 = Math.sqrt(d6 * d6 + d * d));
        if (d < 1.0E-5) {
            d = d2 <= d3 ? d5 : d8;
            return d;
        }
        return Helper.round2(d5 + (d8 - d5) * d2 / d);
    }
}

