/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.AbstractElevationProvider;
import com.graphhopper.reader.dem.AbstractTiffElevationProvider;
import com.graphhopper.util.Helper;
import java.awt.image.Raster;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.xmlgraphics.image.codec.tiff.TIFFDecodeParam;
import org.apache.xmlgraphics.image.codec.tiff.TIFFImageDecoder;
import org.apache.xmlgraphics.image.codec.util.SeekableStream;

public class GMTEDProvider
extends AbstractTiffElevationProvider {
    private final String FILE_NAME_END;

    public GMTEDProvider() {
        this("");
    }

    public GMTEDProvider(String string2) {
        String string3 = string2;
        if (string2.isEmpty()) {
            string3 = "/tmp/gmted";
        }
        super("https://edcintl.cr.usgs.gov/downloads/sciweb1/shared/topo/downloads/GMTED/Global_tiles_GMTED/075darcsec/mea/", string3, "GraphHopper GMTEDReader", 14400, 9600, 20, 30);
        this.FILE_NAME_END = "_20101117_gmted_mea075";
    }

    private String getEastString(int n) {
        if (n < 0) {
            return "W";
        }
        return "E";
    }

    private String getLatString(int n) {
        String string2 = (n = Math.abs(n)) < 10 ? "0" : "";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    private String getLonString(int n) {
        CharSequence charSequence = (n = Math.abs(n)) < 100 ? "0" : "";
        CharSequence charSequence2 = charSequence;
        if (n < 10) {
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append((String)charSequence);
            ((StringBuilder)charSequence2).append("0");
            charSequence2 = ((StringBuilder)charSequence2).toString();
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append((String)charSequence2);
        ((StringBuilder)charSequence).append(n);
        return ((StringBuilder)charSequence).toString();
    }

    private String getNorthString(int n) {
        if (n < 0) {
            return "S";
        }
        return "N";
    }

    public static void main(String[] object) {
        object = new GMTEDProvider();
        System.out.println(((AbstractTiffElevationProvider)object).getEle(46.0, -20.0));
        System.out.println(((AbstractTiffElevationProvider)object).getEle(49.949784, 11.57517));
        System.out.println(((AbstractTiffElevationProvider)object).getEle(49.968668, 11.575127));
        System.out.println(((AbstractTiffElevationProvider)object).getEle(49.968682, 11.574842));
        System.out.println(((AbstractTiffElevationProvider)object).getEle(-22.532854, -65.110474));
        System.out.println(((AbstractTiffElevationProvider)object).getEle(38.065392, -87.099609));
        System.out.println(((AbstractTiffElevationProvider)object).getEle(40.0, -105.2277023));
        System.out.println(((AbstractTiffElevationProvider)object).getEle(39.99999999, -105.2277023));
        System.out.println(((AbstractTiffElevationProvider)object).getEle(39.9999999, -105.2277023));
        System.out.println(((AbstractTiffElevationProvider)object).getEle(39.999999, -105.2277023));
        System.out.println(((AbstractTiffElevationProvider)object).getEle(47.468668, 14.575127));
        System.out.println(((AbstractTiffElevationProvider)object).getEle(47.467753, 14.573911));
        System.out.println(((AbstractTiffElevationProvider)object).getEle(46.468835, 12.578777));
        System.out.println(((AbstractTiffElevationProvider)object).getEle(48.469123, 9.576393));
        ((AbstractElevationProvider)object).setCalcMean(true);
        System.out.println(((AbstractTiffElevationProvider)object).getEle(47.467753, 14.573911));
        System.out.println(((AbstractTiffElevationProvider)object).getEle(29.840644, -42.890625));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    Raster generateRasterFromFile(File file, String charSequence) {
        Throwable throwable2222222;
        block6: {
            Object object;
            block5: {
                object = null;
                StringBuilder stringBuilder = null;
                charSequence = stringBuilder;
                StringBuilder stringBuilder2 = object;
                charSequence = stringBuilder;
                stringBuilder2 = object;
                FileInputStream fileInputStream = new FileInputStream(file);
                charSequence = stringBuilder;
                stringBuilder2 = object;
                stringBuilder = SeekableStream.wrapInputStream((InputStream)fileInputStream, (boolean)true);
                charSequence = stringBuilder;
                stringBuilder2 = stringBuilder;
                charSequence = stringBuilder;
                stringBuilder2 = stringBuilder;
                charSequence = stringBuilder;
                stringBuilder2 = stringBuilder;
                fileInputStream = new TIFFDecodeParam();
                charSequence = stringBuilder;
                stringBuilder2 = stringBuilder;
                object = new TIFFImageDecoder((SeekableStream)stringBuilder, (TIFFDecodeParam)fileInputStream);
                charSequence = stringBuilder;
                stringBuilder2 = stringBuilder;
                object = object.decodeAsRaster();
                if (stringBuilder == null) break block5;
                {
                    catch (Throwable throwable2222222) {
                        break block6;
                    }
                    catch (Exception exception) {}
                    charSequence = stringBuilder2;
                    {
                        charSequence = stringBuilder2;
                        charSequence = stringBuilder2;
                        stringBuilder = new StringBuilder();
                        charSequence = stringBuilder2;
                        stringBuilder.append("Can't decode ");
                        charSequence = stringBuilder2;
                        stringBuilder.append(file.getName());
                        charSequence = stringBuilder2;
                        RuntimeException runtimeException = new RuntimeException(stringBuilder.toString(), exception);
                        charSequence = stringBuilder2;
                        throw runtimeException;
                    }
                }
                Helper.close((Closeable)((Object)stringBuilder));
            }
            return object;
        }
        if (charSequence != null) {
            Helper.close((Closeable)((Object)charSequence));
        }
        throw throwable2222222;
    }

    @Override
    String getDownloadURL(double d, double d2) {
        int n = this.getMinLonForTile(d2);
        int n2 = this.getMinLatForTile(d);
        String string2 = this.getEastString(n);
        String string3 = this.getLonString(n);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.baseUrl);
        stringBuilder.append("/");
        stringBuilder.append(string2);
        stringBuilder.append(string3);
        stringBuilder.append("/");
        stringBuilder.append(this.getLatString(n2));
        stringBuilder.append(this.getNorthString(n2));
        stringBuilder.append(string3);
        stringBuilder.append(string2);
        stringBuilder.append("_20101117_gmted_mea075");
        stringBuilder.append(".tif");
        return stringBuilder.toString();
    }

    @Override
    String getFileName(double d, double d2) {
        int n = this.getMinLonForTile(d2);
        int n2 = this.getMinLatForTile(d);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getLatString(n2));
        stringBuilder.append(this.getNorthString(n2));
        stringBuilder.append(this.getLonString(n));
        stringBuilder.append(this.getEastString(n));
        stringBuilder.append("_20101117_gmted_mea075");
        return Helper.toLowerCase(stringBuilder.toString());
    }

    @Override
    String getFileNameOfLocalFile(double d, double d2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getFileName(d, d2));
        stringBuilder.append(".tif");
        return stringBuilder.toString();
    }

    @Override
    int getMinLatForTile(double d) {
        return (int)(Math.floor((d + 90.0) / (double)this.LAT_DEGREE) * (double)this.LAT_DEGREE) - 90;
    }

    @Override
    int getMinLonForTile(double d) {
        return (int)(Math.floor((d + 180.0) / (double)this.LON_DEGREE) * (double)this.LON_DEGREE) - 180;
    }

    @Override
    boolean isOutsideSupportedArea(double d, double d2) {
        boolean bl = d > 84.0 || d < -70.0;
        return bl;
    }

    public String toString() {
        return "gmted";
    }
}

