/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.AbstractSRTMElevationProvider;
import com.graphhopper.util.Helper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;

public class SRTMGL1Provider
extends AbstractSRTMElevationProvider {
    private final int latDegree;
    private final int lonDegree;

    public SRTMGL1Provider() {
        this("");
    }

    public SRTMGL1Provider(String string2) {
        String string3 = string2;
        if (string2.isEmpty()) {
            string3 = "/tmp/srtmgl1";
        }
        super("https://cloud.sdsc.edu/v1/AUTH_opentopography/Raster/SRTM_GL1/SRTM_GL1_srtm/", string3, "GraphHopper SRTMReader", 3601);
        this.latDegree = 1;
        this.lonDegree = 1;
    }

    private String getEastString(int n) {
        if (n < 0) {
            return "W";
        }
        return "E";
    }

    private String getLatString(int n) {
        String string2 = (n = Math.abs(n)) < 10 ? "0" : "";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    private String getLonString(int n) {
        CharSequence charSequence = (n = Math.abs(n)) < 100 ? "0" : "";
        CharSequence charSequence2 = charSequence;
        if (n < 10) {
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append((String)charSequence);
            ((StringBuilder)charSequence2).append("0");
            charSequence2 = ((StringBuilder)charSequence2).toString();
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append((String)charSequence2);
        ((StringBuilder)charSequence).append(n);
        return ((StringBuilder)charSequence).toString();
    }

    private String getNorthString(int n) {
        if (n < 0) {
            return "S";
        }
        return "N";
    }

    public static void main(String[] object) throws IOException {
        object = new SRTMGL1Provider();
        System.out.println(((AbstractSRTMElevationProvider)object).getEle(49.949784, 11.57517));
        System.out.println(((AbstractSRTMElevationProvider)object).getEle(49.968668, 11.575127));
        System.out.println(((AbstractSRTMElevationProvider)object).getEle(49.968682, 11.574842));
        System.out.println(((AbstractSRTMElevationProvider)object).getEle(-22.532854, -65.110474));
        System.out.println(((AbstractSRTMElevationProvider)object).getEle(38.065392, -87.099609));
        System.out.println(((AbstractSRTMElevationProvider)object).getEle(40.0, -105.2277023));
        System.out.println(((AbstractSRTMElevationProvider)object).getEle(39.99999999, -105.2277023));
        System.out.println(((AbstractSRTMElevationProvider)object).getEle(39.9999999, -105.2277023));
        System.out.println(((AbstractSRTMElevationProvider)object).getEle(39.999999, -105.2277023));
        System.out.println(((AbstractSRTMElevationProvider)object).getEle(47.468668, 14.575127));
        System.out.println(((AbstractSRTMElevationProvider)object).getEle(47.467753, 14.573911));
        System.out.println(((AbstractSRTMElevationProvider)object).getEle(46.468835, 12.578777));
        System.out.println(((AbstractSRTMElevationProvider)object).getEle(48.469123, 9.576393));
    }

    @Override
    String getDownloadURL(double d, double d2) {
        int n = this.getMinLonForTile(d2);
        int n2 = this.getMinLatForTile(d);
        String string2 = this.getNorthString(n2);
        String string3 = string2.equals("N") ? (d >= 30.0 ? "North/North_30_60/" : "North/North_0_29/") : "South/";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append(string2);
        stringBuilder.append(this.getLatString(n2));
        stringBuilder.append(this.getEastString(n));
        stringBuilder.append(this.getLonString(n));
        stringBuilder.append(".hgt");
        return stringBuilder.toString();
    }

    @Override
    String getFileName(double d, double d2) {
        int n = this.getMinLonForTile(d2);
        int n2 = this.getMinLatForTile(d);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getNorthString(n2));
        stringBuilder.append(this.getLatString(n2));
        stringBuilder.append(this.getEastString(n));
        stringBuilder.append(this.getLonString(n));
        return Helper.toLowerCase(stringBuilder.toString());
    }

    int getMinLatForTile(double d) {
        return (int)(Math.floor((d + 90.0) / 1.0) * 1.0) - 90;
    }

    int getMinLonForTile(double d) {
        return (int)(Math.floor((d + 180.0) / 1.0) * 1.0) - 180;
    }

    @Override
    byte[] readFile(File object) throws IOException {
        int n;
        object = new BufferedInputStream(new FileInputStream((File)object));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[65535];
        while ((n = ((FilterInputStream)object).read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        Helper.close((Closeable)object);
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        return "srtmgl1";
    }
}

