/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm.conditional;

import com.graphhopper.reader.ConditionalTagInspector;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.osm.conditional.ConditionalParser;
import com.graphhopper.reader.osm.conditional.ConditionalValueParser;
import com.graphhopper.reader.osm.conditional.DateRangeParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalOSMTagInspector
implements ConditionalTagInspector {
    private boolean enabledLogs = true;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConditionalParser permitParser;
    private final ConditionalParser restrictiveParser;
    private final List<String> tagsToCheck;

    public ConditionalOSMTagInspector(Object object, List<String> list, Set<String> set, Set<String> set2) {
        this(list, Arrays.asList(new DateRangeParser((Calendar)object)), set, set2, false);
    }

    public ConditionalOSMTagInspector(List<String> object, List<? extends ConditionalValueParser> object2, Set<String> set, Set<String> set2, boolean bl) {
        this.tagsToCheck = new ArrayList<String>(object.size());
        Iterator<String> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            String string2 = iterator2.next();
            List<String> list = this.tagsToCheck;
            object = new StringBuilder();
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(":conditional");
            list.add(((StringBuilder)object).toString());
        }
        this.enabledLogs = bl;
        this.permitParser = new ConditionalParser(set2, false);
        this.restrictiveParser = new ConditionalParser(set, false);
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object = (ConditionalValueParser)object2.next();
            this.permitParser.addConditionalValueParser((ConditionalValueParser)object);
            this.restrictiveParser.addConditionalValueParser((ConditionalValueParser)object);
        }
    }

    public void addValueParser(ConditionalValueParser conditionalValueParser) {
        this.permitParser.addConditionalValueParser(conditionalValueParser);
        this.restrictiveParser.addConditionalValueParser(conditionalValueParser);
    }

    protected boolean applies(ReaderWay readerWay, boolean bl) {
        for (int i = 0; i < this.tagsToCheck.size(); ++i) {
            String string2 = this.tagsToCheck.get(i);
            String string3 = readerWay.getTag(string2);
            if (string3 == null || string3.isEmpty()) continue;
            if (bl) {
                if (!this.permitParser.checkCondition(string3)) continue;
                return true;
            }
            try {
                boolean bl2 = this.restrictiveParser.checkCondition(string3);
                if (!bl2) continue;
                return true;
            }
            catch (Exception exception) {
                if (!this.enabledLogs || string3.contains(":")) continue;
                Logger logger = this.logger;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("for way ");
                stringBuilder.append(readerWay.getId());
                stringBuilder.append(" could not parse the conditional value '");
                stringBuilder.append(string3);
                stringBuilder.append("' of tag '");
                stringBuilder.append(string2);
                stringBuilder.append("'. Exception:");
                stringBuilder.append(exception.getMessage());
                logger.warn(stringBuilder.toString());
            }
        }
        return false;
    }

    @Override
    public boolean isPermittedWayConditionallyRestricted(ReaderWay readerWay) {
        return this.applies(readerWay, false);
    }

    @Override
    public boolean isRestrictedWayConditionallyPermitted(ReaderWay readerWay) {
        return this.applies(readerWay, true);
    }
}

