/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm.conditional;

import com.graphhopper.reader.osm.conditional.ConditionalValueParser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalParser {
    private final boolean enabledLogs;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<String> restrictedTags;
    private final List<ConditionalValueParser> valueParsers = new ArrayList<ConditionalValueParser>(5);

    public ConditionalParser(Set<String> set) {
        this(set, false);
    }

    public ConditionalParser(Set<String> set, boolean bl) {
        this.restrictedTags = set;
        this.enabledLogs = bl;
    }

    public static ConditionalValueParser createNumberParser(final String string2, final Number number) {
        return new ConditionalValueParser(){

            @Override
            public ConditionalValueParser.ConditionState checkCondition(String string22) throws ParseException {
                int n = string22.indexOf("<");
                if (n > 0 && string22.length() > 2) {
                    String string3 = string22.substring(0, n).trim();
                    if (!string2.equals(string3)) {
                        return ConditionalValueParser.ConditionState.INVALID;
                    }
                    int n2 = n + 1;
                    if (string22.charAt(n2) == '=') {
                        n = n2;
                    }
                    double d = ConditionalParser.parseNumber(string22.substring(n + 1));
                    if (number.doubleValue() < d) {
                        return ConditionalValueParser.ConditionState.TRUE;
                    }
                    return ConditionalValueParser.ConditionState.FALSE;
                }
                n = string22.indexOf(">");
                if (n > 0 && string22.length() > 2) {
                    String string4 = string22.substring(0, n).trim();
                    if (!string2.equals(string4)) {
                        return ConditionalValueParser.ConditionState.INVALID;
                    }
                    int n3 = n + 1;
                    if (string22.charAt(n3) == '=') {
                        n = n3;
                    }
                    double d = ConditionalParser.parseNumber(string22.substring(n + 1));
                    if (number.doubleValue() > d) {
                        return ConditionalValueParser.ConditionState.TRUE;
                    }
                    return ConditionalValueParser.ConditionState.FALSE;
                }
                return ConditionalValueParser.ConditionState.INVALID;
            }
        };
    }

    protected static double parseNumber(String string2) {
        int n;
        for (n = string2.length() - 1; n >= 0 && !Character.isDigit(string2.charAt(n)); --n) {
        }
        return Double.parseDouble(string2.substring(0, n + 1));
    }

    public ConditionalParser addConditionalValueParser(ConditionalValueParser conditionalValueParser) {
        this.valueParsers.add(0, conditionalValueParser);
        return this;
    }

    public boolean checkCondition(String string2) throws ParseException {
        if (string2 != null && !string2.isEmpty() && string2.contains("@")) {
            if (string2.contains(";")) {
                if (this.enabledLogs) {
                    Logger logger = this.logger;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("We do not support multiple conditions yet: ");
                    stringBuilder.append(string2);
                    logger.warn(stringBuilder.toString());
                }
                return false;
            }
            Object object = string2.split("@");
            if (((String[])object).length == 2) {
                string2 = object[0].trim();
                if (!this.restrictedTags.contains(string2)) {
                    return false;
                }
                string2 = ((String)object[1]).replace('(', ' ').replace(')', ' ').trim();
                object = this.valueParsers.iterator();
                while (object.hasNext()) {
                    ConditionalValueParser.ConditionState conditionState = ((ConditionalValueParser)object.next()).checkCondition(string2);
                    if (!conditionState.isValid()) continue;
                    return conditionState.isCheckPassed();
                }
                return false;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("could not split this condition: ");
            ((StringBuilder)object).append(string2);
            throw new IllegalStateException(((StringBuilder)object).toString());
        }
        return false;
    }

    public ConditionalParser setConditionalValueParser(ConditionalValueParser conditionalValueParser) {
        this.valueParsers.clear();
        this.valueParsers.add(conditionalValueParser);
        return this;
    }
}

