/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm.conditional;

import com.graphhopper.reader.osm.conditional.ParsedCalendar;
import com.graphhopper.util.Helper;
import java.text.DateFormat;
import java.util.Calendar;

public class DateRange {
    boolean dayOnly = false;
    private final Calendar from;
    boolean reverse = false;
    private final Calendar to;
    boolean yearless = false;

    public DateRange(ParsedCalendar parsedCalendar, ParsedCalendar parsedCalendar2) {
        Comparable<Calendar> comparable = parsedCalendar.parsedCalendar;
        Calendar calendar = parsedCalendar2.parsedCalendar;
        if (((Calendar)comparable).get(0) == calendar.get(0)) {
            if (parsedCalendar.isYearless() && parsedCalendar2.isYearless()) {
                this.yearless = true;
            }
            if (parsedCalendar.isDayOnly() && parsedCalendar2.isDayOnly()) {
                this.dayOnly = true;
            }
            if (((Calendar)comparable).getTimeInMillis() > calendar.getTimeInMillis()) {
                if (!this.yearless && !this.dayOnly) {
                    comparable = new StringBuilder();
                    ((StringBuilder)comparable).append("'from' after 'to' not allowed, except for isYearless and isDayOnly DateRanges. From:");
                    ((StringBuilder)comparable).append(parsedCalendar);
                    ((StringBuilder)comparable).append(" To:");
                    ((StringBuilder)comparable).append(parsedCalendar2);
                    throw new IllegalArgumentException(((StringBuilder)comparable).toString());
                }
                this.reverse = true;
            }
            this.from = parsedCalendar.getMin();
            this.to = parsedCalendar2.getMax();
            return;
        }
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append("Different calendar eras are not allowed. From:");
        ((StringBuilder)comparable).append(parsedCalendar);
        ((StringBuilder)comparable).append(" To:");
        ((StringBuilder)comparable).append(parsedCalendar2);
        throw new IllegalArgumentException(((StringBuilder)comparable).toString());
    }

    private boolean isInRangeYearless(Calendar calendar) {
        if (this.from.get(2) < calendar.get(2) && calendar.get(2) < this.to.get(2)) {
            return true;
        }
        if (this.from.get(2) == calendar.get(2) && this.to.get(2) == calendar.get(2)) {
            return this.from.get(5) <= calendar.get(5) && calendar.get(5) <= this.to.get(5);
        }
        if (this.from.get(2) == calendar.get(2)) {
            return this.from.get(5) <= calendar.get(5);
        }
        return this.to.get(2) == calendar.get(2) && calendar.get(5) <= this.to.get(5);
    }

    private boolean isInRangeYearlessReverse(Calendar calendar) {
        int n = calendar.get(2);
        if (this.from.get(2) >= n && n >= this.to.get(2)) {
            if (this.from.get(2) == n && this.to.get(2) == n) {
                return this.from.get(5) < calendar.get(5) || calendar.get(5) < this.to.get(5);
                {
                }
            }
            if (this.from.get(2) == n) {
                return this.from.get(5) <= calendar.get(5);
            }
            return this.to.get(2) == n && calendar.get(5) <= this.to.get(5);
        }
        return true;
    }

    public boolean isInRange(Calendar calendar) {
        boolean bl = this.yearless;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        if (!bl && !this.dayOnly) {
            if (!calendar.after(this.from) || !calendar.before(this.to)) {
                bl4 = false;
            }
            return bl4;
        }
        if (this.dayOnly) {
            int n = calendar.get(7);
            if (this.reverse) {
                bl4 = bl2;
                if (this.from.get(7) > n) {
                    bl4 = n <= this.to.get(7) ? bl2 : false;
                }
                return bl4;
            }
            bl4 = this.from.get(7) <= n && n <= this.to.get(7) ? bl3 : false;
            return bl4;
        }
        if (this.reverse) {
            return this.isInRangeYearlessReverse(calendar);
        }
        return this.isInRangeYearless(calendar);
    }

    public String toString() {
        DateFormat dateFormat = Helper.createFormatter();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("yearless:");
        stringBuilder.append(this.yearless);
        stringBuilder.append(", dayOnly:");
        stringBuilder.append(this.dayOnly);
        stringBuilder.append(", reverse:");
        stringBuilder.append(this.reverse);
        stringBuilder.append(", from:");
        stringBuilder.append(dateFormat.format(this.from.getTime()));
        stringBuilder.append(", to:");
        stringBuilder.append(dateFormat.format(this.to.getTime()));
        return stringBuilder.toString();
    }
}

