/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm.conditional;

import com.graphhopper.reader.osm.conditional.ConditionalValueParser;
import com.graphhopper.reader.osm.conditional.DateRange;
import com.graphhopper.reader.osm.conditional.ParsedCalendar;
import com.graphhopper.util.Helper;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public class DateRangeParser
implements ConditionalValueParser {
    private static final List<String> DAY_NAMES;
    private static final DateFormat MONTH_DAY2_DF;
    private static final DateFormat MONTH_DAY_DF;
    private static final DateFormat MONTH_DF;
    private static final DateFormat YEAR_MONTH_DAY_DF;
    private static final DateFormat YEAR_MONTH_DF;
    private Calendar date;

    static {
        YEAR_MONTH_DAY_DF = Helper.createFormatter("yyyy MMM dd");
        MONTH_DAY_DF = Helper.createFormatter("MMM dd");
        MONTH_DAY2_DF = Helper.createFormatter("dd.MM");
        YEAR_MONTH_DF = Helper.createFormatter("yyyy MMM");
        MONTH_DF = Helper.createFormatter("MMM");
        DAY_NAMES = Arrays.asList("Su", "Mo", "Tu", "We", "Th", "Fr", "Sa");
    }

    public DateRangeParser() {
        this(DateRangeParser.createCalendar());
    }

    public DateRangeParser(Calendar calendar) {
        this.date = calendar;
    }

    public static Calendar createCalendar() {
        return Calendar.getInstance(Helper.UTC, Locale.US);
    }

    static ParsedCalendar parseDateString(String object) throws ParseException {
        String string2;
        block10: {
            string2 = ((String)object).replaceAll("(,( )*)?(PH|SH)", "").trim();
            Calendar calendar = DateRangeParser.createCalendar();
            try {
                calendar.setTime(YEAR_MONTH_DAY_DF.parse(string2));
                object = new ParsedCalendar(ParsedCalendar.ParseType.YEAR_MONTH_DAY, calendar);
            }
            catch (ParseException parseException) {
                try {
                    calendar.setTime(MONTH_DAY_DF.parse(string2));
                    object = new ParsedCalendar(ParsedCalendar.ParseType.MONTH_DAY, calendar);
                }
                catch (ParseException parseException2) {
                    try {
                        calendar.setTime(MONTH_DAY2_DF.parse(string2));
                        object = new ParsedCalendar(ParsedCalendar.ParseType.MONTH_DAY, calendar);
                    }
                    catch (ParseException parseException3) {
                        try {
                            calendar.setTime(YEAR_MONTH_DF.parse(string2));
                            object = new ParsedCalendar(ParsedCalendar.ParseType.YEAR_MONTH, calendar);
                        }
                        catch (ParseException parseException4) {
                            try {
                                calendar.setTime(MONTH_DF.parse(string2));
                                object = new ParsedCalendar(ParsedCalendar.ParseType.MONTH, calendar);
                            }
                            catch (ParseException parseException5) {
                                int n = DAY_NAMES.indexOf(string2);
                                if (n < 0) break block10;
                                calendar.set(7, n + 1);
                                object = new ParsedCalendar(ParsedCalendar.ParseType.DAY, calendar);
                            }
                        }
                    }
                }
            }
            return object;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unparseable date: \"");
        stringBuilder.append(string2);
        stringBuilder.append("\"");
        throw new ParseException(stringBuilder.toString(), 0);
    }

    @Override
    public ConditionalValueParser.ConditionState checkCondition(String object) throws ParseException {
        if ((object = this.getRange((String)object)) == null) {
            return ConditionalValueParser.ConditionState.INVALID;
        }
        if (((DateRange)object).isInRange(this.date)) {
            return ConditionalValueParser.ConditionState.TRUE;
        }
        return ConditionalValueParser.ConditionState.FALSE;
    }

    public DateRange getRange(String object) throws ParseException {
        if (object != null && !object.isEmpty()) {
            if (((String[])(object = object.split("-"))).length <= 2 && ((String[])object).length >= 1) {
                ParsedCalendar parsedCalendar = DateRangeParser.parseDateString(object[0]);
                object = ((String[])object).length == 2 ? DateRangeParser.parseDateString(object[1]) : DateRangeParser.parseDateString(object[0]);
                return new DateRange(parsedCalendar, (ParsedCalendar)object);
            }
            return null;
        }
        throw new IllegalArgumentException("Passing empty Strings is not allowed");
    }
}

