/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AbstractBidirAlgo;
import com.graphhopper.routing.RecalculationHook;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.ConsistentWeightApproximator;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;

public class AStarBidirection
extends AbstractBidirAlgo
implements RecalculationHook {
    private ConsistentWeightApproximator weightApprox;

    public AStarBidirection(Graph object, Weighting weighting, TraversalMode traversalMode) {
        super((Graph)object, weighting, traversalMode);
        object = new BeelineWeightApproximator(this.nodeAccess, weighting);
        ((BeelineWeightApproximator)object).setDistanceCalc(Helper.DIST_PLANE);
        this.setApproximation((WeightApproximator)object);
    }

    @Override
    public void afterHeuristicChange(boolean bl, boolean bl2) {
        AStar.AStarEntry[] aStarEntryArray;
        int n = 0;
        if (bl && !this.pqOpenSetFrom.isEmpty()) {
            aStarEntryArray = this.pqOpenSetFrom.toArray(new AStar.AStarEntry[this.pqOpenSetFrom.size()]);
            this.pqOpenSetFrom.clear();
            for (AStar.AStarEntry aStarEntry : aStarEntryArray) {
                aStarEntry.weight = aStarEntry.weightOfVisitedPath + this.weightApprox.approximate(aStarEntry.adjNode, false);
                this.pqOpenSetFrom.add(aStarEntry);
            }
        }
        if (bl2 && !this.pqOpenSetTo.isEmpty()) {
            aStarEntryArray = this.pqOpenSetTo.toArray(new AStar.AStarEntry[this.pqOpenSetTo.size()]);
            this.pqOpenSetTo.clear();
            int n2 = aStarEntryArray.length;
            for (int i = n; i < n2; ++i) {
                AStar.AStarEntry aStarEntry;
                aStarEntry = aStarEntryArray[i];
                aStarEntry.weight = aStarEntry.weightOfVisitedPath + this.weightApprox.approximate(aStarEntry.adjNode, true);
                this.pqOpenSetTo.add(aStarEntry);
            }
        }
    }

    @Override
    protected double calcWeight(EdgeIteratorState edgeIteratorState, SPTEntry sPTEntry, boolean bl) {
        return super.calcWeight(edgeIteratorState, sPTEntry, bl);
    }

    @Override
    protected SPTEntry createEntry(EdgeIteratorState object, double d, SPTEntry sPTEntry, boolean bl) {
        int n = object.getAdjNode();
        double d2 = this.weightApprox.approximate(n, bl);
        object = new AStar.AStarEntry(object.getEdge(), n, d + d2, d);
        ((AStar.AStarEntry)object).parent = sPTEntry;
        return object;
    }

    @Override
    protected AStar.AStarEntry createStartEntry(int n, double d, boolean bl) {
        return new AStar.AStarEntry(-1, n, d + this.weightApprox.approximate(n, bl), d);
    }

    public WeightApproximator getApproximation() {
        return this.weightApprox.getApproximation();
    }

    @Override
    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("astarbi|");
        stringBuilder.append(this.weightApprox);
        return stringBuilder.toString();
    }

    @Override
    void init(int n, double d, int n2, double d2) {
        this.weightApprox.setFrom(n);
        this.weightApprox.setTo(n2);
        super.init(n, d, n2, d2);
    }

    public AStarBidirection setApproximation(WeightApproximator weightApproximator) {
        this.weightApprox = new ConsistentWeightApproximator(weightApproximator);
        return this;
    }

    void setFromDataStructures(AStarBidirection aStarBidirection) {
        super.setFromDataStructures(aStarBidirection);
        this.weightApprox.setFrom(aStarBidirection.currFrom.adjNode);
    }

    void setToDataStructures(AStarBidirection aStarBidirection) {
        super.setToDataStructures(aStarBidirection);
        this.weightApprox.setTo(aStarBidirection.currTo.adjNode);
    }

    @Override
    protected void updateEntry(SPTEntry sPTEntry, EdgeIteratorState edgeIteratorState, double d, SPTEntry sPTEntry2, boolean bl) {
        sPTEntry.edge = edgeIteratorState.getEdge();
        sPTEntry.weight = this.weightApprox.approximate(edgeIteratorState.getAdjNode(), bl) + d;
        ((AStar.AStarEntry)sPTEntry).weightOfVisitedPath = d;
        sPTEntry.parent = sPTEntry2;
    }
}

