/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntObjectMap;
import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.AbstractRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.PathBidirRef;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.PriorityQueue;

public abstract class AbstractBidirAlgo
extends AbstractRoutingAlgorithm {
    protected PathBidirRef bestPath;
    protected IntObjectMap<SPTEntry> bestWeightMapFrom;
    protected IntObjectMap<SPTEntry> bestWeightMapOther;
    protected IntObjectMap<SPTEntry> bestWeightMapTo;
    protected SPTEntry currFrom;
    protected SPTEntry currTo;
    protected boolean finishedFrom;
    protected boolean finishedTo;
    PriorityQueue<SPTEntry> pqOpenSetFrom;
    PriorityQueue<SPTEntry> pqOpenSetTo;
    private boolean updateBestPath = true;
    int visitedCountFrom;
    int visitedCountTo;

    public AbstractBidirAlgo(Graph graph, Weighting weighting, TraversalMode traversalMode) {
        super(graph, weighting, traversalMode);
        this.initCollections(Math.min(Math.max(200, graph.getNodes() / 10), 150000));
    }

    private void fillEdges(SPTEntry sPTEntry, PriorityQueue<SPTEntry> priorityQueue, IntObjectMap<SPTEntry> intObjectMap, EdgeExplorer object, boolean bl) {
        EdgeIterator edgeIterator = object.setBaseNode(sPTEntry.adjNode);
        while (edgeIterator.next()) {
            if (!this.accept(edgeIterator, sPTEntry, bl)) continue;
            int n = this.getTraversalId(edgeIterator, this.getOrigEdgeId(edgeIterator, bl), bl);
            double d = this.calcWeight(edgeIterator, sPTEntry, bl);
            if (Double.isInfinite(d)) continue;
            object = (SPTEntry)intObjectMap.get(n);
            if (object == null) {
                object = this.createEntry(edgeIterator, d, sPTEntry, bl);
                intObjectMap.put(n, object);
                priorityQueue.add((SPTEntry)object);
            } else {
                if (!(((SPTEntry)object).getWeightOfVisitedPath() > d)) continue;
                priorityQueue.remove(object);
                this.updateEntry((SPTEntry)object, edgeIterator, d, sPTEntry, bl);
                priorityQueue.add((SPTEntry)object);
            }
            if (!this.updateBestPath) continue;
            this.updateBestPath(edgeIterator, (SPTEntry)object, n, bl);
        }
    }

    protected boolean accept(EdgeIteratorState edgeIteratorState, SPTEntry sPTEntry, boolean bl) {
        return this.accept(edgeIteratorState, sPTEntry.edge);
    }

    protected boolean bwdSearchCanBeStopped() {
        return false;
    }

    @Override
    public Path calcPath(int n, int n2) {
        this.checkAlreadyRun();
        this.createAndInitPath();
        this.init(n, 0.0, n2, 0.0);
        this.runAlgo();
        return this.extractPath();
    }

    protected double calcWeight(EdgeIteratorState edgeIteratorState, SPTEntry sPTEntry, boolean bl) {
        return this.weighting.calcWeight(edgeIteratorState, bl, sPTEntry.edge) + sPTEntry.getWeightOfVisitedPath();
    }

    protected Path createAndInitPath() {
        PathBidirRef pathBidirRef;
        this.bestPath = pathBidirRef = new PathBidirRef(this.graph, this.weighting);
        return pathBidirRef;
    }

    protected abstract SPTEntry createEntry(EdgeIteratorState var1, double var2, SPTEntry var4, boolean var5);

    protected abstract SPTEntry createStartEntry(int var1, double var2, boolean var4);

    @Override
    protected Path extractPath() {
        if (this.finished()) {
            return this.bestPath.extract();
        }
        return this.bestPath;
    }

    boolean fillEdgesFrom() {
        if (this.pqOpenSetFrom.isEmpty()) {
            return false;
        }
        this.currFrom = this.pqOpenSetFrom.poll();
        ++this.visitedCountFrom;
        if (this.fromEntryCanBeSkipped()) {
            return true;
        }
        if (this.fwdSearchCanBeStopped()) {
            return false;
        }
        this.bestWeightMapOther = this.bestWeightMapTo;
        this.fillEdges(this.currFrom, this.pqOpenSetFrom, this.bestWeightMapFrom, this.outEdgeExplorer, false);
        return true;
    }

    boolean fillEdgesTo() {
        if (this.pqOpenSetTo.isEmpty()) {
            return false;
        }
        this.currTo = this.pqOpenSetTo.poll();
        ++this.visitedCountTo;
        if (this.toEntryCanBeSkipped()) {
            return true;
        }
        if (this.bwdSearchCanBeStopped()) {
            return false;
        }
        this.bestWeightMapOther = this.bestWeightMapFrom;
        this.fillEdges(this.currTo, this.pqOpenSetTo, this.bestWeightMapTo, this.inEdgeExplorer, true);
        return true;
    }

    @Override
    protected boolean finished() {
        boolean bl;
        boolean bl2 = this.finishedFrom;
        boolean bl3 = bl = true;
        if (!bl2) {
            bl3 = this.finishedTo ? bl : (this.currFrom.weight + this.currTo.weight >= this.bestPath.getWeight() ? bl : false);
        }
        return bl3;
    }

    protected boolean fromEntryCanBeSkipped() {
        return false;
    }

    protected boolean fwdSearchCanBeStopped() {
        return false;
    }

    IntObjectMap<SPTEntry> getBestFromMap() {
        return this.bestWeightMapFrom;
    }

    IntObjectMap<SPTEntry> getBestToMap() {
        return this.bestWeightMapTo;
    }

    protected double getCurrentFromWeight() {
        return this.currFrom.weight;
    }

    protected double getCurrentToWeight() {
        return this.currTo.weight;
    }

    protected int getOrigEdgeId(EdgeIteratorState edgeIteratorState, boolean bl) {
        return edgeIteratorState.getEdge();
    }

    protected int getTraversalId(EdgeIteratorState edgeIteratorState, int n, boolean bl) {
        return this.traversalMode.createTraversalId(edgeIteratorState, bl);
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedCountFrom + this.visitedCountTo;
    }

    void init(int n, double d, int n2, double d2) {
        this.initFrom(n, d);
        this.initTo(n2, d2);
        this.postInit(n, n2);
    }

    protected void initCollections(int n) {
        this.pqOpenSetFrom = new PriorityQueue(n);
        this.bestWeightMapFrom = new GHIntObjectHashMap(n);
        this.pqOpenSetTo = new PriorityQueue(n);
        this.bestWeightMapTo = new GHIntObjectHashMap(n);
    }

    protected void initFrom(int n, double d) {
        SPTEntry sPTEntry;
        this.currFrom = sPTEntry = this.createStartEntry(n, d, false);
        this.pqOpenSetFrom.add(sPTEntry);
        if (!this.traversalMode.isEdgeBased()) {
            this.bestWeightMapFrom.put(n, (Object)this.currFrom);
        }
    }

    protected void initTo(int n, double d) {
        SPTEntry sPTEntry;
        this.currTo = sPTEntry = this.createStartEntry(n, d, true);
        this.pqOpenSetTo.add(sPTEntry);
        if (!this.traversalMode.isEdgeBased()) {
            this.bestWeightMapTo.put(n, (Object)this.currTo);
        }
    }

    protected void postInit(int n, int n2) {
        if (!this.traversalMode.isEdgeBased()) {
            if (this.updateBestPath) {
                this.bestWeightMapOther = this.bestWeightMapFrom;
                this.updateBestPath(GHUtility.getEdge(this.graph, this.currFrom.adjNode, n2), this.currFrom, n2, true);
            }
        } else if (n == n2) {
            this.bestPath.sptEntry = this.currFrom;
            this.bestPath.edgeTo = this.currTo;
            this.finishedFrom = true;
            this.finishedTo = true;
        }
    }

    protected void runAlgo() {
        while (!this.finished() && !this.isMaxVisitedNodesExceeded()) {
            if (!this.finishedFrom) {
                this.finishedFrom = this.fillEdgesFrom() ^ true;
            }
            if (this.finishedTo) continue;
            this.finishedTo = this.fillEdgesTo() ^ true;
        }
    }

    void setBestOtherMap(IntObjectMap<SPTEntry> intObjectMap) {
        this.bestWeightMapOther = intObjectMap;
    }

    void setBestPath(PathBidirRef pathBidirRef) {
        this.bestPath = pathBidirRef;
    }

    void setFromDataStructures(AbstractBidirAlgo abstractBidirAlgo) {
        this.pqOpenSetFrom = abstractBidirAlgo.pqOpenSetFrom;
        this.bestWeightMapFrom = abstractBidirAlgo.bestWeightMapFrom;
        this.finishedFrom = abstractBidirAlgo.finishedFrom;
        this.currFrom = abstractBidirAlgo.currFrom;
        this.visitedCountFrom = abstractBidirAlgo.visitedCountFrom;
    }

    void setToDataStructures(AbstractBidirAlgo abstractBidirAlgo) {
        this.pqOpenSetTo = abstractBidirAlgo.pqOpenSetTo;
        this.bestWeightMapTo = abstractBidirAlgo.bestWeightMapTo;
        this.finishedTo = abstractBidirAlgo.finishedTo;
        this.currTo = abstractBidirAlgo.currTo;
        this.visitedCountTo = abstractBidirAlgo.visitedCountTo;
    }

    protected void setUpdateBestPath(boolean bl) {
        this.updateBestPath = bl;
    }

    protected boolean toEntryCanBeSkipped() {
        return false;
    }

    protected void updateBestPath(EdgeIteratorState object, SPTEntry sPTEntry, int n, boolean bl) {
        double d;
        SPTEntry sPTEntry2 = (SPTEntry)this.bestWeightMapOther.get(n);
        if (sPTEntry2 == null) {
            return;
        }
        double d2 = d = sPTEntry.getWeightOfVisitedPath() + sPTEntry2.getWeightOfVisitedPath();
        SPTEntry sPTEntry3 = sPTEntry;
        if (this.traversalMode.isEdgeBased()) {
            if (sPTEntry2.edge == sPTEntry.edge) {
                if (sPTEntry2.adjNode != sPTEntry.adjNode) {
                    sPTEntry3 = sPTEntry.getParent();
                    d2 = d - this.weighting.calcWeight((EdgeIteratorState)object, bl, -1);
                } else {
                    d2 = d;
                    sPTEntry3 = sPTEntry;
                    if (!this.traversalMode.hasUTurnSupport()) {
                        return;
                    }
                }
            } else {
                object = new StringBuilder();
                ((StringBuilder)object).append("cannot happen for edge based execution of ");
                ((StringBuilder)object).append(this.getName());
                throw new IllegalStateException(((StringBuilder)object).toString());
            }
        }
        if (d2 < this.bestPath.getWeight()) {
            this.bestPath.setSwitchToFrom(bl);
            this.bestPath.setSPTEntry(sPTEntry3);
            this.bestPath.setSPTEntryTo(sPTEntry2);
            this.bestPath.setWeight(d2);
        }
    }

    protected void updateEntry(SPTEntry sPTEntry, EdgeIteratorState edgeIteratorState, double d, SPTEntry sPTEntry2, boolean bl) {
        sPTEntry.edge = edgeIteratorState.getEdge();
        sPTEntry.weight = d;
        sPTEntry.parent = sPTEntry2;
    }
}

