/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.predicates.IntObjectPredicate;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.PathBidirRef;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class AlternativeRoute
implements RoutingAlgorithm {
    private static final Comparator<AlternativeInfo> ALT_COMPARATOR = new Comparator<AlternativeInfo>(){

        @Override
        public int compare(AlternativeInfo alternativeInfo, AlternativeInfo alternativeInfo2) {
            return Double.compare(alternativeInfo.sortBy, alternativeInfo2.sortBy);
        }
    };
    private final Graph graph;
    private double maxExplorationFactor = 0.8;
    private int maxPaths = 2;
    private double maxShareFactor = 0.6;
    private int maxVisitedNodes = Integer.MAX_VALUE;
    private double maxWeightFactor = 1.4;
    private double minPlateauFactor = 0.2;
    private final TraversalMode traversalMode;
    private int visitedNodes;
    private WeightApproximator weightApproximator;
    private final Weighting weighting;

    public AlternativeRoute(Graph graph, Weighting weighting, TraversalMode traversalMode) {
        this.graph = graph;
        this.weighting = weighting;
        this.traversalMode = traversalMode;
    }

    static double calcSortBy(double d, double d2, double d3, double d4, double d5, double d6) {
        return d * d2 + d3 * d4 + d5 * d6;
    }

    static List<String> getAltNames(Graph object, SPTEntry sPTEntry) {
        if (sPTEntry != null && EdgeIterator.Edge.isValid(sPTEntry.edge)) {
            if ((object = object.getEdgeIteratorState(sPTEntry.edge, Integer.MIN_VALUE)) == null) {
                return Collections.emptyList();
            }
            if (((String)(object = object.getName())).isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(object);
        }
        return Collections.emptyList();
    }

    public List<AlternativeInfo> calcAlternatives(int n, int n2) {
        AlternativeBidirSearch alternativeBidirSearch = new AlternativeBidirSearch(this.graph, this.weighting, this.traversalMode, this.maxExplorationFactor * 2.0);
        alternativeBidirSearch.setMaxVisitedNodes(this.maxVisitedNodes);
        WeightApproximator weightApproximator = this.weightApproximator;
        if (weightApproximator != null) {
            alternativeBidirSearch.setApproximation(weightApproximator);
        }
        alternativeBidirSearch.searchBest(n, n2);
        this.visitedNodes = alternativeBidirSearch.getVisitedNodes();
        return alternativeBidirSearch.calcAlternatives(this.maxPaths, this.maxWeightFactor, 7.0, this.maxShareFactor, 0.8, this.minPlateauFactor, -0.2);
    }

    @Override
    public Path calcPath(int n, int n2) {
        return this.calcPaths(n, n2).get(0);
    }

    @Override
    public List<Path> calcPaths(int n, int n2) {
        Object object = this.calcAlternatives(n, n2);
        ArrayList<Path> arrayList = new ArrayList<Path>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add(((AlternativeInfo)object.next()).getPath());
        }
        return arrayList;
    }

    @Override
    public String getName() {
        return "alternative_route";
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedNodes;
    }

    public void setApproximation(WeightApproximator weightApproximator) {
        this.weightApproximator = weightApproximator;
    }

    public void setMaxExplorationFactor(double d) {
        this.maxExplorationFactor = d;
    }

    public void setMaxPaths(int n) {
        this.maxPaths = n;
        if (n >= 2) {
            return;
        }
        throw new IllegalStateException("Use normal algorithm with less overhead instead if no alternatives are required");
    }

    public void setMaxShareFactor(double d) {
        this.maxShareFactor = d;
    }

    @Override
    public void setMaxVisitedNodes(int n) {
        this.maxVisitedNodes = n;
    }

    public void setMaxWeightFactor(double d) {
        this.maxWeightFactor = d;
    }

    public void setMinPlateauFactor(double d) {
        this.minPlateauFactor = d;
    }

    public static class AlternativeBidirSearch
    extends AStarBidirection {
        private final double explorationFactor;

        public AlternativeBidirSearch(Graph graph, Weighting weighting, TraversalMode traversalMode, double d) {
            super(graph, weighting, traversalMode);
            this.explorationFactor = d;
        }

        AtomicInteger addToMap(GHIntObjectHashMap<IntSet> gHIntObjectHashMap, Path object2) {
            GHIntHashSet gHIntHashSet = new GHIntHashSet();
            AtomicInteger atomicInteger = new AtomicInteger(-1);
            for (EdgeIteratorState edgeIteratorState : ((Path)object2).calcEdges()) {
                int n = this.traversalMode.createTraversalId(edgeIteratorState, false);
                gHIntHashSet.add(n);
                if (atomicInteger.get() >= 0) continue;
                if (!this.traversalMode.isEdgeBased()) {
                    n = edgeIteratorState.getBaseNode();
                    gHIntHashSet.add(n);
                }
                atomicInteger.set(n);
            }
            gHIntObjectHashMap.put(atomicInteger.get(), (Object)gHIntHashSet);
            return atomicInteger;
        }

        public List<AlternativeInfo> calcAlternatives(int n, double d, double d2, double d3, double d4, double d5, double d6) {
            double d7 = this.bestPath.getWeight();
            GHIntObjectHashMap<IntSet> gHIntObjectHashMap = new GHIntObjectHashMap<IntSet>();
            AtomicInteger atomicInteger = this.addToMap(gHIntObjectHashMap, this.bestPath);
            ArrayList<AlternativeInfo> arrayList = new ArrayList<AlternativeInfo>(n);
            double d8 = this.bestPath.getWeight();
            AlternativeInfo alternativeInfo = new AlternativeInfo(AlternativeRoute.calcSortBy(d2, this.bestPath.getWeight(), d4, 0.0, d6, d8), this.bestPath, this.bestPath.sptEntry, this.bestPath.edgeTo, 0.0, AlternativeRoute.getAltNames(this.graph, this.bestPath.sptEntry));
            arrayList.add(alternativeInfo);
            ArrayList arrayList2 = new ArrayList(2);
            this.bestWeightMapFrom.forEach((IntObjectPredicate)new IntObjectPredicate<SPTEntry>(d7 * d, d5, d3, d2, d4, d6, arrayList, n, alternativeInfo, gHIntObjectHashMap, atomicInteger, arrayList2){
                static final /* synthetic */ boolean $assertionsDisabled = false;
                final /* synthetic */ List val$alternatives;
                final /* synthetic */ AlternativeInfo val$bestAlt;
                final /* synthetic */ List val$bestPathEntries;
                final /* synthetic */ int val$maxPaths;
                final /* synthetic */ double val$maxShareFactor;
                final /* synthetic */ double val$maxWeight;
                final /* synthetic */ double val$minPlateauFactor;
                final /* synthetic */ double val$plateauInfluence;
                final /* synthetic */ double val$shareInfluence;
                final /* synthetic */ AtomicInteger val$startTID;
                final /* synthetic */ GHIntObjectHashMap val$traversalIDMap;
                final /* synthetic */ double val$weightInfluence;
                {
                    this.val$maxWeight = d;
                    this.val$minPlateauFactor = d2;
                    this.val$maxShareFactor = d3;
                    this.val$weightInfluence = d4;
                    this.val$shareInfluence = d5;
                    this.val$plateauInfluence = d6;
                    this.val$alternatives = list;
                    this.val$maxPaths = n;
                    this.val$bestAlt = alternativeInfo;
                    this.val$traversalIDMap = gHIntObjectHashMap;
                    this.val$startTID = atomicInteger;
                    this.val$bestPathEntries = list2;
                }

                public boolean apply(int n, SPTEntry object) {
                    Object object2;
                    double d;
                    SPTEntry sPTEntry;
                    Object object3 = (SPTEntry)AlternativeBidirSearch.this.bestWeightMapTo.get(n);
                    if (object3 == null) {
                        return true;
                    }
                    if (AlternativeBidirSearch.this.traversalMode.isEdgeBased()) {
                        sPTEntry = object3;
                        if (((SPTEntry)object3).parent != null) {
                            sPTEntry = ((SPTEntry)object3).parent;
                        }
                    } else {
                        sPTEntry = object3;
                        if (((SPTEntry)object).edge == ((SPTEntry)object3).edge) {
                            return true;
                        }
                    }
                    if ((d = ((SPTEntry)object).getWeightOfVisitedPath() + sPTEntry.getWeightOfVisitedPath()) > this.val$maxWeight) {
                        return true;
                    }
                    if (this.isBestPath((SPTEntry)object, AlternativeBidirSearch.this.bestPath)) {
                        return true;
                    }
                    object3 = AlternativeBidirSearch.this.traversalMode.isEdgeBased() ? ((SPTEntry)object).parent : object;
                    if (object3 != null && ((SPTEntry)object3).parent != null) {
                        n = AlternativeBidirSearch.this.traversalMode.createTraversalId(((SPTEntry)object3).adjNode, ((SPTEntry)object3).parent.adjNode, ((SPTEntry)object3).edge, true);
                        object2 = (SPTEntry)AlternativeBidirSearch.this.bestWeightMapTo.get(n);
                        if (object2 == null) {
                            return true;
                        }
                        object3 = object2;
                        if (AlternativeBidirSearch.this.traversalMode.isEdgeBased()) {
                            object3 = ((SPTEntry)object2).parent;
                        }
                        if (((SPTEntry)object).edge == ((SPTEntry)object3).edge) {
                            return true;
                        }
                    }
                    object3 = sPTEntry;
                    double d2 = 0.0;
                    while (((SPTEntry)object3).parent != null && (object2 = (SPTEntry)AlternativeBidirSearch.this.bestWeightMapFrom.get(n = AlternativeBidirSearch.this.traversalMode.createTraversalId(((SPTEntry)object3).adjNode, ((SPTEntry)object3).parent.adjNode, ((SPTEntry)object3).edge, false))) != null && ((SPTEntry)object3).edge == ((SPTEntry)object2).edge) {
                        d2 += ((SPTEntry)object3).getWeightOfVisitedPath() - ((SPTEntry)object3).parent.getWeightOfVisitedPath();
                        object3 = ((SPTEntry)object3).parent;
                    }
                    if (!(d2 <= 0.0) && !(d2 / d < this.val$minPlateauFactor)) {
                        if (((SPTEntry)object).parent != null) {
                            object3 = this.getFirstShareEE(((SPTEntry)object).parent, true);
                            SPTEntry sPTEntry2 = this.getFirstShareEE(sPTEntry.parent, false);
                            double d3 = ((SPTEntry)object3).getWeightOfVisitedPath() + sPTEntry2.getWeightOfVisitedPath();
                            n = d3 / AlternativeBidirSearch.this.bestPath.getWeight() < this.val$maxShareFactor ? 1 : 0;
                            if (n != 0) {
                                object2 = AlternativeRoute.getAltNames(AlternativeBidirSearch.this.graph, (SPTEntry)object);
                                if ((d2 = AlternativeRoute.calcSortBy(this.val$weightInfluence, d, this.val$shareInfluence, d3, this.val$plateauInfluence, d2)) < this.getWorstSortBy() || this.val$alternatives.size() < this.val$maxPaths) {
                                    object = new PathBidirRef(AlternativeBidirSearch.this.graph, AlternativeBidirSearch.this.weighting).setSPTEntryTo(sPTEntry).setSPTEntry((SPTEntry)object).setWeight(d);
                                    ((Path)object).extract();
                                    this.val$alternatives.add(new AlternativeInfo(d2, (Path)object, (SPTEntry)object3, sPTEntry2, d3, (List<String>)object2));
                                    Collections.sort(this.val$alternatives, ALT_COMPARATOR);
                                    if (this.val$alternatives.get(0) == this.val$bestAlt) {
                                        int n2 = this.val$alternatives.size();
                                        if (n2 > (n = this.val$maxPaths)) {
                                            object = this.val$alternatives;
                                            object.subList(n, object.size()).clear();
                                        }
                                    } else {
                                        throw new IllegalStateException("best path should be always first entry");
                                    }
                                }
                            }
                            return true;
                        }
                        throw new IllegalStateException("not implemented yet. in case of an edge based traversal the parent of fromSPTEntry could be null");
                    }
                    return true;
                }

                SPTEntry getFirstShareEE(SPTEntry sPTEntry, boolean bl) {
                    while (sPTEntry.parent != null) {
                        if (this.isAlreadyExisting(AlternativeBidirSearch.this.traversalMode.createTraversalId(sPTEntry.adjNode, sPTEntry.parent.adjNode, sPTEntry.edge, bl))) {
                            return sPTEntry;
                        }
                        sPTEntry = sPTEntry.parent;
                    }
                    return sPTEntry;
                }

                double getWorstSortBy() {
                    if (!this.val$alternatives.isEmpty()) {
                        List list = this.val$alternatives;
                        return ((AlternativeInfo)list.get(list.size() - 1)).sortBy;
                    }
                    throw new IllegalStateException("Empty alternative list cannot happen");
                }

                boolean isAlreadyExisting(final int n) {
                    final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                    this.val$traversalIDMap.forEach((IntObjectPredicate)new IntObjectPredicate<IntSet>(){

                        public boolean apply(int n2, IntSet intSet) {
                            if (intSet.contains(n)) {
                                atomicBoolean.set(true);
                                return false;
                            }
                            return true;
                        }
                    });
                    return atomicBoolean.get();
                }

                boolean isBestPath(SPTEntry comparable, Path object) {
                    if (AlternativeBidirSearch.this.traversalMode.isEdgeBased()) {
                        if (GHUtility.getEdgeFromEdgeKey(this.val$startTID.get()) == ((SPTEntry)comparable).edge) {
                            if (((SPTEntry)comparable).parent != null) {
                                return true;
                            }
                            object = new StringBuilder();
                            ((StringBuilder)object).append("best path must have no parent but was non-null: ");
                            ((StringBuilder)object).append(comparable);
                            throw new IllegalStateException(((StringBuilder)object).toString());
                        }
                    } else if (((SPTEntry)comparable).parent == null) {
                        this.val$bestPathEntries.add(comparable);
                        if (this.val$bestPathEntries.size() <= 1) {
                            if (this.val$startTID.get() == ((SPTEntry)comparable).adjNode) {
                                return true;
                            }
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Start traversal ID has to be identical to root edge entry which is the plateau start of the best path but was: ");
                            ((StringBuilder)object).append(this.val$startTID);
                            ((StringBuilder)object).append(" vs. adjNode: ");
                            ((StringBuilder)object).append(((SPTEntry)comparable).adjNode);
                            throw new IllegalStateException(((StringBuilder)object).toString());
                        }
                        comparable = new StringBuilder();
                        ((StringBuilder)comparable).append("There is only one best path but was: ");
                        ((StringBuilder)comparable).append(this.val$bestPathEntries);
                        throw new IllegalStateException(((StringBuilder)comparable).toString());
                    }
                    return false;
                }
            });
            return arrayList;
        }

        @Override
        public boolean finished() {
            boolean bl = this.finishedFrom;
            boolean bl2 = true;
            if (bl && this.finishedTo) {
                return true;
            }
            if (this.isMaxVisitedNodesExceeded()) {
                return true;
            }
            if (!this.bestPath.isFound() && (this.finishedFrom || this.finishedTo)) {
                return true;
            }
            if (!(this.currFrom.weight + this.currTo.weight > this.explorationFactor * this.bestPath.getWeight())) {
                bl2 = false;
            }
            return bl2;
        }

        public Path searchBest(int n, int n2) {
            this.createAndInitPath();
            this.init(n, 0.0, n2, 0.0);
            this.runAlgo();
            return this.extractPath();
        }
    }

    public static class AlternativeInfo {
        private final List<String> names;
        private final Path path;
        private final SPTEntry shareEnd;
        private final SPTEntry shareStart;
        private final double shareWeight;
        private final double sortBy;

        public AlternativeInfo(double d, Path path, SPTEntry sPTEntry, SPTEntry sPTEntry2, double d2, List<String> list) {
            this.names = list;
            this.sortBy = d;
            this.path = path;
            path.setDescription(list);
            this.shareStart = sPTEntry;
            this.shareEnd = sPTEntry2;
            this.shareWeight = d2;
        }

        public Path getPath() {
            return this.path;
        }

        public SPTEntry getShareEnd() {
            return this.shareEnd;
        }

        public SPTEntry getShareStart() {
            return this.shareStart;
        }

        public double getShareWeight() {
            return this.shareWeight;
        }

        public double getSortBy() {
            return this.sortBy;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.names);
            stringBuilder.append(", sortBy:");
            stringBuilder.append(this.sortBy);
            stringBuilder.append(", shareWeight:");
            stringBuilder.append(this.shareWeight);
            stringBuilder.append(", ");
            stringBuilder.append(this.path);
            return stringBuilder.toString();
        }
    }

    public static class PlateauInfo {
        List<Integer> edges;
        String name;

        public PlateauInfo(String string2, List<Integer> list) {
            this.name = string2;
            this.edges = list;
        }

        public List<Integer> getEdges() {
            return this.edges;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

