/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntObjectMap;
import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.AbstractRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import java.util.PriorityQueue;

public class Dijkstra
extends AbstractRoutingAlgorithm {
    protected SPTEntry currEdge;
    protected PriorityQueue<SPTEntry> fromHeap;
    protected IntObjectMap<SPTEntry> fromMap;
    private int to = -1;
    private int visitedNodes;

    public Dijkstra(Graph graph, Weighting weighting, TraversalMode traversalMode) {
        super(graph, weighting, traversalMode);
        this.initCollections(Math.min(Math.max(200, graph.getNodes() / 10), 2000));
    }

    @Override
    public Path calcPath(int n, int n2) {
        this.checkAlreadyRun();
        this.to = n2;
        this.currEdge = new SPTEntry(n, 0.0);
        if (!this.traversalMode.isEdgeBased()) {
            this.fromMap.put(n, (Object)this.currEdge);
        }
        this.runAlgo();
        return this.extractPath();
    }

    @Override
    protected Path extractPath() {
        if (this.currEdge != null && this.finished()) {
            return new Path(this.graph, this.weighting).setWeight(this.currEdge.weight).setSPTEntry(this.currEdge).extract();
        }
        return this.createEmptyPath();
    }

    @Override
    protected boolean finished() {
        boolean bl = this.currEdge.adjNode == this.to;
        return bl;
    }

    @Override
    public String getName() {
        return "dijkstra";
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedNodes;
    }

    protected void initCollections(int n) {
        this.fromHeap = new PriorityQueue(n);
        this.fromMap = new GHIntObjectHashMap(n);
    }

    protected void runAlgo() {
        block4: {
            SPTEntry sPTEntry;
            EdgeExplorer edgeExplorer = this.outEdgeExplorer;
            do {
                ++this.visitedNodes;
                if (this.isMaxVisitedNodesExceeded() || this.finished()) break block4;
                EdgeIterator edgeIterator = edgeExplorer.setBaseNode(this.currEdge.adjNode);
                while (edgeIterator.next()) {
                    if (!this.accept(edgeIterator, this.currEdge.edge)) continue;
                    int n = this.traversalMode.createTraversalId(edgeIterator, false);
                    double d = this.weighting.calcWeight(edgeIterator, false, this.currEdge.edge) + this.currEdge.weight;
                    if (Double.isInfinite(d)) continue;
                    sPTEntry = (SPTEntry)this.fromMap.get(n);
                    if (sPTEntry == null) {
                        sPTEntry = new SPTEntry(edgeIterator.getEdge(), edgeIterator.getAdjNode(), d);
                        sPTEntry.parent = this.currEdge;
                        this.fromMap.put(n, (Object)sPTEntry);
                        this.fromHeap.add(sPTEntry);
                    } else {
                        if (!(sPTEntry.weight > d)) continue;
                        this.fromHeap.remove(sPTEntry);
                        sPTEntry.edge = edgeIterator.getEdge();
                        sPTEntry.weight = d;
                        sPTEntry.parent = this.currEdge;
                        this.fromHeap.add(sPTEntry);
                    }
                    this.updateBestPath(edgeIterator, sPTEntry, n);
                }
                if (this.fromHeap.isEmpty()) break block4;
                this.currEdge = sPTEntry = this.fromHeap.poll();
            } while (sPTEntry != null);
            throw new AssertionError((Object)"Empty edge cannot happen");
        }
    }

    protected void updateBestPath(EdgeIteratorState edgeIteratorState, SPTEntry sPTEntry, int n) {
    }
}

