/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.apache.commons.collections.IntDoubleBinaryHeap;
import com.graphhopper.routing.AbstractRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.PathNative;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeIterator;
import java.util.Arrays;

public class DijkstraOneToMany
extends AbstractRoutingAlgorithm {
    private static final int EMPTY_PARENT = -1;
    private static final int NOT_FOUND = -1;
    private final IntArrayListWithCap changedNodes;
    private int currNode;
    private boolean doClear = true;
    private int[] edgeIds;
    private int endNode;
    private int fromNode;
    private IntDoubleBinaryHeap heap;
    private int[] parents;
    private int to;
    private int visitedNodes;
    private double weightLimit = Double.MAX_VALUE;
    protected double[] weights;

    public DijkstraOneToMany(Graph object, Weighting object2, TraversalMode traversalMode) {
        super((Graph)object, (Weighting)object2, traversalMode);
        object2 = new int[object.getNodes()];
        this.parents = (int[])object2;
        Arrays.fill((int[])object2, -1);
        object2 = new int[object.getNodes()];
        this.edgeIds = (int[])object2;
        Arrays.fill((int[])object2, -1);
        object = new double[object.getNodes()];
        this.weights = (double[])object;
        Arrays.fill((double[])object, Double.MAX_VALUE);
        this.heap = new IntDoubleBinaryHeap(1000);
        this.changedNodes = new IntArrayListWithCap();
    }

    @Override
    public Path calcPath(int n, int n2) {
        this.fromNode = n;
        this.endNode = this.findEndNode(n, n2);
        return this.extractPath();
    }

    public DijkstraOneToMany clear() {
        this.doClear = true;
        return this;
    }

    public void close() {
        this.weights = null;
        this.parents = null;
        this.edgeIds = null;
        this.heap = null;
    }

    @Override
    public Path extractPath() {
        PathNative pathNative = new PathNative(this.graph, this.weighting, this.parents, this.edgeIds);
        int n = this.endNode;
        if (n >= 0) {
            pathNative.setWeight(this.weights[n]);
        }
        pathNative.setFromNode(this.fromNode);
        Path path = pathNative;
        if (this.endNode >= 0) {
            path = this.isWeightLimitExceeded() ? pathNative : pathNative.setEndNode(this.endNode).extract();
        }
        return path;
    }

    public int findEndNode(int n, int n2) {
        block16: {
            double[] dArray;
            block15: {
                block14: {
                    dArray = this.weights;
                    if (dArray.length < 2) {
                        return -1;
                    }
                    this.to = n2;
                    if (!this.doClear) break block14;
                    this.doClear = false;
                    int n3 = this.changedNodes.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        int n4 = this.changedNodes.get(n2);
                        this.weights[n4] = Double.MAX_VALUE;
                        this.parents[n4] = -1;
                        this.edgeIds[n4] = -1;
                    }
                    this.heap.clear();
                    this.changedNodes.elementsCount = 0;
                    this.currNode = n;
                    if (!this.traversalMode.isEdgeBased()) {
                        dArray = this.weights;
                        n = this.currNode;
                        dArray[n] = 0.0;
                        this.changedNodes.add(n);
                    }
                    break block15;
                }
                if (this.parents[n2] != -1 && dArray[n2] <= dArray[this.currNode]) {
                    return n2;
                }
                if (this.heap.isEmpty() || this.isMaxVisitedNodesExceeded()) break block16;
                this.currNode = this.heap.poll_element();
            }
            this.visitedNodes = 0;
            if (this.finished()) {
                if (this.heap.isEmpty()) {
                    this.doClear = true;
                }
                return this.currNode;
            }
            while (true) {
                ++this.visitedNodes;
                EdgeIterator edgeIterator = this.outEdgeExplorer.setBaseNode(this.currNode);
                while (edgeIterator.next()) {
                    double d;
                    n2 = edgeIterator.getAdjNode();
                    n = this.edgeIds[n2];
                    if (!this.accept(edgeIterator, n) || Double.isInfinite(d = this.weighting.calcWeight(edgeIterator, false, n) + this.weights[this.currNode])) continue;
                    dArray = this.weights;
                    double d2 = dArray[n2];
                    if (d2 == Double.MAX_VALUE) {
                        this.parents[n2] = this.currNode;
                        dArray[n2] = d;
                        this.heap.insert_(d, n2);
                        this.changedNodes.add(n2);
                        this.edgeIds[n2] = edgeIterator.getEdge();
                        continue;
                    }
                    if (!(d2 > d)) continue;
                    this.parents[n2] = this.currNode;
                    dArray[n2] = d;
                    this.heap.update_(d, n2);
                    this.changedNodes.add(n2);
                    this.edgeIds[n2] = edgeIterator.getEdge();
                }
                if (this.heap.isEmpty() || this.isMaxVisitedNodesExceeded() || this.isWeightLimitExceeded()) break;
                this.currNode = this.heap.peek_element();
                if (this.finished()) {
                    return this.currNode;
                }
                this.heap.poll_element();
            }
        }
        return -1;
    }

    @Override
    public boolean finished() {
        boolean bl = this.currNode == this.to;
        return bl;
    }

    public String getMemoryUsageAsString() {
        long l = this.weights.length;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((l * 16L + (long)this.changedNodes.getCapacity() * 4L + this.heap.getCapacity() * 8L) / 0x100000L);
        stringBuilder.append("MB");
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        return "dijkstra_one_to_many";
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedNodes;
    }

    public double getWeight(int n) {
        return this.weights[n];
    }

    protected boolean isWeightLimitExceeded() {
        boolean bl = this.weights[this.currNode] > this.weightLimit;
        return bl;
    }

    public void setWeightLimit(double d) {
        this.weightLimit = d;
    }

    private static class IntArrayListWithCap
    extends IntArrayList {
        public int getCapacity() {
            return this.buffer.length;
        }
    }
}

