/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.Path;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeIterator;

public class PathBidirRef
extends Path {
    protected SPTEntry edgeTo;
    private boolean switchFromAndToSPTEntry = false;

    PathBidirRef(PathBidirRef pathBidirRef) {
        super(pathBidirRef);
        this.edgeTo = pathBidirRef.edgeTo;
        this.switchFromAndToSPTEntry = pathBidirRef.switchFromAndToSPTEntry;
    }

    public PathBidirRef(Graph graph, Weighting weighting) {
        super(graph, weighting);
    }

    @Override
    public Path extract() {
        if (this.sptEntry != null && this.edgeTo != null) {
            if (this.sptEntry.adjNode == this.edgeTo.adjNode) {
                int n;
                SPTEntry sPTEntry;
                this.extractSW.start();
                if (this.switchFromAndToSPTEntry) {
                    sPTEntry = this.sptEntry;
                    this.sptEntry = this.edgeTo;
                    this.edgeTo = sPTEntry;
                }
                sPTEntry = this.sptEntry;
                boolean bl = EdgeIterator.Edge.isValid(sPTEntry.edge);
                while (true) {
                    n = -1;
                    if (!bl) break;
                    bl = EdgeIterator.Edge.isValid(sPTEntry.parent.edge);
                    if (bl) {
                        n = sPTEntry.parent.edge;
                    }
                    this.processEdge(sPTEntry.edge, sPTEntry.adjNode, n);
                    sPTEntry = sPTEntry.parent;
                }
                this.setFromNode(sPTEntry.adjNode);
                this.reverseOrder();
                sPTEntry = this.edgeTo;
                int n2 = n;
                if (bl) {
                    n2 = this.sptEntry.edge;
                }
                n = sPTEntry.edge;
                while (true) {
                    int n3 = n2;
                    n2 = n;
                    if (!EdgeIterator.Edge.isValid(n2)) break;
                    sPTEntry = sPTEntry.parent;
                    this.processEdge(n2, sPTEntry.adjNode, n3);
                    n = sPTEntry.edge;
                }
                this.setEndNode(sPTEntry.adjNode);
                this.extractSW.stop();
                return this.setFound(true);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Locations of the 'to'- and 'from'-Edge have to be the same. ");
            stringBuilder.append(this.toString());
            stringBuilder.append(", fromEntry:");
            stringBuilder.append(this.sptEntry);
            stringBuilder.append(", toEntry:");
            stringBuilder.append(this.edgeTo);
            throw new IllegalStateException(stringBuilder.toString());
        }
        return this;
    }

    public PathBidirRef setSPTEntryTo(SPTEntry sPTEntry) {
        this.edgeTo = sPTEntry;
        return this;
    }

    public PathBidirRef setSwitchToFrom(boolean bl) {
        this.switchFromAndToSPTEntry = bl;
        return this;
    }
}

