/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.predicates.IntObjectPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.VirtualEdgeIterator;
import com.graphhopper.routing.VirtualEdgeIteratorState;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphExtension;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.TurnCostExtension;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.AngleCalc;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.GHPoint3D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryGraph
implements Graph {
    private static final AngleCalc AC = Helper.ANGLE_CALC;
    static final int VE_ADJ = 2;
    static final int VE_ADJ_REV = 3;
    static final int VE_BASE = 0;
    static final int VE_BASE_REV = 1;
    private final QueryGraph baseGraph;
    private final Map<Integer, EdgeExplorer> cacheMap = new HashMap<Integer, EdgeExplorer>(4);
    private final int mainEdges;
    private final Graph mainGraph;
    private final NodeAccess mainNodeAccess;
    private final int mainNodes;
    private final NodeAccess nodeAccess = new NodeAccess(){

        @Override
        public void ensureNode(int n) {
            QueryGraph.this.mainNodeAccess.ensureNode(n);
        }

        @Override
        public int getAdditionalNodeField(int n) {
            if (QueryGraph.this.isVirtualNode(n)) {
                return 0;
            }
            return QueryGraph.this.mainNodeAccess.getAdditionalNodeField(n);
        }

        @Override
        public int getDimension() {
            return QueryGraph.this.mainNodeAccess.getDimension();
        }

        @Override
        public double getEle(int n) {
            return this.getElevation(n);
        }

        @Override
        public double getElevation(int n) {
            if (QueryGraph.this.isVirtualNode(n)) {
                return QueryGraph.this.virtualNodes.getElevation(n - QueryGraph.this.mainNodes);
            }
            return QueryGraph.this.mainNodeAccess.getElevation(n);
        }

        @Override
        public double getLat(int n) {
            return this.getLatitude(n);
        }

        @Override
        public double getLatitude(int n) {
            if (QueryGraph.this.isVirtualNode(n)) {
                return QueryGraph.this.virtualNodes.getLatitude(n - QueryGraph.this.mainNodes);
            }
            return QueryGraph.this.mainNodeAccess.getLatitude(n);
        }

        @Override
        public double getLon(int n) {
            return this.getLongitude(n);
        }

        @Override
        public double getLongitude(int n) {
            if (QueryGraph.this.isVirtualNode(n)) {
                return QueryGraph.this.virtualNodes.getLongitude(n - QueryGraph.this.mainNodes);
            }
            return QueryGraph.this.mainNodeAccess.getLongitude(n);
        }

        @Override
        public boolean is3D() {
            return QueryGraph.this.mainNodeAccess.is3D();
        }

        @Override
        public void setAdditionalNodeField(int n, int n2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setNode(int n, double d, double d2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setNode(int n, double d, double d2, double d3) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    private List<QueryResult> queryResults;
    private final Set<VirtualEdgeIteratorState> unfavoredEdges = new LinkedHashSet<VirtualEdgeIteratorState>(5);
    private boolean useEdgeExplorerCache = false;
    List<VirtualEdgeIteratorState> virtualEdges;
    private PointList virtualNodes;
    private final GraphExtension wrappedExtension;

    public QueryGraph(Graph graph) {
        this.mainGraph = graph;
        this.mainNodeAccess = graph.getNodeAccess();
        this.mainNodes = graph.getNodes();
        this.mainEdges = graph.getAllEdges().length();
        this.wrappedExtension = graph.getExtension() instanceof TurnCostExtension ? new QueryGraphTurnExt() : graph.getExtension();
        this.baseGraph = new QueryGraph(graph.getBaseGraph(), this){

            @Override
            public QueryGraph setUseEdgeExplorerCache(boolean bl) {
                QueryGraph.access$502(QueryGraph.this.baseGraph, bl);
                return QueryGraph.this.baseGraph;
            }
        };
    }

    private QueryGraph(Graph graph, QueryGraph queryGraph) {
        this.mainGraph = graph;
        this.baseGraph = this;
        this.wrappedExtension = queryGraph.wrappedExtension;
        this.mainNodeAccess = graph.getNodeAccess();
        this.mainNodes = queryGraph.mainNodes;
        this.mainEdges = queryGraph.mainEdges;
    }

    static /* synthetic */ boolean access$502(QueryGraph queryGraph, boolean bl) {
        queryGraph.useEdgeExplorerCache = bl;
        return bl;
    }

    private void addVirtualEdges(IntObjectMap<VirtualEdgeIterator> object, EdgeFilter edgeFilter, boolean bl, int n, int n2) {
        VirtualEdgeIterator virtualEdgeIterator;
        VirtualEdgeIterator virtualEdgeIterator2 = virtualEdgeIterator = (VirtualEdgeIterator)object.get(n);
        if (virtualEdgeIterator == null) {
            virtualEdgeIterator2 = new VirtualEdgeIterator(10);
            object.put(n, (Object)virtualEdgeIterator2);
        }
        if (edgeFilter.accept((EdgeIteratorState)(object = bl ? this.virtualEdges.get(n2 * 4 + 0) : this.virtualEdges.get(n2 * 4 + 3)))) {
            virtualEdgeIterator2.add((EdgeIteratorState)object);
        }
    }

    private void createEdges(int n, int n2, GHPoint3D object, int n3, GHPoint3D object2, int n4, PointList pointList, EdgeIteratorState edgeIteratorState, int n5, int n6, long l) {
        PointList pointList2 = new PointList(++n4 - n3 + 1, this.mainNodeAccess.is3D());
        pointList2.add(((GHPoint3D)object).lat, ((GHPoint3D)object).lon, ((GHPoint3D)object).ele);
        while (n3 < n4) {
            pointList2.add(pointList, n3);
            ++n3;
        }
        pointList2.add(((GHPoint3D)object2).lat, ((GHPoint3D)object2).lon, ((GHPoint3D)object2).ele);
        object2 = pointList2.clone(true);
        double d = pointList2.calcDistance(Helper.DIST_PLANE);
        n3 = this.mainEdges + this.virtualEdges.size();
        object = new VirtualEdgeIteratorState(n, n3, n5, n6, d, edgeIteratorState.getFlags(), edgeIteratorState.getName(), pointList2);
        object2 = new VirtualEdgeIteratorState(n2, n3, n6, n5, d, l, edgeIteratorState.getName(), (PointList)object2);
        ((VirtualEdgeIteratorState)object).setReverseEdge((EdgeIteratorState)object2);
        ((VirtualEdgeIteratorState)object2).setReverseEdge((EdgeIteratorState)object);
        this.virtualEdges.add((VirtualEdgeIteratorState)object);
        this.virtualEdges.add((VirtualEdgeIteratorState)object2);
    }

    private EdgeExplorer createUncachedEdgeExplorer(EdgeFilter edgeFilter) {
        GHIntObjectHashMap gHIntObjectHashMap = new GHIntObjectHashMap(this.queryResults.size() * 3);
        EdgeExplorer edgeExplorer = this.mainGraph.createEdgeExplorer(edgeFilter);
        GHIntHashSet gHIntHashSet = new GHIntHashSet(this.queryResults.size());
        for (int i = 0; i < this.queryResults.size(); ++i) {
            VirtualEdgeIterator virtualEdgeIterator = new VirtualEdgeIterator(2);
            List<VirtualEdgeIteratorState> list = this.virtualEdges;
            int n = i * 4;
            EdgeIteratorState edgeIteratorState = list.get(n + 1);
            if (edgeFilter.accept(edgeIteratorState)) {
                virtualEdgeIterator.add(edgeIteratorState);
            }
            if (edgeFilter.accept((EdgeIteratorState)((Object)(list = (EdgeIteratorState)this.virtualEdges.get(n + 2))))) {
                virtualEdgeIterator.add((EdgeIteratorState)((Object)list));
            }
            gHIntObjectHashMap.put(this.mainNodes + i, virtualEdgeIterator);
            n = edgeIteratorState.getAdjNode();
            if (!this.isVirtualNode(n)) {
                gHIntHashSet.add(n);
                this.addVirtualEdges((IntObjectMap<VirtualEdgeIterator>)gHIntObjectHashMap, edgeFilter, true, n, i);
            }
            if (this.isVirtualNode(n = list.getAdjNode())) continue;
            gHIntHashSet.add(n);
            this.addVirtualEdges((IntObjectMap<VirtualEdgeIterator>)gHIntObjectHashMap, edgeFilter, false, n, i);
        }
        gHIntHashSet.forEach(new IntProcedure((IntObjectMap)gHIntObjectHashMap, edgeExplorer){
            final /* synthetic */ EdgeExplorer val$mainExplorer;
            final /* synthetic */ IntObjectMap val$node2EdgeMap;
            {
                this.val$node2EdgeMap = intObjectMap;
                this.val$mainExplorer = edgeExplorer;
            }

            public void apply(int n) {
                QueryGraph.this.fillVirtualEdges((IntObjectMap<VirtualEdgeIterator>)this.val$node2EdgeMap, n, this.val$mainExplorer);
            }
        });
        return new EdgeExplorer((IntObjectMap)gHIntObjectHashMap, edgeExplorer){
            final /* synthetic */ EdgeExplorer val$mainExplorer;
            final /* synthetic */ IntObjectMap val$node2EdgeMap;
            {
                this.val$node2EdgeMap = intObjectMap;
                this.val$mainExplorer = edgeExplorer;
            }

            @Override
            public EdgeIterator setBaseNode(int n) {
                VirtualEdgeIterator virtualEdgeIterator = (VirtualEdgeIterator)this.val$node2EdgeMap.get(n);
                if (virtualEdgeIterator != null) {
                    return virtualEdgeIterator.reset();
                }
                return this.val$mainExplorer.setBaseNode(n);
            }
        };
    }

    private UnsupportedOperationException exc() {
        return new UnsupportedOperationException("QueryGraph cannot be modified.");
    }

    private int getPosOfReverseEdge(int n) {
        n = n % 2 == 0 ? ++n : --n;
        return n;
    }

    private boolean isInitialized() {
        boolean bl = this.queryResults != null;
        return bl;
    }

    public void clearUnfavoredStatus() {
        Iterator<VirtualEdgeIteratorState> iterator2 = this.unfavoredEdges.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().setUnfavored(false);
        }
        this.unfavoredEdges.clear();
    }

    @Override
    public Graph copyTo(Graph graph) {
        throw this.exc();
    }

    @Override
    public EdgeExplorer createEdgeExplorer() {
        return this.createEdgeExplorer(EdgeFilter.ALL_EDGES);
    }

    @Override
    public EdgeExplorer createEdgeExplorer(EdgeFilter edgeFilter) {
        if (this.isInitialized()) {
            if (this.useEdgeExplorerCache) {
                Object object;
                int n = -1;
                if (edgeFilter instanceof DefaultEdgeFilter) {
                    object = (DefaultEdgeFilter)edgeFilter;
                    int n2 = ((DefaultEdgeFilter)object).acceptsBackward();
                    n = n2;
                    if (((DefaultEdgeFilter)object).acceptsForward()) {
                        n = n2 + 2;
                    }
                    if (n == 0) {
                        throw new IllegalStateException("You tried to use an edge filter blocking every access");
                    }
                } else if (edgeFilter == EdgeFilter.ALL_EDGES) {
                    n = 4;
                }
                if (n >= 0) {
                    EdgeExplorer edgeExplorer = this.cacheMap.get(n);
                    object = edgeExplorer;
                    if (edgeExplorer == null) {
                        object = this.createUncachedEdgeExplorer(edgeFilter);
                        this.cacheMap.put(n, (EdgeExplorer)object);
                    }
                    return object;
                }
            }
            return this.createUncachedEdgeExplorer(edgeFilter);
        }
        throw new IllegalStateException("Call lookup before using this graph");
    }

    @Override
    public EdgeIteratorState edge(int n, int n2) {
        throw this.exc();
    }

    public EdgeIteratorState edge(int n, int n2, double d, int n3) {
        throw this.exc();
    }

    @Override
    public EdgeIteratorState edge(int n, int n2, double d, boolean bl) {
        throw this.exc();
    }

    public boolean enforceHeading(int n, double d, boolean bl) {
        if (this.isInitialized()) {
            if (Double.isNaN(d)) {
                return false;
            }
            if (!this.isVirtualNode(n)) {
                return false;
            }
            int n2 = this.mainNodes;
            double d2 = AC.convertAzimuth2xaxisAngle(d);
            List<Integer> list = bl ? Arrays.asList(0, 3) : Arrays.asList(1, 2);
            list = list.iterator();
            boolean bl2 = false;
            while (list.hasNext()) {
                int n3 = (Integer)list.next();
                Object object = this.virtualEdges;
                int n4 = (n - n2) * 4;
                VirtualEdgeIteratorState virtualEdgeIteratorState = object.get(n4 + n3);
                object = virtualEdgeIteratorState.fetchWayGeometry(3);
                if (bl) {
                    int n5 = ((PointList)object).getSize();
                    AngleCalc angleCalc = AC;
                    int n6 = n5 - 2;
                    double d3 = ((PointList)object).getLat(n6);
                    d = ((PointList)object).getLon(n6);
                    d = angleCalc.calcOrientation(d3, d, ((PointList)object).getLat(--n5), ((PointList)object).getLon(n5));
                } else {
                    d = AC.calcOrientation(((PointList)object).getLat(0), ((PointList)object).getLon(0), ((PointList)object).getLat(1), ((PointList)object).getLon(1));
                }
                if (!(Math.abs(AC.alignOrientation(d2, d) - d2) > 1.74)) continue;
                virtualEdgeIteratorState.setUnfavored(true);
                this.unfavoredEdges.add(virtualEdgeIteratorState);
                object = this.virtualEdges.get(n4 + this.getPosOfReverseEdge(n3));
                ((VirtualEdgeIteratorState)object).setUnfavored(true);
                this.unfavoredEdges.add((VirtualEdgeIteratorState)object);
                bl2 = true;
            }
            return bl2;
        }
        throw new IllegalStateException("QueryGraph.lookup has to be called in before heading enforcement");
    }

    void fillVirtualEdges(IntObjectMap<VirtualEdgeIterator> intArrayList, int n, EdgeExplorer object) {
        if (!this.isVirtualNode(n)) {
            VirtualEdgeIterator virtualEdgeIterator = (VirtualEdgeIterator)intArrayList.get(n);
            intArrayList = new IntArrayList(virtualEdgeIterator.count() * 2);
            while (virtualEdgeIterator.next()) {
                intArrayList.add(this.queryResults.get(virtualEdgeIterator.getAdjNode() - this.mainNodes).getClosestEdge().getEdge());
            }
            virtualEdgeIterator.reset();
            object = object.setBaseNode(n);
            while (object.next()) {
                if (intArrayList.contains(object.getEdge())) continue;
                virtualEdgeIterator.add(object.detach(false));
            }
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Node should not be virtual:");
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append(", ");
        ((StringBuilder)object).append(intArrayList);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    @Override
    public AllEdgesIterator getAllEdges() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Graph getBaseGraph() {
        return this.baseGraph;
    }

    @Override
    public BBox getBounds() {
        return this.mainGraph.getBounds();
    }

    @Override
    public EdgeIteratorState getEdgeIteratorState(int n, int n2) {
        if (!this.isVirtualEdge(n)) {
            return this.mainGraph.getEdgeIteratorState(n, n2);
        }
        int n3 = n - this.mainEdges;
        EdgeIteratorState edgeIteratorState = this.virtualEdges.get(n3);
        if (edgeIteratorState.getAdjNode() != n2 && n2 != Integer.MIN_VALUE) {
            EdgeIteratorState edgeIteratorState2 = this.virtualEdges.get(n3 = this.getPosOfReverseEdge(n3));
            if (edgeIteratorState2.getAdjNode() == n2) {
                return edgeIteratorState2;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Edge ");
            stringBuilder.append(n);
            stringBuilder.append(" not found with adjNode:");
            stringBuilder.append(n2);
            stringBuilder.append(". found edges were:");
            stringBuilder.append(edgeIteratorState);
            stringBuilder.append(", ");
            stringBuilder.append(edgeIteratorState2);
            throw new IllegalStateException(stringBuilder.toString());
        }
        return edgeIteratorState;
    }

    @Override
    public GraphExtension getExtension() {
        return this.wrappedExtension;
    }

    @Override
    public NodeAccess getNodeAccess() {
        return this.nodeAccess;
    }

    @Override
    public int getNodes() {
        return this.virtualNodes.getSize() + this.mainNodes;
    }

    public EdgeIteratorState getOriginalEdgeFromVirtNode(int n) {
        return this.queryResults.get(n - this.mainNodes).getClosestEdge();
    }

    public Set<EdgeIteratorState> getUnfavoredVirtualEdges() {
        return new LinkedHashSet<EdgeIteratorState>(this.unfavoredEdges);
    }

    public boolean isVirtualEdge(int n) {
        boolean bl = n >= this.mainEdges;
        return bl;
    }

    public boolean isVirtualNode(int n) {
        boolean bl = n >= this.mainNodes;
        return bl;
    }

    public QueryGraph lookup(QueryResult queryResult, QueryResult queryResult2) {
        ArrayList<QueryResult> arrayList = new ArrayList<QueryResult>(2);
        arrayList.add(queryResult);
        arrayList.add(queryResult2);
        this.lookup(arrayList);
        return this;
    }

    public void lookup(List<QueryResult> arrayList) {
        if (!this.isInitialized()) {
            this.virtualEdges = new ArrayList<VirtualEdgeIteratorState>(arrayList.size() * 2);
            this.virtualNodes = new PointList(arrayList.size(), this.mainNodeAccess.is3D());
            Object object3 = new ArrayList<QueryResult>(arrayList.size());
            this.queryResults = object3;
            Object object2 = this.baseGraph;
            ((QueryGraph)object2).virtualEdges = this.virtualEdges;
            ((QueryGraph)object2).virtualNodes = this.virtualNodes;
            ((QueryGraph)object2).queryResults = object3;
            GHIntObjectHashMap gHIntObjectHashMap = new GHIntObjectHashMap(arrayList.size());
            for (Object object3 : arrayList) {
                if (((QueryResult)object3).getSnappedPosition() == QueryResult.Position.TOWER) continue;
                object2 = ((QueryResult)object3).getClosestEdge();
                if (object2 != null) {
                    int n = object2.getBaseNode();
                    int n2 = object2.getAdjNode();
                    int n3 = 0;
                    n2 = n > n2 ? 1 : 0;
                    int n4 = n2;
                    if (n == object2.getAdjNode()) {
                        arrayList = object2.fetchWayGeometry(0);
                        n4 = n2;
                        if (((PointList)((Object)arrayList)).size() > 1) {
                            n2 = n3;
                            if (((PointList)((Object)arrayList)).getLatitude(0) > ((PointList)((Object)arrayList)).getLatitude(((PointList)((Object)arrayList)).size() - 1)) {
                                n2 = 1;
                            }
                            n4 = n2;
                        }
                    }
                    arrayList = object2;
                    if (n4 != 0) {
                        arrayList = object2.detach(true);
                        object2 = arrayList.fetchWayGeometry(3);
                        ((QueryResult)object3).setClosestEdge((EdgeIteratorState)((Object)arrayList));
                        if (((QueryResult)object3).getSnappedPosition() == QueryResult.Position.PILLAR) {
                            ((QueryResult)object3).setWayIndex(((PointList)object2).getSize() - ((QueryResult)object3).getWayIndex() - 1);
                        } else {
                            ((QueryResult)object3).setWayIndex(((PointList)object2).getSize() - ((QueryResult)object3).getWayIndex() - 2);
                        }
                        if (((QueryResult)object3).getWayIndex() < 0) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("Problem with wayIndex while reversing closest edge:");
                            ((StringBuilder)object2).append(arrayList);
                            ((StringBuilder)object2).append(", ");
                            ((StringBuilder)object2).append(object3);
                            throw new IllegalStateException(((StringBuilder)object2).toString());
                        }
                    }
                    n2 = arrayList.getEdge();
                    object2 = (List)gHIntObjectHashMap.get(n2);
                    arrayList = object2;
                    if (object2 == null) {
                        arrayList = new ArrayList<Object>(5);
                        gHIntObjectHashMap.put(n2, arrayList);
                    }
                    arrayList.add(object3);
                    continue;
                }
                arrayList = new StringBuilder();
                ((StringBuilder)((Object)arrayList)).append("Do not call QueryGraph.lookup with invalid QueryResult ");
                ((StringBuilder)((Object)arrayList)).append(object3);
                throw new IllegalStateException(((StringBuilder)((Object)arrayList)).toString());
            }
            gHIntObjectHashMap.forEach((IntObjectPredicate)new IntObjectPredicate<List<QueryResult>>(){

                public boolean apply(int n, List<QueryResult> object) {
                    Object object2 = object;
                    EdgeIteratorState edgeIteratorState = object2.get(0).getClosestEdge();
                    final PointList pointList = edgeIteratorState.fetchWayGeometry(3);
                    int n2 = edgeIteratorState.getBaseNode();
                    Collections.sort(object2, new Comparator<QueryResult>(){

                        @Override
                        public int compare(QueryResult queryResult, QueryResult object) {
                            int n;
                            int n2 = n = queryResult.getWayIndex() - ((QueryResult)object).getWayIndex();
                            if (n == 0) {
                                double d;
                                GHPoint3D gHPoint3D = queryResult.getSnappedPoint();
                                if (((GHPoint)gHPoint3D).equals(object = ((QueryResult)object).getSnappedPoint())) {
                                    return 0;
                                }
                                double d2 = pointList.getLatitude(queryResult.getWayIndex());
                                if (Helper.DIST_PLANE.calcNormalizedDist(d2, d = pointList.getLongitude(queryResult.getWayIndex()), gHPoint3D.lat, gHPoint3D.lon) > Helper.DIST_PLANE.calcNormalizedDist(d2, d, ((GHPoint)object).lat, ((GHPoint)object).lon)) {
                                    return 1;
                                }
                                n2 = -1;
                            }
                            return n2;
                        }
                    });
                    object2 = pointList.toGHPoint(0);
                    int n3 = edgeIteratorState.getAdjNode();
                    int n4 = GHUtility.createEdgeKey(n2, n3, edgeIteratorState.getEdge(), false);
                    int n5 = GHUtility.createEdgeKey(n2, n3, edgeIteratorState.getEdge(), true);
                    long l = edgeIteratorState.detach(true).getFlags();
                    int n6 = QueryGraph.this.virtualNodes.getSize();
                    n = QueryGraph.this.mainNodes;
                    n = n6 + n;
                    int n7 = n2;
                    int n8 = 1;
                    n6 = 0;
                    for (int i = 0; i < object.size(); ++i) {
                        QueryResult queryResult = object.get(i);
                        if (queryResult.getClosestEdge().getBaseNode() == n2) {
                            GHPoint3D gHPoint3D = queryResult.getSnappedPoint();
                            if (((GHPoint3D)object2).equals(gHPoint3D)) {
                                queryResult.setClosestNode(n7);
                                continue;
                            }
                            QueryGraph.this.queryResults.add(queryResult);
                            QueryGraph.this.createEdges(n4, n5, (GHPoint3D)object2, n8, queryResult.getSnappedPoint(), queryResult.getWayIndex(), pointList, edgeIteratorState, n7, n, l);
                            QueryGraph.this.virtualNodes.add(gHPoint3D.lat, gHPoint3D.lon, gHPoint3D.ele);
                            if (n6 != 0) {
                                QueryGraph.this.virtualEdges.add(QueryGraph.this.virtualEdges.get(QueryGraph.this.virtualEdges.size() - 2));
                                QueryGraph.this.virtualEdges.add(QueryGraph.this.virtualEdges.get(QueryGraph.this.virtualEdges.size() - 2));
                            }
                            queryResult.setClosestNode(n);
                            n8 = queryResult.getWayIndex() + 1;
                            int n9 = n + 1;
                            object2 = gHPoint3D;
                            n7 = n;
                            n6 = 1;
                            n = n9;
                            continue;
                        }
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Base nodes have to be identical but were not: ");
                        ((StringBuilder)object).append(edgeIteratorState);
                        ((StringBuilder)object).append(" vs ");
                        ((StringBuilder)object).append(queryResult.getClosestEdge());
                        throw new IllegalStateException(((StringBuilder)object).toString());
                    }
                    if (n6 != 0) {
                        QueryGraph.this.createEdges(n4, n5, (GHPoint3D)object2, n8, pointList.toGHPoint(pointList.getSize() - 1), pointList.getSize() - 2, pointList, edgeIteratorState, n - 1, n3, l);
                    }
                    return true;
                }
            });
            return;
        }
        throw new IllegalStateException("Call lookup only once. Otherwise you'll have problems for queries sharing the same edge.");
    }

    public QueryGraph setUseEdgeExplorerCache(boolean bl) {
        this.useEdgeExplorerCache = bl;
        this.baseGraph.setUseEdgeExplorerCache(bl);
        return this;
    }

    public void unfavorVirtualEdgePair(int n, int n2) {
        if (this.isVirtualNode(n)) {
            VirtualEdgeIteratorState virtualEdgeIteratorState = (VirtualEdgeIteratorState)this.getEdgeIteratorState(n2, n);
            VirtualEdgeIteratorState virtualEdgeIteratorState2 = (VirtualEdgeIteratorState)this.getEdgeIteratorState(n2, virtualEdgeIteratorState.getBaseNode());
            virtualEdgeIteratorState.setUnfavored(true);
            this.unfavoredEdges.add(virtualEdgeIteratorState);
            virtualEdgeIteratorState2.setUnfavored(true);
            this.unfavoredEdges.add(virtualEdgeIteratorState2);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Node id ");
        stringBuilder.append(n);
        stringBuilder.append(" must be a virtual node.");
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    class QueryGraphTurnExt
    extends TurnCostExtension {
        private final TurnCostExtension mainTurnExtension;

        public QueryGraphTurnExt() {
            this.mainTurnExtension = (TurnCostExtension)QueryGraph.this.mainGraph.getExtension();
        }

        @Override
        public long getTurnCostFlags(int n, int n2, int n3) {
            if (QueryGraph.this.isVirtualNode(n2)) {
                return 0L;
            }
            if (!QueryGraph.this.isVirtualEdge(n) && !QueryGraph.this.isVirtualEdge(n3)) {
                return this.mainTurnExtension.getTurnCostFlags(n, n2, n3);
            }
            int n4 = n;
            if (QueryGraph.this.isVirtualEdge(n)) {
                n4 = ((QueryResult)QueryGraph.this.queryResults.get((n - QueryGraph.this.mainEdges) / 4)).getClosestEdge().getEdge();
            }
            n = n3;
            if (QueryGraph.this.isVirtualEdge(n3)) {
                n = ((QueryResult)QueryGraph.this.queryResults.get((n3 - QueryGraph.this.mainEdges) / 4)).getClosestEdge().getEdge();
            }
            return this.mainTurnExtension.getTurnCostFlags(n4, n2, n);
        }
    }
}

