/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.AlternativeRoute;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.DijkstraOneToMany;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;

public class RoutingAlgorithmFactorySimple
implements RoutingAlgorithmFactory {
    public static WeightApproximator getApproximation(String object, AlgorithmOptions algorithmOptions, NodeAccess nodeAccess) {
        CharSequence charSequence;
        block4: {
            block3: {
                block2: {
                    PMap pMap = algorithmOptions.getHints();
                    charSequence = new StringBuilder();
                    charSequence.append((String)object);
                    charSequence.append(".approximation");
                    charSequence = pMap.get(charSequence.toString(), "BeelineSimplification");
                    pMap = algorithmOptions.getHints();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append((String)object);
                    stringBuilder.append(".epsilon");
                    double d = pMap.getDouble(stringBuilder.toString(), 1.0);
                    object = new BeelineWeightApproximator(nodeAccess, algorithmOptions.getWeighting());
                    ((BeelineWeightApproximator)object).setEpsilon(d);
                    if (!"BeelineSimplification".equals(charSequence)) break block2;
                    ((BeelineWeightApproximator)object).setDistanceCalc(Helper.DIST_PLANE);
                    break block3;
                }
                if (!"BeelineAccurate".equals(charSequence)) break block4;
                ((BeelineWeightApproximator)object).setDistanceCalc(Helper.DIST_EARTH);
            }
            return object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Approximation ");
        ((StringBuilder)object).append((String)charSequence);
        ((StringBuilder)object).append(" not found in ");
        ((StringBuilder)object).append(RoutingAlgorithmFactorySimple.class.getName());
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    @Override
    public RoutingAlgorithm createAlgo(Graph object, AlgorithmOptions algorithmOptions) {
        Object object2;
        block8: {
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    object2 = algorithmOptions.getAlgorithm();
                                    if (!"dijkstrabi".equalsIgnoreCase((String)object2)) break block2;
                                    object = new DijkstraBidirectionRef((Graph)object, algorithmOptions.getWeighting(), algorithmOptions.getTraversalMode());
                                    break block3;
                                }
                                if (!"dijkstra".equalsIgnoreCase((String)object2)) break block4;
                                object = new Dijkstra((Graph)object, algorithmOptions.getWeighting(), algorithmOptions.getTraversalMode());
                                break block3;
                            }
                            if (!"astarbi".equalsIgnoreCase((String)object2)) break block5;
                            object2 = new AStarBidirection((Graph)object, algorithmOptions.getWeighting(), algorithmOptions.getTraversalMode());
                            ((AStarBidirection)object2).setApproximation(RoutingAlgorithmFactorySimple.getApproximation("astarbi", algorithmOptions, object.getNodeAccess()));
                            object = object2;
                            break block3;
                        }
                        if (!"dijkstra_one_to_many".equalsIgnoreCase((String)object2)) break block6;
                        object = new DijkstraOneToMany((Graph)object, algorithmOptions.getWeighting(), algorithmOptions.getTraversalMode());
                        break block3;
                    }
                    if (!"astar".equalsIgnoreCase((String)object2)) break block7;
                    object2 = new AStar((Graph)object, algorithmOptions.getWeighting(), algorithmOptions.getTraversalMode());
                    ((AStar)object2).setApproximation(RoutingAlgorithmFactorySimple.getApproximation("astar", algorithmOptions, object.getNodeAccess()));
                    object = object2;
                    break block3;
                }
                if (!"alternative_route".equalsIgnoreCase((String)object2)) break block8;
                object = new AlternativeRoute((Graph)object, algorithmOptions.getWeighting(), algorithmOptions.getTraversalMode());
                ((AlternativeRoute)object).setMaxPaths(algorithmOptions.getHints().getInt("alternative_route.max_paths", 2));
                ((AlternativeRoute)object).setMaxWeightFactor(algorithmOptions.getHints().getDouble("alternative_route.max_weight_factor", 1.4));
                ((AlternativeRoute)object).setMaxShareFactor(algorithmOptions.getHints().getDouble("alternative_route.max_share_factor", 0.6));
                ((AlternativeRoute)object).setMinPlateauFactor(algorithmOptions.getHints().getDouble("alternative_route.min_plateau_factor", 0.2));
                ((AlternativeRoute)object).setMaxExplorationFactor(algorithmOptions.getHints().getDouble("alternative_route.max_exploration_factor", 1.0));
            }
            object.setMaxVisitedNodes(algorithmOptions.getMaxVisitedNodes());
            return object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Algorithm ");
        ((StringBuilder)object).append((String)object2);
        ((StringBuilder)object).append(" not found in ");
        ((StringBuilder)object).append(this.getClass().getName());
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }
}

