/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.RoutingAlgorithmFactoryDecorator;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.util.CmdArgs;
import com.graphhopper.util.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHAlgoFactoryDecorator
implements RoutingAlgorithmFactoryDecorator {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private boolean disablingAllowed = false;
    private boolean enabled = true;
    private int preparationContractedNodes = -1;
    private int preparationLazyUpdates = -1;
    private double preparationLogMessages = -1.0;
    private int preparationNeighborUpdates = -1;
    private int preparationPeriodicUpdates = -1;
    private int preparationThreads;
    private final List<PrepareContractionHierarchies> preparations = new ArrayList<PrepareContractionHierarchies>();
    private ExecutorService threadPool;
    private final List<Weighting> weightings = new ArrayList<Weighting>();
    private final Set<String> weightingsAsStrings = new LinkedHashSet<String>();

    public CHAlgoFactoryDecorator() {
        this.setPreparationThreads(1);
        this.setWeightingsAsStrings(Arrays.asList(this.getDefaultWeighting()));
    }

    private String getDefaultWeighting() {
        String string2 = this.weightingsAsStrings.isEmpty() ? "fastest" : this.weightingsAsStrings.iterator().next();
        return string2;
    }

    public CHAlgoFactoryDecorator addPreparation(PrepareContractionHierarchies object) {
        this.preparations.add((PrepareContractionHierarchies)object);
        int n = this.preparations.size() - 1;
        if (n < this.weightings.size()) {
            if (this.preparations.get(n).getWeighting() == this.weightings.get(n)) {
                return this;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Weighting of PrepareContractionHierarchies ");
            ((StringBuilder)object).append(this.preparations.get(n).getWeighting());
            ((StringBuilder)object).append(" needs to be identical to previously added ");
            ((StringBuilder)object).append(this.weightings.get(n));
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot access weighting for PrepareContractionHierarchies with ");
        stringBuilder.append(((PrepareContractionHierarchies)object).getWeighting());
        stringBuilder.append(". Call add(Weighting) before");
        throw new IllegalStateException(stringBuilder.toString());
    }

    public CHAlgoFactoryDecorator addWeighting(Weighting weighting) {
        this.weightings.add(weighting);
        return this;
    }

    public CHAlgoFactoryDecorator addWeighting(String string2) {
        this.weightingsAsStrings.add(string2);
        return this;
    }

    public void createPreparations(GraphHopperStorage graphHopperStorage, TraversalMode object) {
        if (this.isEnabled() && this.preparations.isEmpty()) {
            if (!this.weightings.isEmpty()) {
                TraversalMode traversalMode = this.getNodeBase();
                for (Weighting weighting : this.getWeightings()) {
                    PrepareContractionHierarchies object2 = new PrepareContractionHierarchies(new GHDirectory("", DAType.RAM_INT), graphHopperStorage, graphHopperStorage.getGraph(CHGraph.class, weighting), weighting, traversalMode);
                    object2.setPeriodicUpdates(this.preparationPeriodicUpdates).setLazyUpdates(this.preparationLazyUpdates).setNeighborUpdates(this.preparationNeighborUpdates).setLogMessages(this.preparationLogMessages);
                    this.addPreparation(object2);
                }
                return;
            }
            throw new IllegalStateException("No CH weightings found");
        }
    }

    @Override
    public RoutingAlgorithmFactory getDecoratedAlgorithmFactory(RoutingAlgorithmFactory object, HintsMap hintsMap) {
        boolean bl = hintsMap.getBool("ch.disable", false);
        if (!(!this.isEnabled() || this.disablingAllowed && bl)) {
            if (!this.preparations.isEmpty()) {
                if (hintsMap.getWeighting().isEmpty()) {
                    hintsMap.setWeighting(this.getDefaultWeighting());
                }
                Object object2 = this.preparations.iterator();
                object = "";
                while (object2.hasNext()) {
                    PrepareContractionHierarchies prepareContractionHierarchies = object2.next();
                    if (prepareContractionHierarchies.getWeighting().matches(hintsMap)) {
                        return prepareContractionHierarchies;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append((String)object);
                    stringBuilder.append(prepareContractionHierarchies.getWeighting());
                    stringBuilder.append(", ");
                    object = stringBuilder.toString();
                }
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Cannot find CH RoutingAlgorithmFactory for weighting map ");
                ((StringBuilder)object2).append(hintsMap);
                ((StringBuilder)object2).append(" in entries ");
                ((StringBuilder)object2).append((String)object);
                throw new IllegalArgumentException(((StringBuilder)object2).toString());
            }
            throw new IllegalStateException("No preparations added to this decorator");
        }
        return object;
    }

    public TraversalMode getNodeBase() {
        return TraversalMode.NODE_BASED;
    }

    public int getPreparationContractedNodes() {
        return this.preparationContractedNodes;
    }

    public int getPreparationLazyUpdates() {
        return this.preparationLazyUpdates;
    }

    public double getPreparationLogMessages() {
        return this.preparationLogMessages;
    }

    public int getPreparationNeighborUpdates() {
        return this.preparationNeighborUpdates;
    }

    public int getPreparationPeriodicUpdates() {
        return this.preparationPeriodicUpdates;
    }

    public int getPreparationThreads() {
        return this.preparationThreads;
    }

    public List<PrepareContractionHierarchies> getPreparations() {
        return this.preparations;
    }

    public final List<Weighting> getWeightings() {
        return this.weightings;
    }

    public List<String> getWeightingsAsStrings() {
        if (!this.weightingsAsStrings.isEmpty()) {
            return new ArrayList<String>(this.weightingsAsStrings);
        }
        throw new IllegalStateException("Potential bug: weightingsAsStrings is empty");
    }

    public final boolean hasWeightings() {
        return this.weightings.isEmpty() ^ true;
    }

    @Override
    public void init(CmdArgs cmdArgs) {
        if (cmdArgs.get("prepare.threads", "").isEmpty()) {
            if (cmdArgs.get("prepare.chWeighting", "").isEmpty() && cmdArgs.get("prepare.chWeightings", "").isEmpty()) {
                this.setPreparationThreads(cmdArgs.getInt("prepare.ch.threads", this.getPreparationThreads()));
                String string2 = cmdArgs.get("prepare.ch.weightings", "");
                if (!"no".equals(string2) && !"false".equals(string2)) {
                    if (!string2.isEmpty()) {
                        this.setWeightingsAsStrings(Arrays.asList(string2.split(",")));
                    }
                } else {
                    this.weightingsAsStrings.clear();
                }
                boolean bl = this.weightingsAsStrings.isEmpty() ^ true;
                this.setEnabled(bl);
                if (bl) {
                    this.setDisablingAllowed(cmdArgs.getBool("routing.ch.disabling_allowed", this.isDisablingAllowed()));
                }
                this.setPreparationPeriodicUpdates(cmdArgs.getInt("prepare.ch.updates.periodic", this.getPreparationPeriodicUpdates()));
                this.setPreparationLazyUpdates(cmdArgs.getInt("prepare.ch.updates.lazy", this.getPreparationLazyUpdates()));
                this.setPreparationNeighborUpdates(cmdArgs.getInt("prepare.ch.updates.neighbor", this.getPreparationNeighborUpdates()));
                this.setPreparationContractedNodes(cmdArgs.getInt("prepare.ch.contracted_nodes", this.getPreparationContractedNodes()));
                this.setPreparationLogMessages(cmdArgs.getDouble("prepare.ch.log_messages", this.getPreparationLogMessages()));
                return;
            }
            throw new IllegalStateException("Use prepare.ch.weightings and a comma separated list instead of prepare.chWeighting or prepare.chWeightings");
        }
        throw new IllegalStateException("Use prepare.ch.threads instead of prepare.threads");
    }

    public final boolean isDisablingAllowed() {
        boolean bl = this.disablingAllowed || !this.isEnabled();
        return bl;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepare(StorableProperties storableProperties) {
        ExecutorCompletionService<Logger> executorCompletionService = new ExecutorCompletionService<Logger>(this.threadPool);
        Iterator<PrepareContractionHierarchies> iterator2 = this.getPreparations().iterator();
        int n = 0;
        int n2 = 0;
        while (iterator2.hasNext()) {
            PrepareContractionHierarchies prepareContractionHierarchies = iterator2.next();
            Object object = this.LOGGER;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(++n2);
            stringBuilder.append("/");
            stringBuilder.append(this.getPreparations().size());
            stringBuilder.append(" calling CH prepare.doWork for ");
            stringBuilder.append(prepareContractionHierarchies.getWeighting());
            stringBuilder.append(" ... (");
            stringBuilder.append(Helper.getMemInfo());
            stringBuilder.append(")");
            object.info(stringBuilder.toString());
            object = AbstractWeighting.weightingToFileName(prepareContractionHierarchies.getWeighting());
            executorCompletionService.submit(new Runnable((String)object, prepareContractionHierarchies, storableProperties){
                final /* synthetic */ String val$name;
                final /* synthetic */ PrepareContractionHierarchies val$prepare;
                final /* synthetic */ StorableProperties val$properties;
                {
                    this.val$name = string2;
                    this.val$prepare = prepareContractionHierarchies;
                    this.val$properties = storableProperties;
                }

                @Override
                public void run() {
                    Thread.currentThread().setName(this.val$name);
                    this.val$prepare.doWork();
                    StorableProperties storableProperties = this.val$properties;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("prepare.ch.date.");
                    stringBuilder.append(this.val$name);
                    storableProperties.put(stringBuilder.toString(), Helper.createFormatter().format(new Date()));
                }
            }, (Logger)object);
        }
        this.threadPool.shutdown();
        n2 = n;
        try {
            while (true) {
                if (n2 >= this.getPreparations().size()) {
                    return;
                }
                executorCompletionService.take().get();
                ++n2;
            }
        }
        catch (Exception exception) {
            this.threadPool.shutdownNow();
            throw new RuntimeException(exception);
        }
    }

    public final CHAlgoFactoryDecorator setDisablingAllowed(boolean bl) {
        this.disablingAllowed = bl;
        return this;
    }

    public final CHAlgoFactoryDecorator setEnabled(boolean bl) {
        this.enabled = bl;
        return this;
    }

    public CHAlgoFactoryDecorator setPreparationContractedNodes(int n) {
        this.preparationContractedNodes = n;
        return this;
    }

    public CHAlgoFactoryDecorator setPreparationLazyUpdates(int n) {
        this.preparationLazyUpdates = n;
        return this;
    }

    public CHAlgoFactoryDecorator setPreparationLogMessages(double d) {
        this.preparationLogMessages = d;
        return this;
    }

    public CHAlgoFactoryDecorator setPreparationNeighborUpdates(int n) {
        this.preparationNeighborUpdates = n;
        return this;
    }

    public CHAlgoFactoryDecorator setPreparationPeriodicUpdates(int n) {
        this.preparationPeriodicUpdates = n;
        return this;
    }

    public void setPreparationThreads(int n) {
        this.preparationThreads = n;
        this.threadPool = Executors.newFixedThreadPool(n);
    }

    public CHAlgoFactoryDecorator setWeightingsAsStrings(List<String> object) {
        if (!object.isEmpty()) {
            this.weightingsAsStrings.clear();
            object = object.iterator();
            while (object.hasNext()) {
                this.addWeighting(Helper.toLowerCase((String)object.next()).trim());
            }
            return this;
        }
        throw new IllegalArgumentException("It is not allowed to pass an emtpy weightingList");
    }

    public CHAlgoFactoryDecorator setWeightingsAsStrings(String ... stringArray) {
        return this.setWeightingsAsStrings(Arrays.asList(stringArray));
    }
}

