/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.DijkstraOneToMany;
import com.graphhopper.routing.ch.AbstractNodeContractor;
import com.graphhopper.routing.ch.PreparationWeighting;
import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.IgnoreNodeFilter;
import com.graphhopper.routing.util.LevelEdgeFilter;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.CHEdgeExplorer;
import com.graphhopper.util.CHEdgeIterator;
import com.graphhopper.util.CHEdgeIteratorState;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class NodeBasedNodeContractor
extends AbstractNodeContractor {
    private final AddShortcutHandler addScHandler;
    private int addedShortcutsCount;
    private final CalcShortcutHandler calcScHandler;
    private long dijkstraCount;
    private StopWatch dijkstraSW;
    private IgnoreNodeFilter ignoreNodeFilter;
    private double meanDegree;
    private DijkstraOneToMany prepareAlgo;
    private final PreparationWeighting prepareWeighting;
    private CHEdgeExplorer remainingEdgeExplorer;
    private final Map<Shortcut, Shortcut> shortcuts = new HashMap<Shortcut, Shortcut>();

    NodeBasedNodeContractor(Directory directory, GraphHopperStorage graphHopperStorage, CHGraph cHGraph, Weighting weighting) {
        super(directory, graphHopperStorage, cHGraph, weighting);
        this.addScHandler = new AddShortcutHandler();
        this.calcScHandler = new CalcShortcutHandler();
        this.dijkstraSW = new StopWatch();
        this.prepareWeighting = new PreparationWeighting(weighting);
    }

    private int addShortcuts(Collection<Shortcut> object) {
        Object object2 = object.iterator();
        int n = 0;
        block0: while (object2.hasNext()) {
            int n2;
            CHEdgeIteratorState cHEdgeIteratorState;
            block4: {
                object = object2.next();
                cHEdgeIteratorState = this.outEdgeExplorer.setBaseNode(((Shortcut)object).from);
                while (cHEdgeIteratorState.next()) {
                    if (!cHEdgeIteratorState.isShortcut() || cHEdgeIteratorState.getAdjNode() != ((Shortcut)object).to || (n2 = cHEdgeIteratorState.getMergeStatus(((Shortcut)object).flags)) == 0) continue;
                    if (((Shortcut)object).weight >= this.prepareWeighting.calcWeight(cHEdgeIteratorState, false, -1)) {
                        if (n2 != 2) continue block0;
                        break;
                    }
                    if (cHEdgeIteratorState.getEdge() != ((Shortcut)object).skippedEdge1 && cHEdgeIteratorState.getEdge() != ((Shortcut)object).skippedEdge2) {
                        cHEdgeIteratorState.setFlags(((Shortcut)object).flags);
                        cHEdgeIteratorState.setWeight(((Shortcut)object).weight);
                        cHEdgeIteratorState.setDistance(((Shortcut)object).dist);
                        cHEdgeIteratorState.setSkippedEdges(((Shortcut)object).skippedEdge1, ((Shortcut)object).skippedEdge2);
                        this.setOrigEdgeCount(cHEdgeIteratorState.getEdge(), ((Shortcut)object).originalEdges);
                        n2 = 1;
                        break block4;
                    }
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Shortcut cannot update itself! ");
                    ((StringBuilder)object2).append(cHEdgeIteratorState.getEdge());
                    ((StringBuilder)object2).append(", skipEdge1:");
                    ((StringBuilder)object2).append(((Shortcut)object).skippedEdge1);
                    ((StringBuilder)object2).append(", skipEdge2:");
                    ((StringBuilder)object2).append(((Shortcut)object).skippedEdge2);
                    ((StringBuilder)object2).append(", edge ");
                    ((StringBuilder)object2).append(cHEdgeIteratorState);
                    ((StringBuilder)object2).append(":");
                    ((StringBuilder)object2).append(this.getCoords(cHEdgeIteratorState, this.prepareGraph));
                    ((StringBuilder)object2).append(", sc:");
                    ((StringBuilder)object2).append(object);
                    ((StringBuilder)object2).append(", skippedEdge1: ");
                    ((StringBuilder)object2).append(this.getCoords(this.prepareGraph.getEdgeIteratorState(((Shortcut)object).skippedEdge1, ((Shortcut)object).from), this.prepareGraph));
                    ((StringBuilder)object2).append(", skippedEdge2: ");
                    ((StringBuilder)object2).append(this.getCoords(this.prepareGraph.getEdgeIteratorState(((Shortcut)object).skippedEdge2, ((Shortcut)object).to), this.prepareGraph));
                    ((StringBuilder)object2).append(", neighbors:");
                    ((StringBuilder)object2).append(GHUtility.getNeighbors((EdgeIterator)((Object)cHEdgeIteratorState)));
                    throw new IllegalStateException(((StringBuilder)object2).toString());
                }
                n2 = 0;
            }
            if (n2 != 0) continue;
            cHEdgeIteratorState = this.prepareGraph.shortcut(((Shortcut)object).from, ((Shortcut)object).to);
            cHEdgeIteratorState.setFlags(((Shortcut)object).flags);
            cHEdgeIteratorState.setWeight(((Shortcut)object).weight);
            cHEdgeIteratorState.setDistance(((Shortcut)object).dist);
            cHEdgeIteratorState.setSkippedEdges(((Shortcut)object).skippedEdge1, ((Shortcut)object).skippedEdge2);
            this.setOrigEdgeCount(cHEdgeIteratorState.getEdge(), ((Shortcut)object).originalEdges);
            ++n;
        }
        return n;
    }

    private CalcShortcutsResult calcShortcutCount(int n) {
        this.findShortcuts(this.calcScHandler.setNode(n));
        return this.calcScHandler.calcShortcutsResult;
    }

    private long findShortcuts(ShortcutHandler object) {
        int n = this.getMaxVisitedNodesEstimate();
        CHEdgeIterator cHEdgeIterator = this.inEdgeExplorer.setBaseNode(object.getNode());
        long l = 0L;
        block0: while (cHEdgeIterator.next()) {
            int n2 = cHEdgeIterator.getAdjNode();
            if (this.isContracted(n2)) continue;
            double d = cHEdgeIterator.getDistance();
            double d2 = this.prepareWeighting.calcWeight(cHEdgeIterator, true, -1);
            int n3 = cHEdgeIterator.getEdge();
            int n4 = this.getOrigEdgeCount(n3);
            CHEdgeIterator cHEdgeIterator2 = this.outEdgeExplorer.setBaseNode(object.getNode());
            this.prepareAlgo.clear();
            long l2 = l + 1L;
            int n5 = n;
            while (true) {
                n = n5;
                l = l2;
                if (!cHEdgeIterator2.next()) continue block0;
                int n6 = cHEdgeIterator2.getAdjNode();
                if (this.isContracted(n6) || n2 == n6) continue;
                double d3 = d2 + this.prepareWeighting.calcWeight(cHEdgeIterator2, false, cHEdgeIterator.getEdge());
                if (Double.isNaN(d3)) break;
                if (Double.isInfinite(d3)) continue;
                double d4 = cHEdgeIterator2.getDistance();
                this.prepareAlgo.setWeightLimit(d3);
                this.prepareAlgo.setMaxVisitedNodes(n5);
                this.prepareAlgo.setEdgeFilter(this.ignoreNodeFilter.setAvoidNode(object.getNode()));
                this.dijkstraSW.start();
                ++this.dijkstraCount;
                n = this.prepareAlgo.findEndNode(n2, n6);
                this.dijkstraSW.stop();
                if (n == n6 && this.prepareAlgo.getWeight(n) <= d3) continue;
                object.foundShortcut(n2, n6, d3, d + d4, cHEdgeIterator2.getEdge(), this.getOrigEdgeCount(cHEdgeIterator2.getEdge()), n3, n4);
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Weighting should never return NaN values, in:");
            ((StringBuilder)object).append(this.getCoords(cHEdgeIterator, this.prepareGraph));
            ((StringBuilder)object).append(", out:");
            ((StringBuilder)object).append(this.getCoords(cHEdgeIterator2, this.prepareGraph));
            ((StringBuilder)object).append(", dist:");
            ((StringBuilder)object).append(cHEdgeIterator2.getDistance());
            throw new IllegalStateException(((StringBuilder)object).toString());
        }
        return l;
    }

    private String getCoords(EdgeIteratorState edgeIteratorState, Graph object) {
        object = object.getNodeAccess();
        int n = edgeIteratorState.getBaseNode();
        int n2 = edgeIteratorState.getAdjNode();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.append("->");
        stringBuilder.append(n2);
        stringBuilder.append(" (");
        stringBuilder.append(edgeIteratorState.getEdge());
        stringBuilder.append("); ");
        stringBuilder.append(object.getLat(n));
        stringBuilder.append(",");
        stringBuilder.append(object.getLon(n));
        stringBuilder.append(" -> ");
        stringBuilder.append(object.getLat(n2));
        stringBuilder.append(",");
        stringBuilder.append(object.getLon(n2));
        return stringBuilder.toString();
    }

    private int getMaxVisitedNodesEstimate() {
        return (int)this.meanDegree * 100;
    }

    @Override
    public float calculatePriority(int n) {
        CalcShortcutsResult calcShortcutsResult = this.calcShortcutCount(n);
        int n2 = calcShortcutsResult.originalEdgesCount;
        CHEdgeIterator cHEdgeIterator = this.remainingEdgeExplorer.setBaseNode(n);
        n = 0;
        int n3 = 0;
        while (cHEdgeIterator.next()) {
            int n4;
            n = n4 = n + 1;
            if (!cHEdgeIterator.isShortcut()) continue;
            ++n3;
            n = n4;
        }
        return (calcShortcutsResult.shortcutsCount - n) * 10 + n2 + n3;
    }

    @Override
    public void close() {
        super.close();
        this.prepareAlgo.close();
    }

    @Override
    public void contractNode(int n) {
        this.shortcuts.clear();
        long l = this.findShortcuts(this.addScHandler.setNode(n));
        this.addedShortcutsCount += this.addShortcuts(this.shortcuts.keySet());
        this.meanDegree = (this.meanDegree * 2.0 + (double)l) / 3.0;
    }

    @Override
    public long getAddedShortcutsCount() {
        return this.addedShortcutsCount;
    }

    @Override
    public long getDijkstraCount() {
        return this.dijkstraCount;
    }

    @Override
    public float getDijkstraSeconds() {
        return this.dijkstraSW.getCurrentSeconds();
    }

    @Override
    public String getStatisticsString() {
        return String.format(Locale.ROOT, "meanDegree: %.2f, dijkstras: %10s, mem: %10s", this.meanDegree, Helper.nf(this.dijkstraCount), this.prepareAlgo.getMemoryUsageAsString());
    }

    @Override
    public void initFromGraph() {
        super.initFromGraph();
        this.ignoreNodeFilter = new IgnoreNodeFilter(this.prepareGraph, this.maxLevel);
        final EdgeFilter edgeFilter = DefaultEdgeFilter.allEdges(this.encoder);
        edgeFilter = new LevelEdgeFilter(this.prepareGraph){

            @Override
            public final boolean accept(EdgeIteratorState edgeIteratorState) {
                boolean bl = super.accept(edgeIteratorState) && edgeFilter.accept(edgeIteratorState);
                return bl;
            }
        };
        this.remainingEdgeExplorer = this.prepareGraph.createEdgeExplorer(edgeFilter);
        this.prepareAlgo = new DijkstraOneToMany(this.prepareGraph, this.prepareWeighting, TraversalMode.NODE_BASED);
    }

    @Override
    public void prepareContraction() {
        this.meanDegree = this.prepareGraph.getAllEdges().length() / this.prepareGraph.getNodes();
    }

    private class AddShortcutHandler
    implements ShortcutHandler {
        int node;

        private AddShortcutHandler() {
        }

        @Override
        public void foundShortcut(int n, int n2, double d, double d2, int n3, int n4, int n5, int n6) {
            Shortcut shortcut = new Shortcut(n, n2, d, d2);
            if (NodeBasedNodeContractor.this.shortcuts.containsKey(shortcut)) {
                return;
            }
            Shortcut shortcut2 = new Shortcut(n2, n, d, d2);
            shortcut2 = (Shortcut)NodeBasedNodeContractor.this.shortcuts.get(shortcut2);
            if (shortcut2 != null && shortcut2.skippedEdge2 == n5 && shortcut2.skippedEdge1 == n3) {
                shortcut2.flags = PrepareEncoder.getScDirMask();
                return;
            }
            shortcut2 = NodeBasedNodeContractor.this.shortcuts.put(shortcut, shortcut);
            if (shortcut2 == null) {
                shortcut.skippedEdge1 = n5;
                shortcut.skippedEdge2 = n3;
                shortcut.originalEdges = n6 + n4;
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Shortcut did not exist (");
            stringBuilder.append(shortcut);
            stringBuilder.append(") but was overwriting another one? ");
            stringBuilder.append(shortcut2);
            throw new IllegalStateException(stringBuilder.toString());
        }

        @Override
        public int getNode() {
            return this.node;
        }

        public AddShortcutHandler setNode(int n) {
            NodeBasedNodeContractor.this.shortcuts.clear();
            this.node = n;
            return this;
        }
    }

    private class CalcShortcutHandler
    implements ShortcutHandler {
        CalcShortcutsResult calcShortcutsResult = new CalcShortcutsResult();
        int node;

        private CalcShortcutHandler() {
        }

        @Override
        public void foundShortcut(int n, int n2, double d, double d2, int n3, int n4, int n5, int n6) {
            CalcShortcutsResult calcShortcutsResult = this.calcShortcutsResult;
            ++calcShortcutsResult.shortcutsCount;
            calcShortcutsResult = this.calcShortcutsResult;
            calcShortcutsResult.originalEdgesCount += n6 + n4;
        }

        @Override
        public int getNode() {
            return this.node;
        }

        public CalcShortcutHandler setNode(int n) {
            this.node = n;
            this.calcShortcutsResult.originalEdgesCount = 0;
            this.calcShortcutsResult.shortcutsCount = 0;
            return this;
        }
    }

    private static class CalcShortcutsResult {
        int originalEdgesCount;
        int shortcutsCount;

        private CalcShortcutsResult() {
        }
    }

    private static class Shortcut {
        double dist;
        long flags = PrepareEncoder.getScFwdDir();
        int from;
        int originalEdges;
        int skippedEdge1;
        int skippedEdge2;
        int to;
        double weight;

        public Shortcut(int n, int n2, double d, double d2) {
            this.from = n;
            this.to = n2;
            this.weight = d;
            this.dist = d2;
        }

        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = bl = false;
            if (object != null) {
                if (this.getClass() != object.getClass()) {
                    bl2 = bl;
                } else {
                    object = (Shortcut)object;
                    bl2 = bl;
                    if (this.from == ((Shortcut)object).from) {
                        bl2 = bl;
                        if (this.to == ((Shortcut)object).to) {
                            bl2 = bl;
                            if (Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(((Shortcut)object).weight)) {
                                bl2 = true;
                            }
                        }
                    }
                }
            }
            return bl2;
        }

        public int hashCode() {
            return ((115 + this.from) * 23 + this.to) * 23 + (int)(Double.doubleToLongBits(this.weight) ^ Double.doubleToLongBits(this.weight) >>> 32);
        }

        public String toString() {
            CharSequence charSequence;
            if (this.flags == PrepareEncoder.getScDirMask()) {
                charSequence = new StringBuilder();
                charSequence.append(this.from);
                charSequence.append("<->");
                charSequence = charSequence.toString();
            } else {
                charSequence = new StringBuilder();
                charSequence.append(this.from);
                charSequence.append("->");
                charSequence = charSequence.toString();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence);
            stringBuilder.append(this.to);
            stringBuilder.append(", weight:");
            stringBuilder.append(this.weight);
            stringBuilder.append(" (");
            stringBuilder.append(this.skippedEdge1);
            stringBuilder.append(",");
            stringBuilder.append(this.skippedEdge2);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static interface ShortcutHandler {
        public void foundShortcut(int var1, int var2, double var3, double var5, int var7, int var8, int var9, int var10);

        public int getNode();
    }
}

