/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.coll.GHTreeMapComposed;
import com.graphhopper.routing.AStarBidirectionCH;
import com.graphhopper.routing.AbstractBidirAlgo;
import com.graphhopper.routing.AbstractRoutingAlgorithm;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.DijkstraBidirectionCH;
import com.graphhopper.routing.DijkstraBidirectionCHNoSOD;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.RoutingAlgorithmFactorySimple;
import com.graphhopper.routing.ch.NodeBasedNodeContractor;
import com.graphhopper.routing.ch.NodeContractor;
import com.graphhopper.routing.ch.PreparationWeighting;
import com.graphhopper.routing.util.AbstractAlgoPreparation;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.LevelEdgeFilter;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.CHGraphImpl;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.CHEdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import java.util.Locale;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareContractionHierarchies
extends AbstractAlgoPreparation
implements RoutingAlgorithmFactory {
    private final StopWatch allSW;
    private int checkCounter;
    private final StopWatch contractionSW;
    private final Directory dir;
    private final GraphHopperStorage ghStorage;
    private int initSize;
    private int lastNodesLazyUpdatePercentage = 10;
    private final StopWatch lazyUpdateSW;
    private double logMessagesPercentage = 20.0;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int maxLevel;
    private int neighborUpdatePercentage = 20;
    private final StopWatch neighborUpdateSW;
    private NodeContractor nodeContractor;
    private double nodesContractedPercentage = 100.0;
    private float[] oldPriorities;
    private final StopWatch periodicUpdateSW;
    private int periodicUpdatesPercentage = 20;
    private final CHGraphImpl prepareGraph;
    private final PreparationWeighting prepareWeighting;
    private final Random rand = new Random(123L);
    private GHTreeMapComposed sortedNodes;
    private final TraversalMode traversalMode;
    private CHEdgeExplorer vehicleAllExplorer;
    private CHEdgeExplorer vehicleAllTmpExplorer;
    private final Weighting weighting;

    public PrepareContractionHierarchies(Directory directory, GraphHopperStorage graphHopperStorage, CHGraph cHGraph, Weighting weighting, TraversalMode traversalMode) {
        this.allSW = new StopWatch();
        this.periodicUpdateSW = new StopWatch();
        this.lazyUpdateSW = new StopWatch();
        this.neighborUpdateSW = new StopWatch();
        this.contractionSW = new StopWatch();
        this.dir = directory;
        this.ghStorage = graphHopperStorage;
        this.prepareGraph = (CHGraphImpl)cHGraph;
        this.traversalMode = traversalMode;
        this.weighting = weighting;
        this.prepareWeighting = new PreparationWeighting(weighting);
    }

    private float calculatePriority(int n) {
        return this.nodeContractor.calculatePriority(n);
    }

    private void close() {
        this.nodeContractor.close();
        this.sortedNodes = null;
        this.oldPriorities = null;
    }

    /*
     * Unable to fully structure code
     */
    private void contractNodes() {
        block15: {
            block16: {
                this.nodeContractor.prepareContraction();
                this.initSize = var1_1 = this.sortedNodes.getSize();
                this.checkCounter = 0;
                var2_2 = Math.round(Math.max(10.0, (double)var1_1 / 100.0 * this.logMessagesPercentage));
                if (this.logMessagesPercentage == 0.0) {
                    var2_2 = 0x7FFFFFFFL;
                }
                var4_3 = Math.round(Math.max(10.0, (double)this.sortedNodes.getSize() / 100.0 * (double)this.periodicUpdatesPercentage));
                var6_4 = this.periodicUpdatesPercentage != 0;
                var7_5 = Math.round((double)this.sortedNodes.getSize() / 100.0 * (double)this.lastNodesLazyUpdatePercentage);
                var9_6 = Math.round((100.0 - this.nodesContractedPercentage) / 100.0 * (double)this.sortedNodes.getSize());
                if (this.neighborUpdatePercentage == 0) {
                    var1_1 = 0;
                    var11_7 = 0;
                    var12_8 = false;
                } else {
                    var1_1 = 0;
                    var11_7 = 0;
                    var12_8 = true;
                }
                block0: while (true) {
                    var13_9 = var1_1;
                    if (this.sortedNodes.isEmpty()) break block15;
                    if (var6_4 && (var14_10 = this.checkCounter) > 0) {
                        var13_9 = var1_1;
                        if ((long)var14_10 % var4_3 == 0L) {
                            this.periodicUpdateSW.start();
                            this.sortedNodes.clear();
                            for (var13_9 = 0; var13_9 < this.prepareGraph.getNodes(); ++var13_9) {
                                if (this.prepareGraph.getLevel(var13_9) != this.maxLevel) continue;
                                var15_11 = this.oldPriorities;
                                var15_11[var13_9] = var16_12 = this.calculatePriority(var13_9);
                                this.sortedNodes.insert(var13_9, var16_12);
                            }
                            this.periodicUpdateSW.stop();
                            var13_9 = var1_1 + 1;
                            if (this.sortedNodes.isEmpty()) {
                                throw new IllegalStateException("Cannot prepare as no unprepared nodes where found. Called preparation twice?");
                            }
                        }
                    } else {
                        var13_9 = var1_1;
                    }
                    if ((long)this.checkCounter % var2_2 == 0L) {
                        this.logStats(var13_9);
                    }
                    ++this.checkCounter;
                    var14_10 = this.sortedNodes.pollKey();
                    if (this.sortedNodes.isEmpty() || (long)this.sortedNodes.getSize() >= var7_5) break block16;
                    this.lazyUpdateSW.start();
                    var15_11 = this.oldPriorities;
                    var15_11[var14_10] = var16_12 = this.calculatePriority(var14_10);
                    if (!(var16_12 > this.sortedNodes.peekValue())) break;
                    this.sortedNodes.insert(var14_10, var16_12);
                    this.lazyUpdateSW.stop();
                    while (true) {
                        var1_1 = var13_9;
                        continue block0;
                        break;
                    }
                    break;
                }
                this.lazyUpdateSW.stop();
            }
            this.contractionSW.start();
            this.nodeContractor.contractNode(var14_10);
            this.prepareGraph.setLevel(var14_10, var11_7);
            var1_1 = var11_7 + 1;
            this.contractionSW.stop();
            if ((long)this.sortedNodes.getSize() >= var9_6) {
                var15_11 = this.vehicleAllExplorer.setBaseNode(var14_10);
                while (true) {
                    var11_7 = var1_1;
                    if (!var15_11.next()) ** continue;
                    if (Thread.currentThread().isInterrupted()) break;
                    var11_7 = var15_11.getAdjNode();
                    if (this.prepareGraph.getLevel(var11_7) != this.maxLevel) continue;
                    if (var12_8 && this.rand.nextInt(100) < this.neighborUpdatePercentage) {
                        this.neighborUpdateSW.start();
                        var17_13 = this.oldPriorities;
                        var18_14 = var17_13[var11_7];
                        var17_13[var11_7] = var16_12 = this.calculatePriority(var11_7);
                        if (var16_12 != var18_14) {
                            this.sortedNodes.update(var11_7, var18_14, var16_12);
                        }
                        this.neighborUpdateSW.stop();
                    }
                    this.prepareGraph.disconnect(this.vehicleAllTmpExplorer, (EdgeIteratorState)var15_11);
                }
                throw new RuntimeException("Thread was interrupted");
            }
        }
        this.logStats(var13_9);
        this.close();
    }

    private AbstractBidirAlgo doCreateAlgo(Graph object, AlgorithmOptions algorithmOptions) {
        if ("astarbi".equals(algorithmOptions.getAlgorithm())) {
            return new AStarBidirectionCH((Graph)object, this.prepareWeighting, this.traversalMode).setApproximation(RoutingAlgorithmFactorySimple.getApproximation("astarbi", algorithmOptions, object.getNodeAccess()));
        }
        if ("dijkstrabi".equals(algorithmOptions.getAlgorithm())) {
            if (algorithmOptions.getHints().getBool("stall_on_demand", true)) {
                return new DijkstraBidirectionCH((Graph)object, this.prepareWeighting, this.traversalMode);
            }
            return new DijkstraBidirectionCHNoSOD((Graph)object, this.prepareWeighting, this.traversalMode);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Algorithm ");
        ((StringBuilder)object).append(algorithmOptions.getAlgorithm());
        ((StringBuilder)object).append(" not supported for Contraction Hierarchies. Try with ch.disable=true");
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    private String getTimesAsString() {
        float f = this.allSW.getCurrentSeconds();
        float f2 = this.periodicUpdateSW.getCurrentSeconds();
        float f3 = this.lazyUpdateSW.getCurrentSeconds();
        float f4 = this.neighborUpdateSW.getCurrentSeconds();
        float f5 = this.contractionSW.getCurrentSeconds();
        float f6 = this.nodeContractor.getDijkstraSeconds();
        return String.format(Locale.ROOT, "t(total): %6.2f,  t(period): %6.2f, t(lazy): %6.2f, t(neighbor): %6.2f, t(contr): %6.2f, t(other) : %6.2f, t(dijk): %6.2f", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f - (f2 + f3 + f4 + f5)), Float.valueOf(f6));
    }

    private void initFromGraph() {
        this.ghStorage.freeze();
        Object object = DefaultEdgeFilter.allEdges(this.prepareWeighting.getFlagEncoder());
        this.maxLevel = this.prepareGraph.getNodes();
        this.vehicleAllExplorer = this.prepareGraph.createEdgeExplorer((EdgeFilter)object);
        this.vehicleAllTmpExplorer = this.prepareGraph.createEdgeExplorer((EdgeFilter)object);
        this.sortedNodes = new GHTreeMapComposed();
        this.oldPriorities = new float[this.prepareGraph.getNodes()];
        this.nodeContractor = object = new NodeBasedNodeContractor(this.dir, this.ghStorage, this.prepareGraph, this.weighting);
        object.initFromGraph();
    }

    private void logStats(int n) {
        this.logger.info(String.format(Locale.ROOT, "nodes: %10s, shortcuts: %10s, updates: %2d, checked-nodes: %10s, %s, %s, %s", Helper.nf(this.sortedNodes.getSize()), Helper.nf(this.nodeContractor.getAddedShortcutsCount()), n, Helper.nf(this.checkCounter), this.getTimesAsString(), this.nodeContractor.getStatisticsString(), Helper.getMemInfo()));
    }

    private boolean prepareNodes() {
        int n;
        int n2 = this.prepareGraph.getNodes();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            this.prepareGraph.setLevel(n, this.maxLevel);
        }
        this.periodicUpdateSW.start();
        for (n = n3; n < n2; ++n) {
            float f;
            float[] fArray = this.oldPriorities;
            fArray[n] = f = this.calculatePriority(n);
            this.sortedNodes.insert(n, f);
        }
        this.periodicUpdateSW.stop();
        return this.sortedNodes.isEmpty() ^ true;
    }

    @Override
    public RoutingAlgorithm createAlgo(Graph object, AlgorithmOptions algorithmOptions) {
        object = this.doCreateAlgo((Graph)object, algorithmOptions);
        ((AbstractRoutingAlgorithm)object).setEdgeFilter(new LevelEdgeFilter(this.prepareGraph));
        ((AbstractRoutingAlgorithm)object).setMaxVisitedNodes(algorithmOptions.getMaxVisitedNodes());
        return object;
    }

    @Override
    public void doSpecificWork() {
        this.allSW.start();
        this.initFromGraph();
        this.runGraphContraction();
        Logger logger = this.logger;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("took:");
        stringBuilder.append((int)this.allSW.stop().getSeconds());
        stringBuilder.append("s , new shortcuts: ");
        stringBuilder.append(Helper.nf(this.nodeContractor.getAddedShortcutsCount()));
        stringBuilder.append(", initSize:");
        stringBuilder.append(Helper.nf(this.initSize));
        stringBuilder.append(", ");
        stringBuilder.append(this.prepareWeighting);
        stringBuilder.append(", periodic:");
        stringBuilder.append(this.periodicUpdatesPercentage);
        stringBuilder.append(", lazy:");
        stringBuilder.append(this.lastNodesLazyUpdatePercentage);
        stringBuilder.append(", neighbor:");
        stringBuilder.append(this.neighborUpdatePercentage);
        stringBuilder.append(", ");
        stringBuilder.append(this.getTimesAsString());
        stringBuilder.append(", lazy-overhead: ");
        stringBuilder.append((int)(((double)this.checkCounter / (double)this.initSize - 1.0) * 100.0));
        stringBuilder.append("%, ");
        stringBuilder.append(Helper.getMemInfo());
        logger.info(stringBuilder.toString());
        int n = this.ghStorage.getAllEdges().length();
        this.logger.info("graph now - num edges: {}, num nodes: {}, num shortcuts: {}", new Object[]{Helper.nf(n), Helper.nf(this.ghStorage.getNodes()), Helper.nf(this.prepareGraph.getAllEdges().length() - n)});
    }

    public long getDijkstraCount() {
        return this.nodeContractor.getDijkstraCount();
    }

    public double getLazyTime() {
        return this.lazyUpdateSW.getCurrentSeconds();
    }

    public double getNeighborTime() {
        return this.neighborUpdateSW.getCurrentSeconds();
    }

    public double getPeriodTime() {
        return this.periodicUpdateSW.getCurrentSeconds();
    }

    public long getShortcuts() {
        return this.nodeContractor.getAddedShortcutsCount();
    }

    public Weighting getWeighting() {
        return this.prepareGraph.getWeighting();
    }

    protected void runGraphContraction() {
        if (!this.prepareNodes()) {
            return;
        }
        this.contractNodes();
    }

    public PrepareContractionHierarchies setContractedNodes(double d) {
        if (d < 0.0) {
            return this;
        }
        if (!(d > 100.0)) {
            this.nodesContractedPercentage = d;
            return this;
        }
        throw new IllegalArgumentException("setNodesContracted can be 100% maximum");
    }

    public PrepareContractionHierarchies setLazyUpdates(int n) {
        if (n < 0) {
            return this;
        }
        if (n <= 100) {
            this.lastNodesLazyUpdatePercentage = n;
            return this;
        }
        throw new IllegalArgumentException("lazyUpdates has to be in [0, 100], to disable it use 0");
    }

    public PrepareContractionHierarchies setLogMessages(double d) {
        if (d >= 0.0) {
            this.logMessagesPercentage = d;
        }
        return this;
    }

    public PrepareContractionHierarchies setNeighborUpdates(int n) {
        if (n < 0) {
            return this;
        }
        if (n <= 100) {
            this.neighborUpdatePercentage = n;
            return this;
        }
        throw new IllegalArgumentException("neighborUpdates has to be in [0, 100], to disable it use 0");
    }

    public PrepareContractionHierarchies setPeriodicUpdates(int n) {
        if (n < 0) {
            return this;
        }
        if (n <= 100) {
            this.periodicUpdatesPercentage = n;
            return this;
        }
        throw new IllegalArgumentException("periodicUpdates has to be in [0, 100], to disable it use 0");
    }

    public String toString() {
        return "prepare|dijkstrabi|ch";
    }
}

