/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.RoutingAlgorithmFactoryDecorator;
import com.graphhopper.routing.lm.LandmarkSuggestion;
import com.graphhopper.routing.lm.PrepareLandmarks;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.CmdArgs;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LMAlgoFactoryDecorator
implements RoutingAlgorithmFactoryDecorator {
    private Logger LOGGER = LoggerFactory.getLogger(LMAlgoFactoryDecorator.class);
    private int activeLandmarkCount = 8;
    private boolean disablingAllowed = false;
    private boolean enabled = false;
    private int landmarkCount = 16;
    private final List<String> lmSuggestionsLocations;
    private boolean logDetails = false;
    private final Map<String, Double> maximumWeights;
    private int minNodes = -1;
    private int preparationThreads;
    private final List<PrepareLandmarks> preparations = new ArrayList<PrepareLandmarks>();
    private ExecutorService threadPool;
    private final List<Weighting> weightings;
    private final List<String> weightingsAsStrings = new ArrayList<String>();

    public LMAlgoFactoryDecorator() {
        this.weightings = new ArrayList<Weighting>();
        this.maximumWeights = new HashMap<String, Double>();
        this.lmSuggestionsLocations = new ArrayList<String>(5);
        this.setPreparationThreads(1);
    }

    public LMAlgoFactoryDecorator addPreparation(PrepareLandmarks object) {
        this.preparations.add((PrepareLandmarks)object);
        int n = this.preparations.size() - 1;
        if (n < this.weightings.size()) {
            if (this.preparations.get(n).getWeighting() == this.weightings.get(n)) {
                return this;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Weighting of PrepareContractionHierarchies ");
            ((StringBuilder)object).append(this.preparations.get(n).getWeighting());
            ((StringBuilder)object).append(" needs to be identical to previously added ");
            ((StringBuilder)object).append(this.weightings.get(n));
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot access weighting for PrepareLandmarks with ");
        stringBuilder.append(((PrepareLandmarks)object).getWeighting());
        stringBuilder.append(". Call add(Weighting) before");
        throw new IllegalStateException(stringBuilder.toString());
    }

    public LMAlgoFactoryDecorator addWeighting(Weighting weighting) {
        this.weightings.add(weighting);
        return this;
    }

    public LMAlgoFactoryDecorator addWeighting(String string2) {
        String[] stringArray = string2.split("\\|");
        int n = stringArray.length;
        double d = -1.0;
        if (n > 1) {
            d = new PMap(string2).getDouble("maximum", -1.0);
        }
        this.weightingsAsStrings.add(stringArray[0]);
        this.maximumWeights.put(stringArray[0], d);
        return this;
    }

    public void createPreparations(GraphHopperStorage object, LocationIndex object22) {
        if (this.isEnabled() && this.preparations.isEmpty()) {
            if (!this.weightings.isEmpty()) {
                ArrayList<LandmarkSuggestion> arrayList = new ArrayList<LandmarkSuggestion>(this.lmSuggestionsLocations.size());
                if (!this.lmSuggestionsLocations.isEmpty()) {
                    try {
                        Iterator<Object> iterator2 = this.lmSuggestionsLocations.iterator();
                        while (iterator2.hasNext()) {
                            arrayList.add(LandmarkSuggestion.readLandmarks((String)iterator2.next(), (LocationIndex)object22));
                        }
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                }
                for (Weighting weighting : this.getWeightings()) {
                    Double d = this.maximumWeights.get(weighting.getName());
                    if (d != null) {
                        PrepareLandmarks prepareLandmarks = new PrepareLandmarks(((GraphHopperStorage)object).getDirectory(), (GraphHopperStorage)object, weighting, this.landmarkCount, this.activeLandmarkCount).setLandmarkSuggestions(arrayList).setMaximumWeight(d).setLogDetails(this.logDetails);
                        int n = this.minNodes;
                        if (n > 1) {
                            prepareLandmarks.setMinimumNodes(n);
                        }
                        this.addPreparation(prepareLandmarks);
                        continue;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("maximumWeight cannot be null. Default should be just negative. Couldn't find ");
                    ((StringBuilder)object).append(weighting.getName());
                    ((StringBuilder)object).append(" in ");
                    ((StringBuilder)object).append(this.maximumWeights);
                    throw new IllegalStateException(((StringBuilder)object).toString());
                }
                return;
            }
            throw new IllegalStateException("No landmark weightings found");
        }
    }

    @Override
    public RoutingAlgorithmFactory getDecoratedAlgorithmFactory(RoutingAlgorithmFactory routingAlgorithmFactory, HintsMap hintsMap) {
        boolean bl = hintsMap.getBool("ch.disable", false);
        boolean bl2 = hintsMap.getBool("lm.disable", false);
        if (this.isEnabled() && (!this.disablingAllowed || !bl2) && bl) {
            if (!this.preparations.isEmpty()) {
                for (PrepareLandmarks prepareLandmarks : this.preparations) {
                    if (!prepareLandmarks.getWeighting().matches(hintsMap)) continue;
                    return new LMRAFactory(prepareLandmarks, routingAlgorithmFactory);
                }
                return routingAlgorithmFactory;
            }
            throw new IllegalStateException("No preparations added to this decorator");
        }
        return routingAlgorithmFactory;
    }

    public int getLandmarks() {
        return this.landmarkCount;
    }

    public int getPreparationThreads() {
        return this.preparationThreads;
    }

    public List<PrepareLandmarks> getPreparations() {
        return this.preparations;
    }

    public List<Weighting> getWeightings() {
        return this.weightings;
    }

    public List<String> getWeightingsAsStrings() {
        if (!this.weightingsAsStrings.isEmpty()) {
            return this.weightingsAsStrings;
        }
        throw new IllegalStateException("Potential bug: weightingsAsStrings is empty");
    }

    public boolean hasPreparations() {
        return this.preparations.isEmpty() ^ true;
    }

    public boolean hasWeightings() {
        return this.weightings.isEmpty() ^ true;
    }

    @Override
    public void init(CmdArgs cmdArgs) {
        int n;
        this.setPreparationThreads(cmdArgs.getInt("prepare.lm.threads", this.getPreparationThreads()));
        this.landmarkCount = n = cmdArgs.getInt("prepare.lm.landmarks", this.landmarkCount);
        this.activeLandmarkCount = cmdArgs.getInt("routing.lm.active_landmarks", Math.min(8, n));
        this.logDetails = cmdArgs.getBool("prepare.lm.log_details", false);
        this.minNodes = cmdArgs.getInt("prepare.lm.min_network_size", -1);
        for (String string2 : cmdArgs.get("prepare.lm.suggestions_location", "").split(",")) {
            if (string2.trim().isEmpty()) continue;
            this.lmSuggestionsLocations.add(string2.trim());
        }
        String string3 = cmdArgs.get("prepare.lm.weightings", "");
        if (!string3.isEmpty() && !string3.equalsIgnoreCase("no")) {
            this.setWeightingsAsStrings(Arrays.asList(string3.split(",")));
        }
        boolean bl = this.weightingsAsStrings.isEmpty() ^ true;
        this.setEnabled(bl);
        if (bl) {
            this.setDisablingAllowed(cmdArgs.getBool("routing.lm.disabling_allowed", this.isDisablingAllowed()));
        }
    }

    public final boolean isDisablingAllowed() {
        boolean bl = this.disablingAllowed || !this.isEnabled();
        return bl;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadOrDoWork(StorableProperties storableProperties) {
        ExecutorCompletionService<String> executorCompletionService = new ExecutorCompletionService<String>(this.threadPool);
        int n = 0;
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        Iterator<PrepareLandmarks> iterator2 = this.preparations.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            final PrepareLandmarks prepareLandmarks = iterator2.next();
            String string2 = AbstractWeighting.weightingToFileName(prepareLandmarks.getWeighting());
            executorCompletionService.submit(new Runnable(++n2, atomicBoolean, string2, storableProperties){
                final /* synthetic */ String val$name;
                final /* synthetic */ AtomicBoolean val$prepared;
                final /* synthetic */ StorableProperties val$properties;
                final /* synthetic */ int val$tmpCounter;
                {
                    this.val$tmpCounter = n;
                    this.val$prepared = atomicBoolean;
                    this.val$name = string2;
                    this.val$properties = storableProperties;
                }

                @Override
                public void run() {
                    if (prepareLandmarks.loadExisting()) {
                        return;
                    }
                    Object object = LMAlgoFactoryDecorator.this.LOGGER;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(this.val$tmpCounter);
                    stringBuilder.append("/");
                    stringBuilder.append(LMAlgoFactoryDecorator.this.getPreparations().size());
                    stringBuilder.append(" calling LM prepare.doWork for ");
                    stringBuilder.append(prepareLandmarks.getWeighting());
                    stringBuilder.append(" ... (");
                    stringBuilder.append(Helper.getMemInfo());
                    stringBuilder.append(")");
                    object.info(stringBuilder.toString());
                    this.val$prepared.set(true);
                    Thread.currentThread().setName(this.val$name);
                    prepareLandmarks.doWork();
                    object = this.val$properties;
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("prepare.lm.date.");
                    stringBuilder.append(this.val$name);
                    ((StorableProperties)object).put(stringBuilder.toString(), Helper.createFormatter().format(new Date()));
                }
            }, string2);
        }
        this.threadPool.shutdown();
        n2 = n;
        try {
            while (true) {
                if (n2 >= this.preparations.size()) {
                    return atomicBoolean.get();
                }
                executorCompletionService.take().get();
                ++n2;
            }
        }
        catch (Exception exception) {
            this.threadPool.shutdownNow();
            throw new RuntimeException(exception);
        }
    }

    public LMAlgoFactoryDecorator setDisablingAllowed(boolean bl) {
        this.disablingAllowed = bl;
        return this;
    }

    public final LMAlgoFactoryDecorator setEnabled(boolean bl) {
        this.enabled = bl;
        return this;
    }

    public void setPreparationThreads(int n) {
        this.preparationThreads = n;
        this.threadPool = Executors.newFixedThreadPool(n);
    }

    public LMAlgoFactoryDecorator setWeightingsAsStrings(List<String> object) {
        if (!object.isEmpty()) {
            this.weightingsAsStrings.clear();
            object = object.iterator();
            while (object.hasNext()) {
                this.addWeighting(Helper.toLowerCase((String)object.next()).trim());
            }
            return this;
        }
        throw new IllegalArgumentException("It is not allowed to pass an emtpy weightingList");
    }

    public int size() {
        return this.preparations.size();
    }

    public static class LMRAFactory
    implements RoutingAlgorithmFactory {
        private RoutingAlgorithmFactory defaultAlgoFactory;
        private PrepareLandmarks p;

        public LMRAFactory(PrepareLandmarks prepareLandmarks, RoutingAlgorithmFactory routingAlgorithmFactory) {
            this.defaultAlgoFactory = routingAlgorithmFactory;
            this.p = prepareLandmarks;
        }

        @Override
        public RoutingAlgorithm createAlgo(Graph graph, AlgorithmOptions algorithmOptions) {
            RoutingAlgorithm routingAlgorithm = this.defaultAlgoFactory.createAlgo(graph, algorithmOptions);
            return this.p.getDecoratedAlgorithm(graph, routingAlgorithm, algorithmOptions);
        }

        public RoutingAlgorithmFactory getDefaultAlgoFactory() {
            return this.defaultAlgoFactory;
        }
    }
}

