/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LandmarkSuggestion {
    private BBox box;
    private List<Integer> nodeIds;

    public LandmarkSuggestion(List<Integer> list, BBox bBox) {
        this.nodeIds = list;
        this.box = bBox;
    }

    public static final LandmarkSuggestion readLandmarks(String object, LocationIndex locationIndex) throws IOException {
        EdgeFilter edgeFilter = EdgeFilter.ALL_EDGES;
        object = Helper.readFile((String)object);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        BBox bBox = BBox.createInverse(false);
        Iterator iterator2 = object.iterator();
        object = "";
        int n = 0;
        while (iterator2.hasNext()) {
            Object object2 = (String)iterator2.next();
            if (((String)object2).startsWith("#BBOX:")) {
                bBox = BBox.parseTwoPoints(((String)object2).substring(6));
                continue;
            }
            if (((String)object2).isEmpty() || Character.isAlphabetic(((String)object2).charAt(0))) continue;
            GHPoint gHPoint = GHPoint.fromStringLonLat((String)object2);
            if (gHPoint != null) {
                ++n;
                object2 = locationIndex.findClosest(gHPoint.lat, gHPoint.lon, edgeFilter);
                if (!((QueryResult)object2).isValid()) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append((String)object);
                    ((StringBuilder)object2).append("Cannot find close node found for landmark suggestion[");
                    ((StringBuilder)object2).append(n);
                    ((StringBuilder)object2).append("]=");
                    ((StringBuilder)object2).append(gHPoint);
                    ((StringBuilder)object2).append(".\n");
                    object = ((StringBuilder)object2).toString();
                    continue;
                }
                bBox.update(gHPoint.lat, gHPoint.lon);
                arrayList.add(((QueryResult)object2).getClosestNode());
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Invalid format ");
            ((StringBuilder)object).append((String)object2);
            ((StringBuilder)object).append(" for point ");
            ((StringBuilder)object).append(n);
            throw new RuntimeException(((StringBuilder)object).toString());
        }
        if (((String)object).isEmpty()) {
            return new LandmarkSuggestion(arrayList, bBox);
        }
        throw new RuntimeException((String)object);
    }

    public BBox getBox() {
        return this.box;
    }

    public List<Integer> getNodeIds() {
        return this.nodeIds;
    }
}

