/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.AlternativeRoute;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.lm.LMApproximator;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.lm.LandmarkSuggestion;
import com.graphhopper.routing.util.AbstractAlgoPreparation;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareLandmarks
extends AbstractAlgoPreparation {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrepareLandmarks.class);
    private int defaultActiveLandmarks;
    private final Graph graph;
    private final LandmarkStorage lms;
    private final Weighting weighting;

    public PrepareLandmarks(Directory object, GraphHopperStorage graphHopperStorage, Weighting weighting, int n, int n2) {
        if (n2 <= n) {
            this.graph = graphHopperStorage;
            this.defaultActiveLandmarks = n2;
            this.weighting = weighting;
            this.lms = new LandmarkStorage(graphHopperStorage, (Directory)object, weighting, n);
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Default value for active landmarks ");
        ((StringBuilder)object).append(n2);
        ((StringBuilder)object).append(" should be less or equal to landmark count of ");
        ((StringBuilder)object).append(n);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    @Override
    public void doSpecificWork() {
        StopWatch stopWatch = new StopWatch().start();
        Logger logger = LOGGER;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Start calculating ");
        stringBuilder.append(this.lms.getLandmarkCount());
        stringBuilder.append(" landmarks, default active lms:");
        stringBuilder.append(this.defaultActiveLandmarks);
        stringBuilder.append(", weighting:");
        stringBuilder.append(this.lms.getLmSelectionWeighting());
        stringBuilder.append(", ");
        stringBuilder.append(Helper.getMemInfo());
        logger.info(stringBuilder.toString());
        this.lms.createLandmarks();
        this.lms.flush();
        stringBuilder = new StringBuilder();
        stringBuilder.append("Calculated landmarks for ");
        stringBuilder.append(this.lms.getSubnetworksWithLandmarks() - 1);
        stringBuilder.append(" subnetworks, took:");
        stringBuilder.append(stopWatch.stop().getSeconds());
        stringBuilder.append(" => ");
        stringBuilder.append(this.lms.getLandmarksAsGeoJSON());
        stringBuilder.append(", stored weights:");
        stringBuilder.append(this.lms.getLandmarkCount());
        stringBuilder.append(", nodes:");
        stringBuilder.append(this.graph.getNodes());
        stringBuilder.append(", ");
        stringBuilder.append(Helper.getMemInfo());
        logger.info(stringBuilder.toString());
    }

    public RoutingAlgorithm getDecoratedAlgorithm(Graph graph, RoutingAlgorithm routingAlgorithm, AlgorithmOptions object) {
        int n = Math.max(1, ((AlgorithmOptions)object).getHints().getInt("lm.active_landmarks", this.defaultActiveLandmarks));
        if (routingAlgorithm instanceof AStar) {
            if (this.lms.isInitialized()) {
                double d = ((AlgorithmOptions)object).getHints().getDouble("astar.epsilon", 1.0);
                object = (AStar)routingAlgorithm;
                int n2 = this.graph.getNodes();
                LandmarkStorage landmarkStorage = this.lms;
                ((AStar)object).setApproximation(new LMApproximator(graph, n2, landmarkStorage, n, landmarkStorage.getFactor(), false).setEpsilon(d));
                return routingAlgorithm;
            }
            throw new IllegalStateException("Initialize landmark storage before creating algorithms");
        }
        if (routingAlgorithm instanceof AStarBidirection) {
            if (this.lms.isInitialized()) {
                double d = ((AlgorithmOptions)object).getHints().getDouble("astarbi.epsilon", 1.0);
                AStarBidirection aStarBidirection = (AStarBidirection)routingAlgorithm;
                int n3 = this.graph.getNodes();
                object = this.lms;
                aStarBidirection.setApproximation(new LMApproximator(graph, n3, (LandmarkStorage)object, n, ((LandmarkStorage)object).getFactor(), false).setEpsilon(d));
                return routingAlgorithm;
            }
            throw new IllegalStateException("Initialize landmark storage before creating algorithms");
        }
        if (routingAlgorithm instanceof AlternativeRoute) {
            if (this.lms.isInitialized()) {
                double d = ((AlgorithmOptions)object).getHints().getDouble("astarbi.epsilon", 1.0);
                AlternativeRoute alternativeRoute = (AlternativeRoute)routingAlgorithm;
                int n4 = this.graph.getNodes();
                object = this.lms;
                alternativeRoute.setApproximation(new LMApproximator(graph, n4, (LandmarkStorage)object, n, ((LandmarkStorage)object).getFactor(), false).setEpsilon(d));
                alternativeRoute.setMaxExplorationFactor(0.6);
            } else {
                throw new IllegalStateException("Initialize landmark storage before creating algorithms");
            }
        }
        return routingAlgorithm;
    }

    LandmarkStorage getLandmarkStorage() {
        return this.lms;
    }

    public int getSubnetworksWithLandmarks() {
        return this.lms.getSubnetworksWithLandmarks();
    }

    public Weighting getWeighting() {
        return this.weighting;
    }

    public boolean loadExisting() {
        return this.lms.loadExisting();
    }

    public void setLMSelectionWeighting(Weighting weighting) {
        this.lms.setLMSelectionWeighting(weighting);
    }

    public PrepareLandmarks setLandmarkSuggestions(List<LandmarkSuggestion> list) {
        this.lms.setLandmarkSuggestions(list);
        return this;
    }

    public PrepareLandmarks setLogDetails(boolean bl) {
        this.lms.setLogDetails(bl);
        return this;
    }

    public PrepareLandmarks setMaximumWeight(double d) {
        this.lms.setMaximumWeight(d);
        return this;
    }

    public void setMinimumNodes(int n) {
        if (n >= 2) {
            this.lms.setMinimumNodes(n);
            return;
        }
        throw new IllegalArgumentException("minimum node count must be at least 2");
    }

    public PrepareLandmarks setSpatialRuleLookup(SpatialRuleLookup spatialRuleLookup) {
        this.lms.setSpatialRuleLookup(spatialRuleLookup);
        return this;
    }
}

