/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.subnetwork;

import com.carrotsearch.hppc.IntArrayDeque;
import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHBitSetImpl;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.EdgeIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class TarjansSCCAlgorithm {
    private final ArrayList<IntArrayList> components = new ArrayList();
    private final EdgeFilter edgeFilter;
    private final GraphHopperStorage graph;
    private final GHBitSet ignoreSet;
    private int index = 1;
    private final int[] nodeIndex;
    private final int[] nodeLowLink;
    private final IntArrayDeque nodeStack;
    private final GHBitSet onStack;

    public TarjansSCCAlgorithm(GraphHopperStorage graphHopperStorage, EdgeFilter object, boolean bl) {
        this.graph = graphHopperStorage;
        this.nodeStack = new IntArrayDeque();
        this.onStack = new GHBitSetImpl(graphHopperStorage.getNodes());
        this.nodeIndex = new int[graphHopperStorage.getNodes()];
        this.nodeLowLink = new int[graphHopperStorage.getNodes()];
        this.edgeFilter = object;
        if (bl) {
            object = graphHopperStorage.createEdgeExplorer((EdgeFilter)object);
            int n = graphHopperStorage.getNodes();
            this.ignoreSet = new GHBitSetImpl(graphHopperStorage.getNodes());
            for (int i = 0; i < n; ++i) {
                if (graphHopperStorage.isNodeRemoved(i) || object.setBaseNode(i).next()) continue;
                this.ignoreSet.add(i);
            }
        } else {
            this.ignoreSet = new GHBitSetImpl();
        }
    }

    private void strongConnect(int n) {
        Stack<TarjanState> stack = new Stack<TarjanState>();
        stack.push(TarjanState.startState(n));
        block0: while (!stack.empty()) {
            int[] nArray;
            int n2;
            Object object = (TarjanState)stack.pop();
            n = ((TarjanState)object).start;
            if (((TarjanState)object).isStart()) {
                object = this.nodeIndex;
                n2 = this.index;
                object[n] = n2;
                this.nodeLowLink[n] = n2;
                this.index = n2 + 1;
                this.nodeStack.addLast(n);
                this.onStack.add(n);
                object = this.graph.createEdgeExplorer(this.edgeFilter).setBaseNode(n);
            } else {
                object = ((TarjanState)object).iter;
                n2 = object.getAdjNode();
                nArray = this.nodeLowLink;
                nArray[n] = Math.min(nArray[n], nArray[n2]);
            }
            while (object.next()) {
                n2 = object.getAdjNode();
                if (this.ignoreSet.contains(n)) continue;
                if (this.nodeIndex[n2] == 0) {
                    stack.push(TarjanState.resumeState(n, (EdgeIterator)object));
                    stack.push(TarjanState.startState(n2));
                    continue block0;
                }
                if (!this.onStack.contains(n2)) continue;
                nArray = this.nodeLowLink;
                nArray[n] = Math.min(nArray[n], this.nodeIndex[n2]);
            }
            if (this.nodeIndex[n] != this.nodeLowLink[n]) continue;
            object = new IntArrayList();
            while ((n2 = this.nodeStack.removeLast()) != n) {
                object.add(n2);
                this.onStack.remove(n2);
            }
            object.add(n);
            object.trimToSize();
            this.onStack.remove(n);
            this.components.add((IntArrayList)object);
        }
    }

    public List<IntArrayList> findComponents() {
        int n = this.graph.getNodes();
        for (int i = 0; i < n; ++i) {
            if (this.nodeIndex[i] != 0 || this.ignoreSet.contains(i) || this.graph.isNodeRemoved(i)) continue;
            this.strongConnect(i);
        }
        return this.components;
    }

    public GHBitSet getIgnoreSet() {
        return this.ignoreSet;
    }

    private static class TarjanState {
        final EdgeIterator iter;
        final int start;

        private TarjanState(int n, EdgeIterator edgeIterator) {
            this.start = n;
            this.iter = edgeIterator;
        }

        public static TarjanState resumeState(int n, EdgeIterator edgeIterator) {
            return new TarjanState(n, edgeIterator);
        }

        public static TarjanState startState(int n) {
            return new TarjanState(n, null);
        }

        boolean isStart() {
            boolean bl = this.iter == null;
            return bl;
        }
    }
}

