/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.template;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.PathWrapper;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.QueryGraph;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.template.ViaRoutingTemplate;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.PointList;
import com.graphhopper.util.Translation;
import com.graphhopper.util.shapes.GHPoint;
import java.util.Collections;
import java.util.List;

public final class AlternativeRoutingTemplate
extends ViaRoutingTemplate {
    public AlternativeRoutingTemplate(GHRequest gHRequest, GHResponse gHResponse, LocationIndex locationIndex) {
        super(gHRequest, gHResponse, locationIndex);
    }

    @Override
    public List<Path> calcPaths(QueryGraph queryGraph, RoutingAlgorithmFactory routingAlgorithmFactory, AlgorithmOptions algorithmOptions) {
        if (!this.ghRequest.getHints().getBool("pass_through", false)) {
            return super.calcPaths(queryGraph, routingAlgorithmFactory, algorithmOptions);
        }
        throw new IllegalArgumentException("Alternative paths and pass_through at the same time is currently not supported");
    }

    @Override
    public boolean isReady(PathMerger pathMerger, Translation translation) {
        if (!this.pathList.isEmpty()) {
            PointList pointList = this.getWaypoints();
            this.altResponse.setWaypoints(pointList);
            this.ghResponse.add(this.altResponse);
            pathMerger.doWork(this.altResponse, Collections.singletonList(this.pathList.get(0)), translation);
            for (int i = 1; i < this.pathList.size(); ++i) {
                PathWrapper pathWrapper = new PathWrapper();
                pathWrapper.setWaypoints(pointList);
                this.ghResponse.add(pathWrapper);
                pathMerger.doWork(pathWrapper, Collections.singletonList(this.pathList.get(i)), translation);
            }
            return true;
        }
        throw new RuntimeException("Empty paths for alternative route calculation not expected");
    }

    @Override
    public List<QueryResult> lookup(List<GHPoint> list, FlagEncoder object) {
        if (list.size() <= 2) {
            return super.lookup(list, (FlagEncoder)object);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Currently alternative routes work only with start and end point. You tried to use: ");
        ((StringBuilder)object).append(list.size());
        ((StringBuilder)object).append(" points");
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }
}

