/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ConditionalTagInspector;
import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.osm.conditional.ConditionalOSMTagInspector;
import com.graphhopper.reader.osm.conditional.DateRangeParser;
import com.graphhopper.routing.util.EncodedDoubleValue;
import com.graphhopper.routing.util.EncodedValue;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.TurnCostEncoder;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.PMap;
import com.graphhopper.util.Translation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlagEncoder
implements FlagEncoder,
TurnCostEncoder {
    protected static final int K_BACKWARD = 1;
    protected static final int K_FORWARD = 0;
    protected static final double LONG_TRIP_FERRY_SPEED = 30.0;
    protected static final double SHORT_TRIP_FERRY_SPEED = 20.0;
    protected static final double UNKNOWN_DURATION_FERRY_SPEED = 5.0;
    private static final Logger logger = LoggerFactory.getLogger(AbstractFlagEncoder.class);
    protected final Set<String> absoluteBarriers;
    protected long acceptBit;
    protected long backwardBit;
    private boolean blockByDefault;
    private boolean blockFords;
    private ConditionalTagInspector conditionalTagInspector;
    protected long directionBitMask;
    protected final Set<String> ferries;
    protected long ferryBit;
    protected long forwardBit;
    protected final Set<String> intendedValues;
    protected int maxPossibleSpeed;
    private final int maxTurnCosts;
    private long nodeBitMask;
    protected final Set<String> oneways;
    protected final Set<String> potentialBarriers;
    protected PMap properties;
    private boolean registered;
    private long relBitMask;
    protected final Set<String> restrictedValues;
    protected final List<String> restrictions = new ArrayList<String>(5);
    protected long roundaboutBit;
    protected final int speedBits;
    protected EncodedDoubleValue speedEncoder;
    protected final double speedFactor;
    private EncodedValue turnCostEncoder;
    private long turnRestrictionBit;
    private long wayBitMask;

    protected AbstractFlagEncoder(int n, double d, int n2) {
        this.intendedValues = new HashSet<String>(5);
        this.restrictedValues = new HashSet<String>(5);
        HashSet<String> hashSet = new HashSet<String>(5);
        this.ferries = hashSet;
        HashSet<String> hashSet2 = new HashSet<String>(5);
        this.oneways = hashSet2;
        this.absoluteBarriers = new HashSet<String>(5);
        this.potentialBarriers = new HashSet<String>(5);
        this.blockByDefault = true;
        this.blockFords = true;
        int n3 = n2;
        if (n2 <= 0) {
            n3 = 0;
        }
        this.maxTurnCosts = n3;
        this.speedBits = n;
        this.speedFactor = d;
        hashSet2.add("yes");
        hashSet2.add("true");
        hashSet2.add("1");
        hashSet2.add("-1");
        hashSet.add("shuttle_train");
        hashSet.add("ferry");
    }

    public AbstractFlagEncoder(PMap pMap) {
        this.intendedValues = new HashSet<String>(5);
        this.restrictedValues = new HashSet<String>(5);
        this.ferries = new HashSet<String>(5);
        this.oneways = new HashSet<String>(5);
        this.absoluteBarriers = new HashSet<String>(5);
        this.potentialBarriers = new HashSet<String>(5);
        this.blockByDefault = true;
        this.blockFords = true;
        throw new RuntimeException("This method must be overridden in derived classes");
    }

    public AbstractFlagEncoder(String string2) {
        this(new PMap(string2));
    }

    public abstract long acceptWay(ReaderWay var1);

    protected double applyMaxSpeed(ReaderWay readerWay, double d) {
        double d2 = this.getMaxSpeed(readerWay);
        if (d2 >= 0.0) {
            return d2 * 0.9;
        }
        return d;
    }

    public void applyWayTags(ReaderWay readerWay, EdgeIteratorState edgeIteratorState) {
    }

    public int defineNodeBits(int n, int n2) {
        return n2;
    }

    public int defineRelationBits(int n, int n2) {
        return n2;
    }

    public int defineTurnBits(int n, int n2) {
        n = this.maxTurnCosts;
        if (n == 0) {
            return n2;
        }
        if (n == 1) {
            this.turnRestrictionBit = 1L << n2;
            return n2 + 1;
        }
        n = Helper.countBitValue(n);
        this.turnCostEncoder = new EncodedValue("TurnCost", n2, n, 1.0, 0L, this.maxTurnCosts){

            @Override
            public final long getValue(long l) {
                return (l & this.mask) >>> (int)this.shift;
            }
        };
        return n2 + n;
    }

    public int defineWayBits(int n, int n2) {
        this.forwardBit = 1L << n2;
        this.backwardBit = 2L << n2;
        this.directionBitMask = 3L << n2;
        this.roundaboutBit = 1L << (n2 += 2);
        this.acceptBit = 1L << (n *= 2);
        this.ferryBit = 2L << n;
        return n2 + 1;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        object = (AbstractFlagEncoder)object;
        if (this.directionBitMask != ((AbstractFlagEncoder)object).directionBitMask) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public long flagsDefault(boolean bl, boolean bl2) {
        return this.setAccess(this.speedEncoder.setDefaultValue(0L), bl, bl2);
    }

    @Override
    public InstructionAnnotation getAnnotation(long l, Translation translation) {
        return InstructionAnnotation.EMPTY;
    }

    public ConditionalTagInspector getConditionalTagInspector() {
        return this.conditionalTagInspector;
    }

    @Override
    public double getDouble(long l, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unknown key ");
        stringBuilder.append(n);
        stringBuilder.append(" for double value.");
        throw new UnsupportedOperationException(stringBuilder.toString());
    }

    /*
     * Unable to fully structure code
     */
    protected double getFerrySpeed(ReaderWay var1_1) {
        block15: {
            block14: {
                block13: {
                    try {
                        var2_3 = Long.parseLong(var1_1.getTag("duration:seconds"));
                    }
                    catch (Exception var4_4) {
                        var2_3 = 0L;
                    }
                    var5_6 = (double)var2_3 / 60.0;
                    var7_7 = var5_6 / 60.0;
                    var4_5 = var1_1.getTag("estimated_distance", null);
                    var9_8 = var7_7;
                    if (!(var7_7 > 0.0)) break block15;
                    var9_8 = var7_7;
                    if (var4_5 == null) break block15;
                    var9_8 = var4_5.doubleValue() / 1000.0 / var7_7 / 1.4;
                    if (!(var9_8 > 0.01)) ** GOTO lbl22
                    if (var9_8 > this.getMaxSpeed()) {
                        return this.getMaxSpeed();
                    }
                    if ((double)Math.round(var9_8) < this.speedEncoder.factor / 2.0) {
                        return this.speedEncoder.factor / 2.0;
                    }
                    return Math.round(var9_8);
lbl22:
                    // 1 sources

                    var11_9 = var1_1.getNodes().isEmpty();
                    var12_10 = -1L;
                    if (!var11_9) break block13;
                    var2_3 = -1L;
                    ** GOTO lbl30
                }
                var2_3 = var1_1.getNodes().get(var1_1.getNodes().size() - 1);
lbl30:
                // 2 sources

                if (!var1_1.getNodes().isEmpty()) {
                    var12_10 = var1_1.getNodes().get(0);
                }
                if (var12_10 == var2_3) break block14;
                try {
                    var14_11 = AbstractFlagEncoder.logger;
                    var15_12 = new StringBuilder();
                    var15_12.append("Unrealistic long duration ignored in way with way ID=");
                    var15_12.append(var1_1.getId());
                    var15_12.append(" : Duration tag value=");
                    var15_12.append(var1_1.getTag("duration"));
                    var15_12.append(" (=");
                    var15_12.append(Math.round(var5_6));
                    var15_12.append(" minutes)");
                    var14_11.warn(var15_12.toString());
                }
                catch (Exception var1_2) {
                    var9_8 = var7_7;
                }
            }
            var9_8 = 0.0;
        }
        if (var9_8 == 0.0) {
            if (var4_5 != null && var4_5.doubleValue() <= 300.0) {
                return this.speedEncoder.factor / 2.0;
            }
            return 5.0;
        }
        if (var9_8 > 1.0) {
            return 30.0;
        }
        return 20.0;
    }

    @Override
    public long getLong(long l, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unknown key ");
        stringBuilder.append(n);
        stringBuilder.append(" for long value.");
        throw new UnsupportedOperationException(stringBuilder.toString());
    }

    @Override
    public double getMaxSpeed() {
        return this.speedEncoder.getMaxValue();
    }

    protected double getMaxSpeed(ReaderWay readerWay) {
        double d;
        block6: {
            double d2;
            block7: {
                double d3;
                block4: {
                    block5: {
                        d = this.parseSpeed(readerWay.getTag("maxspeed"));
                        d2 = this.parseSpeed(readerWay.getTag("maxspeed:forward"));
                        d3 = d;
                        if (!(d2 >= 0.0)) break block4;
                        if (d < 0.0) break block5;
                        d3 = d;
                        if (!(d2 < d)) break block4;
                    }
                    d3 = d2;
                }
                d2 = this.parseSpeed(readerWay.getTag("maxspeed:backward"));
                d = d3;
                if (!(d2 >= 0.0)) break block6;
                if (d3 < 0.0) break block7;
                d = d3;
                if (!(d2 < d3)) break block6;
            }
            d = d2;
        }
        return d;
    }

    long getNodeBitMask() {
        return this.nodeBitMask;
    }

    protected String getPropertiesString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("speed_factor=");
        stringBuilder.append(this.speedFactor);
        stringBuilder.append("|speed_bits=");
        stringBuilder.append(this.speedBits);
        stringBuilder.append("|turn_costs=");
        boolean bl = this.maxTurnCosts > 0;
        stringBuilder.append(bl);
        return stringBuilder.toString();
    }

    long getRelBitMask() {
        return this.relBitMask;
    }

    @Override
    public double getReverseSpeed(long l) {
        return this.getSpeed(l);
    }

    @Override
    public double getSpeed(long l) {
        double d = this.speedEncoder.getDoubleValue(l);
        if (!(d < 0.0)) {
            return d;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Speed was negative!? ");
        stringBuilder.append(d);
        throw new IllegalStateException(stringBuilder.toString());
    }

    @Override
    public double getTurnCost(long l) {
        int n = this.maxTurnCosts;
        double d = 0.0;
        if (n == 0) {
            return 0.0;
        }
        if (n == 1) {
            if ((l & this.turnRestrictionBit) != 0L) {
                d = Double.POSITIVE_INFINITY;
            }
            return d;
        }
        if ((l = this.turnCostEncoder.getValue(l)) == (long)this.maxTurnCosts) {
            return Double.POSITIVE_INFINITY;
        }
        return l;
    }

    @Override
    public long getTurnFlags(boolean bl, double d) {
        block13: {
            int n;
            block12: {
                block11: {
                    n = this.maxTurnCosts;
                    long l = 0L;
                    if (n == 0) {
                        return 0L;
                    }
                    if (n == 1) {
                        if (d == 0.0) {
                            if (bl) {
                                l = this.turnRestrictionBit;
                            }
                            return l;
                        }
                        throw new IllegalArgumentException("Only restrictions are supported");
                    }
                    if (!bl) break block11;
                    if (d != 0.0 || Double.isInfinite(d)) {
                        throw new IllegalArgumentException("Restricted turn can only have infinite costs (or use 0)");
                    }
                    break block12;
                }
                if (d >= (double)n) break block13;
            }
            if (!(d < 0.0)) {
                n = this.maxTurnCosts;
                if (d >= (double)n || bl) {
                    d = n;
                }
                return this.turnCostEncoder.setValue(0L, (int)d);
            }
            throw new IllegalArgumentException("Turn costs cannot be negative");
        }
        throw new IllegalArgumentException("Cost is too high. Or specify restricted == true");
    }

    long getWayBitMask() {
        return this.wayBitMask;
    }

    public long handleNodeTags(ReaderNode readerNode) {
        if (readerNode.hasTag("barrier", this.absoluteBarriers)) {
            return this.directionBitMask;
        }
        if (readerNode.hasTag("barrier", this.potentialBarriers)) {
            boolean bl = readerNode.hasTag("locked", (Object)"yes");
            for (String string2 : this.restrictions) {
                if (!bl && readerNode.hasTag(string2, this.intendedValues)) {
                    return 0L;
                }
                if (!readerNode.hasTag(string2, this.restrictedValues)) continue;
                return this.directionBitMask;
            }
            if (this.blockByDefault) {
                return this.directionBitMask;
            }
        }
        if (this.blockFords && (readerNode.hasTag("highway", (Object)"ford") || readerNode.hasTag("ford", new String[0])) && !readerNode.hasTag(this.restrictions, this.intendedValues) && !readerNode.hasTag("ford", (Object)"no")) {
            return this.directionBitMask;
        }
        return 0L;
    }

    public abstract long handleRelationTags(ReaderRelation var1, long var2);

    public abstract long handleWayTags(ReaderWay var1, long var2, long var4);

    public int hashCode() {
        return (427 + (int)this.directionBitMask) * 61 + this.toString().hashCode();
    }

    protected void init() {
        this.conditionalTagInspector = new ConditionalOSMTagInspector(DateRangeParser.createCalendar(), this.restrictions, this.restrictedValues, this.intendedValues);
    }

    protected boolean isAccept(long l) {
        boolean bl = (l & this.acceptBit) != 0L;
        return bl;
    }

    @Override
    public boolean isBackward(long l) {
        boolean bl = (l & this.backwardBit) != 0L;
        return bl;
    }

    public boolean isBlockFords() {
        return this.blockFords;
    }

    @Override
    public boolean isBool(long l, int n) {
        if (n != 0) {
            boolean bl = true;
            if (n != 1) {
                if (n == 2) {
                    if ((l & this.roundaboutBit) == 0L) {
                        bl = false;
                    }
                    return bl;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Unknown key ");
                stringBuilder.append(n);
                stringBuilder.append(" for boolean value");
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            return this.isBackward(l);
        }
        return this.isForward(l);
    }

    protected boolean isFerry(long l) {
        boolean bl = (l & this.ferryBit) != 0L;
        return bl;
    }

    @Override
    public boolean isForward(long l) {
        boolean bl = (l & this.forwardBit) != 0L;
        return bl;
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    @Override
    public boolean isTurnRestricted(long l) {
        int n = this.maxTurnCosts;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            return false;
        }
        if (n == 1) {
            if ((l & this.turnRestrictionBit) != 0L) {
                bl2 = true;
            }
            return bl2;
        }
        bl2 = bl;
        if (this.turnCostEncoder.getValue(l) == (long)this.maxTurnCosts) {
            bl2 = true;
        }
        return bl2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected double parseSpeed(String string2) {
        double d;
        double d2;
        int n;
        if (Helper.isEmpty(string2)) {
            return -1.0;
        }
        if ("none".equals(string2)) {
            return 140.0;
        }
        if (string2.endsWith(":rural")) return 80.0;
        if (string2.endsWith(":trunk")) {
            return 80.0;
        }
        if (string2.endsWith(":urban")) {
            return 50.0;
        }
        if (string2.equals("walk")) return 6.0;
        if (string2.endsWith(":living_street")) {
            return 6.0;
        }
        try {
            n = string2.indexOf("mp");
            if (n > 0) {
                d2 = Integer.parseInt(string2.substring(0, n).trim());
                d = 1.609344;
                return d2 * d;
            }
        }
        catch (Exception exception) {
            return -1.0;
        }
        {
            String string3;
            n = string2.indexOf("knots");
            if (n > 0) {
                d2 = Integer.parseInt(string2.substring(0, n).trim());
                d = 1.852;
                return d2 * d;
            }
            n = string2.indexOf("km");
            if (n > 0) {
                string3 = string2.substring(0, n).trim();
            } else {
                n = string2.indexOf("kph");
                string3 = string2;
                if (n > 0) {
                    string3 = string2.substring(0, n).trim();
                }
            }
            n = Integer.parseInt(string3);
        }
        return n;
    }

    public long reverseFlags(long l) {
        long l2 = this.directionBitMask;
        long l3 = l & l2;
        long l4 = l;
        if (l3 != l2) {
            l4 = l3 == 0L ? l : l ^ l2;
        }
        return l4;
    }

    @Override
    public long setAccess(long l, boolean bl, boolean bl2) {
        return this.setBool(this.setBool(l, 1, bl2), 0, bl);
    }

    public void setBlockByDefault(boolean bl) {
        this.blockByDefault = bl;
    }

    public void setBlockFords(boolean bl) {
        this.blockFords = bl;
    }

    @Override
    public long setBool(long l, int n, boolean bl) {
        if (n != 0) {
            if (n != 1) {
                if (n == 2) {
                    l = bl ? (l |= this.roundaboutBit) : (l &= this.roundaboutBit);
                    return l;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Unknown key ");
                stringBuilder.append(n);
                stringBuilder.append(" for boolean value");
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            l = bl ? (l |= this.backwardBit) : (l &= this.backwardBit);
            return l;
        }
        l = bl ? (l |= this.forwardBit) : (l &= this.forwardBit);
        return l;
    }

    protected void setConditionalTagInspector(ConditionalTagInspector conditionalTagInspector) {
        this.conditionalTagInspector = conditionalTagInspector;
    }

    @Override
    public long setDouble(long l, int n, double d) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unknown key ");
        stringBuilder.append(n);
        stringBuilder.append(" for double value.");
        throw new UnsupportedOperationException(stringBuilder.toString());
    }

    @Override
    public long setLong(long l, int n, long l2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unknown key ");
        stringBuilder.append(n);
        stringBuilder.append(" for long value.");
        throw new UnsupportedOperationException(stringBuilder.toString());
    }

    protected long setLowSpeed(long l, double d, boolean bl) {
        return this.setAccess(this.speedEncoder.setDoubleValue(l, 0.0), false, false);
    }

    void setNodeBitMask(int n, int n2) {
        long l;
        this.nodeBitMask = l = (1L << n) - 1L;
        this.nodeBitMask = l << n2;
    }

    @Override
    public long setProperties(double d, boolean bl, boolean bl2) {
        return this.setAccess(this.setSpeed(0L, d), bl, bl2);
    }

    public void setRegistered(boolean bl) {
        this.registered = bl;
    }

    void setRelBitMask(int n, int n2) {
        long l;
        this.relBitMask = l = (1L << n) - 1L;
        this.relBitMask = l << n2;
    }

    @Override
    public long setReverseSpeed(long l, double d) {
        return this.setSpeed(l, d);
    }

    @Override
    public long setSpeed(long l, double d) {
        if (!(d < 0.0) && !Double.isNaN(d)) {
            if (d < this.speedEncoder.factor / 2.0) {
                return this.setLowSpeed(l, d, false);
            }
            double d2 = d;
            if (d > this.getMaxSpeed()) {
                d2 = this.getMaxSpeed();
            }
            return this.speedEncoder.setDoubleValue(l, d2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Speed cannot be negative or NaN: ");
        stringBuilder.append(d);
        stringBuilder.append(", flags:");
        stringBuilder.append(BitUtil.LITTLE.toBitString(l));
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    void setWayBitMask(int n, int n2) {
        long l;
        this.wayBitMask = l = (1L << n) - 1L;
        this.wayBitMask = l << n2;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        boolean bl;
        boolean bl2 = TurnWeighting.class.isAssignableFrom(clazz);
        boolean bl3 = bl = false;
        if (bl2) {
            bl3 = bl;
            if (this.maxTurnCosts > 0) {
                bl3 = true;
            }
        }
        return bl3;
    }
}

