/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.EncodedDoubleValue;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CarFlagEncoder
extends AbstractFlagEncoder {
    protected int badSurfaceSpeed;
    protected final Set<String> badSurfaceSpeedMap;
    protected final Map<String, Integer> defaultSpeedMap;
    protected int destinationSpeed;
    protected final Map<String, Integer> trackTypeSpeedMap;

    public CarFlagEncoder() {
        this(5, 5.0, 0);
    }

    public CarFlagEncoder(int n, double d, int n2) {
        super(n, d, n2);
        Serializable serializable = new HashMap<String, Integer>();
        this.trackTypeSpeedMap = serializable;
        Serializable serializable2 = new HashSet<String>();
        this.badSurfaceSpeedMap = serializable2;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        this.defaultSpeedMap = hashMap;
        this.restrictions.addAll(Arrays.asList("motorcar", "motor_vehicle", "vehicle", "access"));
        this.restrictedValues.add("private");
        this.restrictedValues.add("agricultural");
        this.restrictedValues.add("forestry");
        this.restrictedValues.add("no");
        this.restrictedValues.add("restricted");
        this.restrictedValues.add("delivery");
        this.restrictedValues.add("military");
        this.restrictedValues.add("emergency");
        this.intendedValues.add("yes");
        this.intendedValues.add("permissive");
        this.potentialBarriers.add("gate");
        this.potentialBarriers.add("lift_gate");
        this.potentialBarriers.add("kissing_gate");
        this.potentialBarriers.add("swing_gate");
        this.absoluteBarriers.add("bollard");
        this.absoluteBarriers.add("stile");
        this.absoluteBarriers.add("turnstile");
        this.absoluteBarriers.add("cycle_barrier");
        this.absoluteBarriers.add("motorcycle_barrier");
        this.absoluteBarriers.add("block");
        this.absoluteBarriers.add("bus_trap");
        this.absoluteBarriers.add("sump_buster");
        Integer n3 = 20;
        serializable.put("grade1", n3);
        Integer n4 = 15;
        serializable.put("grade2", n4);
        serializable.put("grade3", 10);
        serializable2.add("cobblestone");
        serializable2.add("grass_paver");
        serializable2.add("gravel");
        serializable2.add("sand");
        serializable2.add("paving_stones");
        serializable2.add("dirt");
        serializable2.add("ground");
        serializable2.add("grass");
        serializable2.add("unpaved");
        serializable2.add("compacted");
        serializable = 30;
        this.badSurfaceSpeed = 30;
        this.destinationSpeed = 5;
        this.maxPossibleSpeed = 140;
        hashMap.put("motorway", 100);
        serializable2 = 70;
        hashMap.put("motorway_link", (Integer)serializable2);
        hashMap.put("motorroad", 90);
        hashMap.put("trunk", (Integer)serializable2);
        serializable2 = 65;
        hashMap.put("trunk_link", (Integer)serializable2);
        hashMap.put("primary", (Integer)serializable2);
        serializable2 = 60;
        hashMap.put("primary_link", (Integer)serializable2);
        hashMap.put("secondary", (Integer)serializable2);
        serializable2 = 50;
        hashMap.put("secondary_link", (Integer)serializable2);
        hashMap.put("tertiary", (Integer)serializable2);
        hashMap.put("tertiary_link", 40);
        hashMap.put("unclassified", (Integer)serializable);
        hashMap.put("residential", (Integer)serializable);
        hashMap.put("living_street", 5);
        hashMap.put("service", n3);
        hashMap.put("road", n3);
        hashMap.put("track", n4);
        this.init();
    }

    public CarFlagEncoder(PMap pMap) {
        this((int)pMap.getLong("speed_bits", 5L), pMap.getDouble("speed_factor", 5.0), pMap.getBool("turn_costs", false) ? 1 : 0);
        this.properties = pMap;
        this.setBlockFords(pMap.getBool("block_fords", true));
        this.setBlockByDefault(pMap.getBool("block_barriers", true));
    }

    public CarFlagEncoder(String string2) {
        this(new PMap(string2));
    }

    @Override
    public long acceptWay(ReaderWay readerWay) {
        String string2;
        String string3 = readerWay.getTag("highway");
        String string4 = readerWay.getFirstPriorityTag(this.restrictions);
        if (string3 == null) {
            if (readerWay.hasTag("route", (Set<String>)this.ferries)) {
                if (this.restrictedValues.contains(string4)) {
                    return 0L;
                }
                if (this.intendedValues.contains(string4) || string4.isEmpty() && !readerWay.hasTag("foot", new String[0]) && !readerWay.hasTag("bicycle", new String[0])) {
                    return this.acceptBit | this.ferryBit;
                }
            }
            return 0L;
        }
        if ("track".equals(string3) && (string2 = readerWay.getTag("tracktype")) != null && !string2.equals("grade1") && !string2.equals("grade2") && !string2.equals("grade3")) {
            return 0L;
        }
        if (!this.defaultSpeedMap.containsKey(string3)) {
            return 0L;
        }
        if (!readerWay.hasTag("impassable", (Object)"yes") && !readerWay.hasTag("status", (Object)"impassable")) {
            if (!string4.isEmpty()) {
                if (this.restrictedValues.contains(string4) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(readerWay)) {
                    return 0L;
                }
                if (this.intendedValues.contains(string4)) {
                    return this.acceptBit;
                }
            }
            if (this.isBlockFords() && ("ford".equals(string3) || readerWay.hasTag("ford", new String[0]))) {
                return 0L;
            }
            if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(readerWay)) {
                return 0L;
            }
            return this.acceptBit;
        }
        return 0L;
    }

    protected double applyBadSurfaceSpeed(ReaderWay readerWay, double d) {
        int n = this.badSurfaceSpeed;
        double d2 = d;
        if (n > 0) {
            d2 = d;
            if (d > (double)n) {
                d2 = d;
                if (readerWay.hasTag("surface", this.badSurfaceSpeedMap)) {
                    d2 = this.badSurfaceSpeed;
                }
            }
        }
        return d2;
    }

    @Override
    public int defineWayBits(int n, int n2) {
        n = super.defineWayBits(n, n2);
        this.speedEncoder = new EncodedDoubleValue("Speed", n, this.speedBits, this.speedFactor, this.defaultSpeedMap.get("secondary").intValue(), this.maxPossibleSpeed);
        return n + this.speedEncoder.getBits();
    }

    protected double getSpeed(ReaderWay object) {
        Integer n;
        Object object2;
        Object object3 = object2 = ((ReaderElement)object).getTag("highway");
        if (!Helper.isEmpty((String)object2)) {
            object3 = object2;
            if (((ReaderElement)object).hasTag("motorroad", (Object)"yes")) {
                object3 = object2;
                if (object2 != "motorway") {
                    object3 = object2;
                    if (object2 != "motorway_link") {
                        object3 = "motorroad";
                    }
                }
            }
        }
        if ((n = this.defaultSpeedMap.get(object3)) != null) {
            object2 = n;
            if (((String)object3).equals("track")) {
                object = ((ReaderElement)object).getTag("tracktype");
                object2 = n;
                if (!Helper.isEmpty((String)object)) {
                    object = this.trackTypeSpeedMap.get(object);
                    object2 = n;
                    if (object != null) {
                        object2 = object;
                    }
                }
            }
            return ((Integer)object2).intValue();
        }
        object2 = new StringBuilder();
        ((StringBuilder)object2).append(this.toString());
        ((StringBuilder)object2).append(", no speed found for: ");
        ((StringBuilder)object2).append((String)object3);
        ((StringBuilder)object2).append(", tags: ");
        ((StringBuilder)object2).append(object);
        throw new IllegalStateException(((StringBuilder)object2).toString());
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public String getWayInfo(ReaderWay object) {
        boolean bl = "motorway_link".equals(((ReaderElement)object).getTag("highway"));
        String string2 = "";
        Object object2 = string2;
        if (bl) {
            object = ((ReaderElement)object).getTag("destination");
            object2 = string2;
            if (!Helper.isEmpty((String)object)) {
                String[] stringArray = ((String)object).split(";");
                int n = stringArray.length;
                int n2 = 0;
                int n3 = 0;
                object = string2;
                while (true) {
                    object2 = object;
                    if (n2 >= n) break;
                    string2 = stringArray[n2];
                    if (!string2.trim().isEmpty()) {
                        object2 = object;
                        if (n3 > 0) {
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append((String)object);
                            ((StringBuilder)object2).append(", ");
                            object2 = ((StringBuilder)object2).toString();
                        }
                        object = new StringBuilder();
                        ((StringBuilder)object).append((String)object2);
                        ((StringBuilder)object).append(string2.trim());
                        object = ((StringBuilder)object).toString();
                        ++n3;
                    }
                    ++n2;
                }
            }
        }
        if (((String)object2).isEmpty()) {
            return object2;
        }
        if (((String)object2).contains(",")) {
            object = new StringBuilder();
            ((StringBuilder)object).append("destinations: ");
            ((StringBuilder)object).append((String)object2);
            return ((StringBuilder)object).toString();
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("destination: ");
        ((StringBuilder)object).append((String)object2);
        return ((StringBuilder)object).toString();
    }

    @Override
    public long handleRelationTags(ReaderRelation readerRelation, long l) {
        return l;
    }

    @Override
    public long handleWayTags(ReaderWay readerWay, long l, long l2) {
        block7: {
            block6: {
                block4: {
                    block5: {
                        if (!this.isAccept(l)) {
                            return 0L;
                        }
                        if (this.isFerry(l)) break block4;
                        l = this.setSpeed(0L, this.applyBadSurfaceSpeed(readerWay, this.applyMaxSpeed(readerWay, this.getSpeed(readerWay))));
                        boolean bl = readerWay.hasTag("junction", (Object)"roundabout") || readerWay.hasTag("junction", (Object)"circular");
                        l2 = l;
                        if (bl) {
                            l2 = this.setBool(l, 2, true);
                        }
                        if (this.isOneway(readerWay) || bl) break block5;
                        long l3 = this.directionBitMask;
                        l = l2;
                        l2 = l3;
                        break block6;
                    }
                    l = l2;
                    if (this.isBackwardOneway(readerWay)) {
                        l = l2 | this.backwardBit;
                    }
                    l2 = l;
                    if (!this.isForwardOneway(readerWay)) break block7;
                    l2 = this.forwardBit;
                    break block6;
                }
                l = this.setSpeed(0L, this.getFerrySpeed(readerWay));
                l2 = this.directionBitMask;
            }
            l2 = l | l2;
        }
        Iterator iterator2 = this.restrictions.iterator();
        while (iterator2.hasNext()) {
            if (!readerWay.hasTag((String)iterator2.next(), (Object)"destination")) continue;
            l2 = this.setSpeed(l2, this.destinationSpeed);
        }
        return l2;
    }

    protected boolean isBackwardOneway(ReaderWay readerWay) {
        boolean bl = readerWay.hasTag("oneway", (Object)"-1") || readerWay.hasTag("vehicle:forward", (Object)"no") || readerWay.hasTag("motor_vehicle:forward", (Object)"no");
        return bl;
    }

    protected boolean isForwardOneway(ReaderWay readerWay) {
        boolean bl = !readerWay.hasTag("oneway", (Object)"-1") && !readerWay.hasTag("vehicle:forward", (Object)"no") && !readerWay.hasTag("motor_vehicle:forward", (Object)"no");
        return bl;
    }

    protected boolean isOneway(ReaderWay readerWay) {
        boolean bl = readerWay.hasTag("oneway", (Set<String>)this.oneways);
        boolean bl2 = false;
        if (bl || readerWay.hasTag("vehicle:backward", new String[0]) || readerWay.hasTag("vehicle:forward", new String[0]) || readerWay.hasTag("motor_vehicle:backward", new String[0]) || readerWay.hasTag("motor_vehicle:forward", new String[0])) {
            bl2 = true;
        }
        return bl2;
    }

    public String toString() {
        return "car";
    }
}

