/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

public class EncodedValue {
    private final boolean allowZero;
    private final int bits;
    protected final long defaultValue;
    protected final double factor;
    protected final long mask;
    private final long maxValue;
    private final String name;
    protected final long shift;

    public EncodedValue(String string2, int n, int n2, double d, long l, int n3) {
        this(string2, n, n2, d, l, n3, true);
    }

    public EncodedValue(String string2, int n, int n2, double d, long l, int n3, boolean bl) {
        long l2;
        this.name = string2;
        this.shift = n;
        this.factor = d;
        this.defaultValue = l;
        this.bits = n2;
        l = (1L << n2) - 1L;
        long l3 = n3;
        this.maxValue = l2 = Math.min(l3, Math.round((double)l * d));
        if (l3 <= l2) {
            if ((d = (double)n3 / d) == (double)((int)d)) {
                this.mask = l << n;
                this.allowZero = bl;
                return;
            }
            throw new IllegalStateException("MaxValue needs to be divisible by factor without remainder");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(" -> maxValue ");
        stringBuilder.append(n3);
        stringBuilder.append(" is too large for ");
        stringBuilder.append(n2);
        stringBuilder.append(" bits");
        throw new IllegalStateException(stringBuilder.toString());
    }

    protected void checkValue(long l) {
        if (l <= this.maxValue) {
            long l2 = l - 0L;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            if (l3 >= 0) {
                if (!this.allowZero && l3 == false) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("zero ");
                    stringBuilder.append(this.name);
                    stringBuilder.append(" value not allowed! ");
                    stringBuilder.append(l);
                    throw new IllegalArgumentException(stringBuilder.toString());
                }
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("negative ");
            stringBuilder.append(this.name);
            stringBuilder.append(" value not allowed! ");
            stringBuilder.append(l);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append(" value too large for encoding: ");
        stringBuilder.append(l);
        stringBuilder.append(", maxValue:");
        stringBuilder.append(this.maxValue);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public int getBits() {
        return this.bits;
    }

    public double getFactor() {
        return this.factor;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public String getName() {
        return this.name;
    }

    public long getValue(long l) {
        return Math.round((double)((l & this.mask) >>> (int)this.shift) * this.factor);
    }

    public long setDefaultValue(long l) {
        return this.setValue(l, this.defaultValue);
    }

    public long setValue(long l, long l2) {
        l2 = Math.round((double)l2 / this.factor);
        this.checkValue((long)((double)l2 * this.factor));
        int n = (int)this.shift;
        return l & this.mask | l2 << n;
    }

    public long swap(long l, EncodedValue encodedValue) {
        long l2 = encodedValue.getValue(l);
        return this.setValue(encodedValue.setValue(l, this.getValue(l)), l2);
    }
}

