/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.FootFlagEncoder;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.util.PMap;
import java.util.Set;
import java.util.TreeMap;

public class HikeFlagEncoder
extends FootFlagEncoder {
    public HikeFlagEncoder() {
        this(4, 1.0);
    }

    public HikeFlagEncoder(int n, double d) {
        super(n, d);
        this.hikingNetworkToCode.put("iwn", PriorityCode.BEST.getValue());
        this.hikingNetworkToCode.put("nwn", PriorityCode.BEST.getValue());
        this.hikingNetworkToCode.put("rwn", PriorityCode.VERY_NICE.getValue());
        this.hikingNetworkToCode.put("lwn", PriorityCode.VERY_NICE.getValue());
        this.init();
    }

    public HikeFlagEncoder(PMap pMap) {
        this((int)pMap.getLong("speedBits", 4L), pMap.getDouble("speedFactor", 1.0));
        this.properties = pMap;
        this.setBlockFords(pMap.getBool("block_fords", false));
    }

    public HikeFlagEncoder(String string2) {
        this(new PMap(string2));
    }

    @Override
    public long acceptWay(ReaderWay readerWay) {
        String string2 = readerWay.getTag("highway");
        if (string2 == null) {
            long l = readerWay.hasTag("route", (Set<String>)this.ferries) && ((string2 = readerWay.getTag("foot")) == null || "yes".equals(string2)) ? this.acceptBit | this.ferryBit : 0L;
            if (readerWay.hasTag("railway", (Object)"platform")) {
                l = this.acceptBit;
            }
            if (readerWay.hasTag("man_made", (Object)"pier")) {
                l = this.acceptBit;
            }
            if (l != 0L) {
                if (readerWay.hasTag(this.restrictions, (Set<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(readerWay)) {
                    return 0L;
                }
                return l;
            }
            return 0L;
        }
        if (readerWay.hasTag("foot", (Set<String>)this.intendedValues)) {
            return this.acceptBit;
        }
        if (readerWay.hasTag(this.restrictions, (Set<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(readerWay)) {
            return 0L;
        }
        if (readerWay.hasTag("sidewalk", (Set<String>)this.sidewalkValues)) {
            return this.acceptBit;
        }
        if (!this.allowedHighwayTags.contains(string2)) {
            return 0L;
        }
        if (readerWay.hasTag("motorroad", (Object)"yes")) {
            return 0L;
        }
        if (this.isBlockFords() && (readerWay.hasTag("highway", (Object)"ford") || readerWay.hasTag("ford", new String[0]))) {
            return 0L;
        }
        if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(readerWay)) {
            return 0L;
        }
        return this.acceptBit;
    }

    @Override
    void collect(ReaderWay readerWay, TreeMap<Double, Integer> treeMap) {
        String string2 = readerWay.getTag("highway");
        if (readerWay.hasTag("foot", (Object)"designated")) {
            treeMap.put(100.0, PriorityCode.PREFER.getValue());
        }
        double d = this.getMaxSpeed(readerWay);
        if (!(this.safeHighwayTags.contains(string2) || d > 0.0 && d <= 20.0)) {
            if (d > 50.0 || this.avoidHighwayTags.contains(string2)) {
                if (readerWay.hasTag("sidewalk", (Set<String>)this.sidewalksNoValues)) {
                    treeMap.put(45.0, PriorityCode.WORST.getValue());
                } else {
                    treeMap.put(45.0, PriorityCode.REACH_DEST.getValue());
                }
            }
        } else {
            treeMap.put(40.0, PriorityCode.PREFER.getValue());
            if (readerWay.hasTag("tunnel", (Set<String>)this.intendedValues)) {
                if (readerWay.hasTag("sidewalk", (Set<String>)this.sidewalksNoValues)) {
                    treeMap.put(40.0, PriorityCode.REACH_DEST.getValue());
                } else {
                    treeMap.put(40.0, PriorityCode.UNCHANGED.getValue());
                }
            }
        }
        if (readerWay.hasTag("bicycle", (Object)"official") || readerWay.hasTag("bicycle", (Object)"designated")) {
            treeMap.put(44.0, PriorityCode.AVOID_IF_POSSIBLE.getValue());
        }
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        if (super.supports(clazz)) {
            return true;
        }
        return PriorityWeighting.class.isAssignableFrom(clazz);
    }

    @Override
    public String toString() {
        return "hike";
    }
}

