/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.PathWrapper;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.QueryGraph;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.RoutingAlgorithmFactorySimple;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.TurnCostExtension;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.PointList;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.shapes.GHPoint3D;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class TestAlgoCollector {
    private final DistanceCalc distCalc;
    public final List<String> errors = new ArrayList<String>();
    private final String name;
    private final TranslationMap trMap;

    public TestAlgoCollector(String string2) {
        this.distCalc = Helper.DIST_EARTH;
        this.trMap = new TranslationMap().doImport();
        this.name = string2;
    }

    public TestAlgoCollector assertDistance(AlgoHelperEntry algoHelperEntry, List<QueryResult> list, OneRun oneRun) {
        Iterable<Object> iterable = new ArrayList<Path>();
        Object object = new QueryGraph(algoHelperEntry.getForQueryGraph());
        ((QueryGraph)object).lookup(list);
        Object object2 = algoHelperEntry.getAlgorithmOptions();
        if (((AlgorithmOptions)object2).getWeighting().getFlagEncoder().supports(TurnWeighting.class)) {
            if (!((AlgorithmOptions)object2).getTraversalMode().isEdgeBased()) {
                this.errors.add("Cannot use TurnWeighting with a node based traversal");
                return this;
            }
            algoHelperEntry.setAlgorithmOptions(AlgorithmOptions.start((AlgorithmOptions)object2).weighting(new TurnWeighting(((AlgorithmOptions)object2).getWeighting(), (TurnCostExtension)((QueryGraph)object).getExtension())).build());
        }
        List<String> list2 = algoHelperEntry.createRoutingFactory();
        int n = 0;
        while (n < list.size() - 1) {
            object2 = list2.createAlgo((Graph)object, algoHelperEntry.getAlgorithmOptions());
            int n2 = list.get(n).getClosestNode();
            iterable.add((Path)object2.calcPath(n2, list.get(++n).getClosestNode()));
        }
        object2 = new PathMerger().setCalcPoints(true).setSimplifyResponse(false).setEnableInstructions(true);
        object = new PathWrapper();
        ((PathMerger)object2).doWork((PathWrapper)object, (List<Path>)iterable, this.trMap.getWithFallBack(Locale.US));
        if (((PathWrapper)object).hasErrors()) {
            iterable = this.errors;
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("response for ");
            ((StringBuilder)object2).append(algoHelperEntry);
            ((StringBuilder)object2).append(" contains errors. Expected distance: ");
            ((StringBuilder)object2).append(oneRun.getDistance());
            ((StringBuilder)object2).append(", expected points: ");
            ((StringBuilder)object2).append(oneRun);
            ((StringBuilder)object2).append(". ");
            ((StringBuilder)object2).append(list);
            ((StringBuilder)object2).append(", errors:");
            ((StringBuilder)object2).append(((PathWrapper)object).getErrors());
            iterable.add((String)((StringBuilder)object2).toString());
            return this;
        }
        iterable = ((PathWrapper)object).getPoints();
        double d = ((PointList)iterable).calcDistance(this.distCalc);
        if (Math.abs(((PathWrapper)object).getDistance() - d) > 2.0) {
            object2 = this.errors;
            list2 = new StringBuilder();
            ((StringBuilder)((Object)list2)).append(algoHelperEntry);
            ((StringBuilder)((Object)list2)).append(" path.getDistance was  ");
            ((StringBuilder)((Object)list2)).append(((PathWrapper)object).getDistance());
            ((StringBuilder)((Object)list2)).append("\t pointList.calcDistance was ");
            ((StringBuilder)((Object)list2)).append(d);
            ((StringBuilder)((Object)list2)).append("\t (expected points ");
            ((StringBuilder)((Object)list2)).append(oneRun.getLocs());
            ((StringBuilder)((Object)list2)).append(", expected distance ");
            ((StringBuilder)((Object)list2)).append(oneRun.getDistance());
            ((StringBuilder)((Object)list2)).append(") ");
            ((StringBuilder)((Object)list2)).append(list);
            object2.add(((StringBuilder)((Object)list2)).toString());
        }
        if (Math.abs(((PathWrapper)object).getDistance() - oneRun.getDistance()) > 2.0) {
            list2 = this.errors;
            object2 = new StringBuilder();
            ((StringBuilder)object2).append(algoHelperEntry);
            ((StringBuilder)object2).append(" returns path not matching the expected distance of ");
            ((StringBuilder)object2).append(oneRun.getDistance());
            ((StringBuilder)object2).append("\t Returned was ");
            ((StringBuilder)object2).append(((PathWrapper)object).getDistance());
            ((StringBuilder)object2).append("\t (expected points ");
            ((StringBuilder)object2).append(oneRun.getLocs());
            ((StringBuilder)object2).append(", was ");
            ((StringBuilder)object2).append(((PointList)iterable).getSize());
            ((StringBuilder)object2).append(") ");
            ((StringBuilder)object2).append(list);
            list2.add(((StringBuilder)object2).toString());
        }
        if (Math.abs(((PointList)iterable).getSize() - oneRun.getLocs()) > 1) {
            list2 = this.errors;
            object2 = new StringBuilder();
            ((StringBuilder)object2).append(algoHelperEntry);
            ((StringBuilder)object2).append(" returns path not matching the expected points of ");
            ((StringBuilder)object2).append(oneRun.getLocs());
            ((StringBuilder)object2).append("\t Returned was ");
            ((StringBuilder)object2).append(((PointList)iterable).getSize());
            ((StringBuilder)object2).append("\t (expected distance ");
            ((StringBuilder)object2).append(oneRun.getDistance());
            ((StringBuilder)object2).append(", was ");
            ((StringBuilder)object2).append(((PathWrapper)object).getDistance());
            ((StringBuilder)object2).append(") ");
            ((StringBuilder)object2).append(list);
            list2.add(((StringBuilder)object2).toString());
        }
        return this;
    }

    void printSummary() {
        if (this.errors.size() > 0) {
            System.out.println("\n-------------------------------\n");
            System.out.println(this.toString());
        } else {
            PrintStream printStream = System.out;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SUCCESS for ");
            stringBuilder.append(this.name);
            stringBuilder.append("!");
            printStream.println(stringBuilder.toString());
        }
    }

    void queryIndex(Graph object, LocationIndex list, double d, double d2, double d3) {
        object = list.findClosest(d, d2, EdgeFilter.ALL_EDGES);
        if (!((QueryResult)object).isValid()) {
            object = this.errors;
            list = new StringBuilder();
            ((StringBuilder)((Object)list)).append("node not found for ");
            ((StringBuilder)((Object)list)).append(d);
            ((StringBuilder)((Object)list)).append(",");
            ((StringBuilder)((Object)list)).append(d2);
            object.add((String)((StringBuilder)((Object)list)).toString());
            return;
        }
        GHPoint3D gHPoint3D = ((QueryResult)object).getSnappedPoint();
        double d4 = this.distCalc.calcDist(d, d2, gHPoint3D.lat, gHPoint3D.lon);
        if (Math.abs(d4 - d3) > 0.1) {
            list = this.errors;
            object = new StringBuilder();
            ((StringBuilder)object).append("queried lat,lon=");
            ((StringBuilder)object).append((float)d);
            ((StringBuilder)object).append(",");
            ((StringBuilder)object).append((float)d2);
            ((StringBuilder)object).append(" (found: ");
            ((StringBuilder)object).append((float)gHPoint3D.lat);
            ((StringBuilder)object).append(",");
            ((StringBuilder)object).append((float)gHPoint3D.lon);
            ((StringBuilder)object).append(")\n   expected distance:");
            ((StringBuilder)object).append(d3);
            ((StringBuilder)object).append(", but was:");
            ((StringBuilder)object).append(d4);
            list.add(((StringBuilder)object).toString());
        }
    }

    public String toString() {
        CharSequence charSequence = new StringBuilder();
        charSequence.append("");
        charSequence.append("FOUND ");
        charSequence.append(this.errors.size());
        charSequence.append(" ERRORS.\n");
        charSequence = charSequence.toString();
        for (String string2 : this.errors) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence);
            stringBuilder.append(string2);
            stringBuilder.append(".\n");
            charSequence = stringBuilder.toString();
        }
        return charSequence;
    }

    public static class AlgoHelperEntry {
        private String expectedAlgo;
        private Graph forQueryGraph;
        private final LocationIndex idx;
        private AlgorithmOptions opts;

        public AlgoHelperEntry(Graph graph, AlgorithmOptions algorithmOptions, LocationIndex locationIndex, String string2) {
            this.forQueryGraph = graph;
            this.opts = algorithmOptions;
            this.idx = locationIndex;
            this.expectedAlgo = string2;
        }

        public RoutingAlgorithmFactory createRoutingFactory() {
            return new RoutingAlgorithmFactorySimple();
        }

        public AlgorithmOptions getAlgorithmOptions() {
            return this.opts;
        }

        public String getExpectedAlgo() {
            return this.expectedAlgo;
        }

        public Graph getForQueryGraph() {
            return this.forQueryGraph;
        }

        public LocationIndex getIdx() {
            return this.idx;
        }

        public void setAlgorithmOptions(AlgorithmOptions algorithmOptions) {
            this.opts = algorithmOptions;
        }

        public String toString() {
            CharSequence charSequence;
            CharSequence charSequence2 = charSequence = this.opts.getAlgorithm();
            if (this.getExpectedAlgo().contains("landmarks")) {
                charSequence2 = new StringBuilder();
                ((StringBuilder)charSequence2).append((String)charSequence);
                ((StringBuilder)charSequence2).append("|landmarks");
                charSequence2 = ((StringBuilder)charSequence2).toString();
            }
            charSequence = charSequence2;
            if (this.forQueryGraph instanceof CHGraph) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append((String)charSequence2);
                ((StringBuilder)charSequence).append("|ch");
                charSequence = ((StringBuilder)charSequence).toString();
            }
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append("algoEntry(");
            ((StringBuilder)charSequence2).append((String)charSequence);
            ((StringBuilder)charSequence2).append(")");
            return ((StringBuilder)charSequence2).toString();
        }
    }

    static class AssumptionPerPath {
        double distance;
        double lat;
        int locs;
        double lon;

        public AssumptionPerPath(double d, double d2, double d3, int n) {
            this.lat = d;
            this.lon = d2;
            this.locs = n;
            this.distance = d3;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.lat);
            stringBuilder.append(", ");
            stringBuilder.append(this.lon);
            stringBuilder.append(", locs:");
            stringBuilder.append(this.locs);
            stringBuilder.append(", dist:");
            stringBuilder.append(this.distance);
            return stringBuilder.toString();
        }
    }

    public static class OneRun {
        private final List<AssumptionPerPath> assumptions = new ArrayList<AssumptionPerPath>();

        public OneRun() {
        }

        public OneRun(double d, double d2, double d3, double d4, double d5, int n) {
            this.add(d, d2, 0.0, 0);
            this.add(d3, d4, d5, n);
        }

        public OneRun add(double d, double d2, double d3, int n) {
            this.assumptions.add(new AssumptionPerPath(d, d2, d3, n));
            return this;
        }

        public double getDistance() {
            Iterator<AssumptionPerPath> iterator2 = this.assumptions.iterator();
            double d = 0.0;
            while (iterator2.hasNext()) {
                d += iterator2.next().distance;
            }
            return d;
        }

        public List<QueryResult> getList(LocationIndex locationIndex, EdgeFilter edgeFilter) {
            ArrayList<QueryResult> arrayList = new ArrayList<QueryResult>();
            for (AssumptionPerPath assumptionPerPath : this.assumptions) {
                arrayList.add(locationIndex.findClosest(assumptionPerPath.lat, assumptionPerPath.lon, edgeFilter));
            }
            return arrayList;
        }

        public int getLocs() {
            Iterator<AssumptionPerPath> iterator2 = this.assumptions.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                n += iterator2.next().locs;
            }
            return n;
        }

        public void setDistance(int n, double d) {
            this.assumptions.get((int)n).distance = d;
        }

        public void setLocs(int n, int n2) {
            this.assumptions.get((int)n).locs = n2;
        }

        public String toString() {
            return this.assumptions.toString();
        }
    }
}

