/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import java.util.Arrays;

public final class TraversalMode
extends Enum<TraversalMode> {
    private static final /* synthetic */ TraversalMode[] $VALUES;
    public static final /* enum */ TraversalMode EDGE_BASED_1DIR;
    public static final /* enum */ TraversalMode EDGE_BASED_2DIR;
    public static final /* enum */ TraversalMode EDGE_BASED_2DIR_UTURN;
    public static final /* enum */ TraversalMode NODE_BASED;
    private final boolean edgeBased;
    private final int noOfStates;
    private final boolean uTurnSupport;

    static {
        TraversalMode traversalMode;
        TraversalMode traversalMode2;
        TraversalMode traversalMode3;
        TraversalMode traversalMode4;
        NODE_BASED = traversalMode4 = new TraversalMode(false, 1, false);
        EDGE_BASED_1DIR = traversalMode3 = new TraversalMode(true, 1, false);
        EDGE_BASED_2DIR = traversalMode2 = new TraversalMode(true, 2, false);
        EDGE_BASED_2DIR_UTURN = traversalMode = new TraversalMode(true, 2, true);
        $VALUES = new TraversalMode[]{traversalMode4, traversalMode3, traversalMode2, traversalMode};
    }

    private TraversalMode(boolean bl, int n2, boolean bl2) {
        this.edgeBased = bl;
        this.noOfStates = n2;
        this.uTurnSupport = bl2;
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Currently only 1 or 2 states allowed");
        }
    }

    public static TraversalMode fromString(String string2) {
        try {
            TraversalMode traversalMode = TraversalMode.valueOf(Helper.toUpperCase(string2));
            return traversalMode;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("TraversalMode ");
            stringBuilder.append(string2);
            stringBuilder.append(" not supported. Supported are: ");
            stringBuilder.append(Arrays.asList(TraversalMode.values()));
            throw new IllegalArgumentException(stringBuilder.toString());
        }
    }

    public static TraversalMode valueOf(String string2) {
        return Enum.valueOf(TraversalMode.class, string2);
    }

    public static TraversalMode[] values() {
        return (TraversalMode[])$VALUES.clone();
    }

    public final int createTraversalId(int n, int n2, int n3, boolean bl) {
        if (this.edgeBased) {
            if (this.noOfStates == 1) {
                return n3;
            }
            return GHUtility.createEdgeKey(n, n2, n3, bl);
        }
        return n2;
    }

    public final int createTraversalId(EdgeIteratorState edgeIteratorState, boolean bl) {
        if (this.edgeBased) {
            if (this.noOfStates == 1) {
                return edgeIteratorState.getEdge();
            }
            return GHUtility.createEdgeKey(edgeIteratorState.getBaseNode(), edgeIteratorState.getAdjNode(), edgeIteratorState.getEdge(), bl);
        }
        return edgeIteratorState.getAdjNode();
    }

    public int getNoOfStates() {
        return this.noOfStates;
    }

    public final boolean hasUTurnSupport() {
        return this.uTurnSupport;
    }

    public boolean isEdgeBased() {
        return this.edgeBased;
    }

    public int reverseEdgeKey(int n) {
        int n2 = n;
        if (this.edgeBased) {
            n2 = n;
            if (this.noOfStates > 1) {
                n2 = GHUtility.reverseEdgeKey(n);
            }
        }
        return n2;
    }
}

