/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules;

import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.routing.util.spatialrules.SpatialRuleContainer;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.Polygon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpatialRuleLookupArray
implements SpatialRuleLookup {
    private final int EMPTY_RULE_INDEX;
    private final BBox bounds;
    private final double checkDiff;
    private final boolean exact;
    private final byte[][] lookupArray;
    private final double resolution;
    private final List<SpatialRuleContainer> ruleContainers;
    private final List<SpatialRule> singleRules;
    private final Map<SpatialRule, Integer> singleRulesIndices;

    public SpatialRuleLookupArray(List<SpatialRule> iterator2, double d, boolean bl, BBox bBox) {
        this.EMPTY_RULE_INDEX = 0;
        ArrayList<SpatialRuleContainer> arrayList = new ArrayList<SpatialRuleContainer>();
        this.ruleContainers = arrayList;
        this.singleRulesIndices = new HashMap<SpatialRule, Integer>();
        this.singleRules = new ArrayList<SpatialRule>();
        if (bBox.isValid()) {
            this.bounds = bBox;
            if (!(d < 1.0E-100)) {
                this.resolution = d;
                this.checkDiff = d / 2.0 - d / 10.0;
                this.exact = bl;
                this.lookupArray = new byte[this.getNumberOfXGrids()][this.getNumberOfYGrids()];
                this.addSingleRule(SpatialRule.EMPTY);
                arrayList.add(new SpatialRuleContainer(){
                    {
                        this.rules.add(SpatialRule.EMPTY);
                    }

                    @Override
                    public SpatialRuleContainer addRule(SpatialRule spatialRule) {
                        throw new IllegalArgumentException("Cannot add to empty rule container");
                    }

                    @Override
                    public SpatialRuleContainer addRules(Collection<SpatialRule> collection) {
                        throw new IllegalArgumentException("Cannot add to empty rule container");
                    }
                });
                iterator2 = iterator2.iterator();
                while (iterator2.hasNext()) {
                    this.addRuleInternal((SpatialRule)iterator2.next());
                }
                return;
            }
            iterator2 = new StringBuilder();
            ((StringBuilder)((Object)iterator2)).append("resolution cannot be that high ");
            ((StringBuilder)((Object)iterator2)).append(d);
            throw new IllegalArgumentException(((StringBuilder)((Object)iterator2)).toString());
        }
        iterator2 = new StringBuilder();
        ((StringBuilder)((Object)iterator2)).append("Bounds are not valid: ");
        ((StringBuilder)((Object)iterator2)).append(bBox);
        throw new IllegalStateException(((StringBuilder)((Object)iterator2)).toString());
    }

    private int addRuleContainer(SpatialRuleContainer spatialRuleContainer) {
        int n = this.ruleContainers.indexOf(spatialRuleContainer);
        if (n >= 0) {
            return n;
        }
        n = this.ruleContainers.size();
        if (n < 255) {
            this.ruleContainers.add(spatialRuleContainer);
            return n;
        }
        throw new IllegalStateException("No more spatial rule container fit into this lookup as 255 combination of ruleContainers reached");
    }

    private void addRuleInternal(SpatialRule spatialRule) {
        if (spatialRule != null) {
            if (!spatialRule.equals(SpatialRule.EMPTY)) {
                this.addSingleRule(spatialRule);
                int n = this.addRuleContainer(new SpatialRuleContainer().addRule(spatialRule));
                for (Polygon polygon : spatialRule.getBorders()) {
                    for (int i = this.getXIndexForLon(polygon.getMinLon()); i < this.getXIndexForLon(polygon.getMaxLon()) + 1; ++i) {
                        for (int j = this.getYIndexForLat(polygon.getMinLat()); j < this.getYIndexForLat(polygon.getMaxLat()) + 1; ++j) {
                            Object object = this.lookupArray;
                            if (i >= ((byte[][])object).length || j >= object[0].length || !polygon.contains((GHPoint)(object = (Object)this.getCoordinatesForIndex(i, j))) && !polygon.contains(object.getLat() - this.checkDiff, object.getLon() - this.checkDiff) && !polygon.contains(object.getLat() - this.checkDiff, object.getLon() + this.checkDiff) && !polygon.contains(object.getLat() + this.checkDiff, object.getLon() - this.checkDiff) && !polygon.contains(object.getLat() + this.checkDiff, object.getLon() + this.checkDiff)) continue;
                            object = this.lookupArray;
                            if (object[i][j] == 0) {
                                object[i][j] = (byte)n;
                                continue;
                            }
                            int n2 = this.addRuleContainer(this.getContainerFor2DIndex(i, j).copy().addRule(spatialRule));
                            this.lookupArray[i][j] = (byte)n2;
                        }
                    }
                }
                return;
            }
            throw new IllegalArgumentException("rule cannot be EMPTY");
        }
        throw new IllegalArgumentException("rule cannot be null");
    }

    private void addSingleRule(SpatialRule object) {
        int n = this.singleRules.indexOf(object);
        if (n >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Rule ");
            stringBuilder.append(object);
            stringBuilder.append(" already contained at ");
            stringBuilder.append(n);
            stringBuilder.append(". ");
            if (n >= this.ruleContainers.size()) {
                object = "";
            } else {
                object = new StringBuilder();
                ((StringBuilder)object).append("Existing:");
                ((StringBuilder)object).append(this.ruleContainers.get(n));
                object = ((StringBuilder)object).toString();
            }
            stringBuilder.append((String)object);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.singleRulesIndices.put((SpatialRule)object, this.singleRules.size());
        this.singleRules.add((SpatialRule)object);
    }

    private int castByteToInt(byte by) {
        return by & 0xFF;
    }

    private SpatialRuleContainer getContainerFor2DIndex(int n, int n2) {
        return this.ruleContainers.get(this.getRuleContainerIndex(n, n2));
    }

    private GHPoint getCoordinatesForIndex(int n, int n2) {
        double d = this.bounds.minLon;
        double d2 = n;
        double d3 = this.resolution;
        double d4 = d3 / 2.0;
        double d5 = this.bounds.minLat;
        double d6 = n2;
        double d7 = this.resolution;
        return new GHPoint(d5 + d6 * d7 + d7 / 2.0, d + d2 * d3 + d4);
    }

    private int getNumberOfXGrids() {
        return (int)Math.ceil(Math.abs(this.bounds.maxLon - this.bounds.minLon) / this.resolution);
    }

    private int getNumberOfYGrids() {
        return (int)Math.ceil(Math.abs(this.bounds.maxLat - this.bounds.minLat) / this.resolution);
    }

    private int getRuleContainerIndex(int n, int n2) {
        byte[][] byArray;
        if (n >= 0 && n < (byArray = this.lookupArray).length && n2 >= 0 && n2 < byArray[0].length) {
            return this.castByteToInt(byArray[n][n2]);
        }
        return 0;
    }

    private int getXIndexForLon(double d) {
        if (d < this.bounds.minLon) {
            return 0;
        }
        return (int)Math.floor(Math.abs(d - this.bounds.minLon) / this.resolution);
    }

    private int getYIndexForLat(double d) {
        if (d < this.bounds.minLat) {
            return 0;
        }
        return (int)Math.floor(Math.abs(d - this.bounds.minLat) / this.resolution);
    }

    private boolean isBorderTile(int n, int n2, int n3) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (i == n || j == n2 || n3 == this.getRuleContainerIndex(i, j)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public BBox getBounds() {
        return this.bounds;
    }

    @Override
    public int getSpatialId(SpatialRule spatialRule) {
        if (spatialRule != null) {
            Comparable<Integer> comparable = this.singleRulesIndices.get(spatialRule);
            if (comparable != null) {
                return (Integer)comparable;
            }
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append("Cannot find rule ");
            ((StringBuilder)comparable).append(spatialRule);
            throw new IllegalArgumentException(((StringBuilder)comparable).toString());
        }
        throw new IllegalArgumentException("rule parameter cannot be null");
    }

    SpatialRule getSpatialRule(int n) {
        if (n >= 0 && n < this.ruleContainers.size()) {
            Object object = this.singleRules.get(n);
            if (object != null) {
                return object;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("SpatialRuleId ");
            ((StringBuilder)object).append(n);
            ((StringBuilder)object).append(" not found");
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SpatialRuleId ");
        stringBuilder.append(n);
        stringBuilder.append(" is illegal");
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    @Override
    public SpatialRule lookupRule(double d, double d2) {
        if (!(d2 < this.bounds.minLon || d2 > this.bounds.maxLon || d < this.bounds.minLat || d > this.bounds.maxLat)) {
            int n;
            int n2 = this.getXIndexForLon(d2);
            int n3 = this.getRuleContainerIndex(n2, n = this.getYIndexForLat(d));
            Object object = this.ruleContainers.get(n3);
            if (!(((SpatialRuleContainer)object).size() != 1 || this.exact && this.isBorderTile(n2, n, n3))) {
                return ((SpatialRuleContainer)object).first();
            }
            for (SpatialRule spatialRule : ((SpatialRuleContainer)object).getRules()) {
                if (spatialRule.equals(SpatialRule.EMPTY)) continue;
                object = spatialRule.getBorders().iterator();
                while (object.hasNext()) {
                    if (!((Polygon)object.next()).contains(d, d2)) continue;
                    return spatialRule;
                }
            }
            return SpatialRule.EMPTY;
        }
        return SpatialRule.EMPTY;
    }

    @Override
    public SpatialRule lookupRule(GHPoint gHPoint) {
        return this.lookupRule(gHPoint.getLat(), gHPoint.getLon());
    }

    @Override
    public int size() {
        return this.singleRules.size();
    }
}

