/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.EdgeIteratorState;

public abstract class AbstractAdjustedWeighting
implements Weighting {
    protected final Weighting superWeighting;

    public AbstractAdjustedWeighting(Weighting weighting) {
        if (weighting != null) {
            this.superWeighting = weighting;
            return;
        }
        throw new IllegalArgumentException("No super weighting set");
    }

    @Override
    public long calcMillis(EdgeIteratorState edgeIteratorState, boolean bl, int n) {
        return this.superWeighting.calcMillis(edgeIteratorState, bl, n);
    }

    @Override
    public FlagEncoder getFlagEncoder() {
        return this.superWeighting.getFlagEncoder();
    }

    @Override
    public boolean matches(HintsMap hintsMap) {
        boolean bl = this.getName().equals(hintsMap.getWeighting()) && this.superWeighting.getFlagEncoder().toString().equals(hintsMap.getVehicle());
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName());
        stringBuilder.append("|");
        stringBuilder.append(this.superWeighting.toString());
        return stringBuilder.toString();
    }
}

