/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;

public abstract class AbstractWeighting
implements Weighting {
    protected final FlagEncoder flagEncoder;

    protected AbstractWeighting(FlagEncoder object) {
        this.flagEncoder = object;
        if (object.isRegistered()) {
            if (AbstractWeighting.isValidName(this.getName())) {
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Not a valid name for a Weighting: ");
            ((StringBuilder)object).append(this.getName());
            throw new IllegalStateException(((StringBuilder)object).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Make sure you add the FlagEncoder ");
        stringBuilder.append(object);
        stringBuilder.append(" to an EncodingManager before using it elsewhere");
        throw new IllegalStateException(stringBuilder.toString());
    }

    static final boolean isValidName(String string2) {
        if (string2 != null && !string2.isEmpty()) {
            return string2.matches("[\\|_a-z]+");
        }
        return false;
    }

    public static String weightingToFileName(Weighting weighting) {
        return Helper.toLowerCase(weighting.toString()).replaceAll("\\|", "_");
    }

    @Override
    public long calcMillis(EdgeIteratorState object, boolean bl, int n) {
        long l = object.getFlags();
        if (bl && !this.flagEncoder.isBackward(l) || !bl && !this.flagEncoder.isForward(l)) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Calculating time should not require to read speed from edge in wrong direction. Reverse:");
            ((StringBuilder)object).append(bl);
            ((StringBuilder)object).append(", fwd:");
            ((StringBuilder)object).append(this.flagEncoder.isForward(l));
            ((StringBuilder)object).append(", bwd:");
            ((StringBuilder)object).append(this.flagEncoder.isBackward(l));
            throw new IllegalStateException(((StringBuilder)object).toString());
        }
        double d = bl ? this.flagEncoder.getReverseSpeed(l) : this.flagEncoder.getSpeed(l);
        if (!(Double.isInfinite(d) || Double.isNaN(d) || d < 0.0)) {
            if (d != 0.0) {
                return (long)(object.getDistance() * 3600.0 / d);
            }
            throw new IllegalStateException("Speed cannot be 0 for unblocked edge, use access properties to mark edge blocked! Should only occur for shortest path calculation. See #242.");
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Invalid speed stored in edge! ");
        ((StringBuilder)object).append(d);
        throw new IllegalStateException(((StringBuilder)object).toString());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Weighting)object;
        return this.toString().equals(object.toString());
    }

    @Override
    public FlagEncoder getFlagEncoder() {
        return this.flagEncoder;
    }

    public int hashCode() {
        return 497 + this.toString().hashCode();
    }

    @Override
    public boolean matches(HintsMap hintsMap) {
        boolean bl = this.getName().equals(hintsMap.getWeighting()) && this.flagEncoder.toString().equals(hintsMap.getVehicle());
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName());
        stringBuilder.append("|");
        stringBuilder.append(this.flagEncoder);
        return stringBuilder.toString();
    }
}

