/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.carrotsearch.hppc.IntSet;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.routing.weighting.AbstractAdjustedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.EdgeIteratorState;
import java.util.Collection;
import java.util.Iterator;

public class AvoidEdgesWeighting
extends AbstractAdjustedWeighting {
    private double edgePenaltyFactor = 5.0;
    protected final IntSet visitedEdges = new GHIntHashSet();

    public AvoidEdgesWeighting(Weighting weighting) {
        super(weighting);
    }

    public void addEdges(Collection<EdgeIteratorState> object) {
        Iterator<EdgeIteratorState> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            this.visitedEdges.add(object.getEdge());
        }
    }

    @Override
    public double calcWeight(EdgeIteratorState edgeIteratorState, boolean bl, int n) {
        double d;
        double d2 = d = this.superWeighting.calcWeight(edgeIteratorState, bl, n);
        if (this.visitedEdges.contains(edgeIteratorState.getEdge())) {
            d2 = d * this.edgePenaltyFactor;
        }
        return d2;
    }

    @Override
    public double getMinWeight(double d) {
        return this.superWeighting.getMinWeight(d);
    }

    @Override
    public String getName() {
        return "avoid_edges";
    }

    public AvoidEdgesWeighting setEdgePenaltyFactor(double d) {
        this.edgePenaltyFactor = d;
        return this;
    }
}

