/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;

public class CurvatureWeighting
extends PriorityWeighting {
    private final double minFactor;

    public CurvatureWeighting(FlagEncoder flagEncoder, PMap pMap) {
        super(flagEncoder, pMap);
        this.minFactor = 1.0 / Math.log(flagEncoder.getMaxSpeed()) / 1.5;
    }

    @Override
    public double calcWeight(EdgeIteratorState edgeIteratorState, boolean bl, int n) {
        double d = this.flagEncoder.getDouble(edgeIteratorState.getFlags(), 101);
        double d2 = this.flagEncoder.getDouble(edgeIteratorState.getFlags(), 112);
        double d3 = this.getRoadSpeed(edgeIteratorState, bl);
        return d2 * (edgeIteratorState.getDistance() / Math.log(d3)) / (d + 0.5);
    }

    @Override
    public double getMinWeight(double d) {
        return this.minFactor * d;
    }

    @Override
    public String getName() {
        return "curvature";
    }

    protected double getRoadSpeed(EdgeIteratorState edgeIteratorState, boolean bl) {
        double d = bl ? this.flagEncoder.getReverseSpeed(edgeIteratorState.getFlags()) : this.flagEncoder.getSpeed(edgeIteratorState.getFlags());
        return d;
    }
}

