/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;

public class FastestWeighting
extends AbstractWeighting {
    protected static final double SPEED_CONV = 3.6;
    private final double headingPenalty;
    private final long headingPenaltyMillis;
    private final double maxSpeed;

    public FastestWeighting(FlagEncoder flagEncoder) {
        this(flagEncoder, new HintsMap(0));
    }

    public FastestWeighting(FlagEncoder flagEncoder, PMap pMap) {
        super(flagEncoder);
        double d;
        this.headingPenalty = d = pMap.getDouble("heading_penalty", 300.0);
        this.headingPenaltyMillis = Math.round(d * 1000.0);
        this.maxSpeed = flagEncoder.getMaxSpeed() / 3.6;
    }

    @Override
    public long calcMillis(EdgeIteratorState edgeIteratorState, boolean bl, int n) {
        boolean bl2 = edgeIteratorState.getBool(-1, false);
        long l = 0L;
        if (bl2) {
            l = 0L + this.headingPenaltyMillis;
        }
        return l + super.calcMillis(edgeIteratorState, bl, n);
    }

    @Override
    public double calcWeight(EdgeIteratorState edgeIteratorState, boolean bl, int n) {
        double d;
        double d2 = bl ? this.flagEncoder.getReverseSpeed(edgeIteratorState.getFlags()) : this.flagEncoder.getSpeed(edgeIteratorState.getFlags());
        if (d2 == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        d2 = d = edgeIteratorState.getDistance() / d2 * 3.6;
        if (edgeIteratorState.getBool(-1, false)) {
            d2 = d + this.headingPenalty;
        }
        return d2;
    }

    @Override
    public double getMinWeight(double d) {
        return d / this.maxSpeed;
    }

    @Override
    public String getName() {
        return "fastest";
    }
}

