/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;

public class PriorityWeighting
extends FastestWeighting {
    public static final int KEY = 101;
    private final double minFactor;

    public PriorityWeighting(FlagEncoder flagEncoder) {
        this(flagEncoder, new PMap(0));
    }

    public PriorityWeighting(FlagEncoder flagEncoder, PMap pMap) {
        super(flagEncoder, pMap);
        this.minFactor = 0.6666666666666666;
    }

    @Override
    public double calcWeight(EdgeIteratorState edgeIteratorState, boolean bl, int n) {
        double d = super.calcWeight(edgeIteratorState, bl, n);
        if (Double.isInfinite(d)) {
            return Double.POSITIVE_INFINITY;
        }
        return d / (this.flagEncoder.getDouble(edgeIteratorState.getFlags(), 101) + 0.5);
    }

    @Override
    public double getMinWeight(double d) {
        return this.minFactor * super.getMinWeight(d);
    }
}

