/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;

public class ShortFastestWeighting
extends FastestWeighting {
    private static final String DISTANCE_FACTOR = "short_fastest.distance_factor";
    private static final String NAME = "short_fastest";
    private static final String TIME_FACTOR = "short_fastest.time_factor";
    private final double distanceFactor;
    private final double timeFactor;

    public ShortFastestWeighting(FlagEncoder flagEncoder, double d) {
        super(flagEncoder);
        this.distanceFactor = this.checkBounds(DISTANCE_FACTOR, d);
        this.timeFactor = 1.0;
    }

    public ShortFastestWeighting(FlagEncoder flagEncoder, PMap pMap) {
        super(flagEncoder);
        double d;
        double d2;
        this.timeFactor = d2 = this.checkBounds(TIME_FACTOR, pMap.getDouble(TIME_FACTOR, 1.0));
        this.distanceFactor = d = this.checkBounds(DISTANCE_FACTOR, pMap.getDouble(DISTANCE_FACTOR, 0.07));
        if (d2 < 1.0E-5 && d < 1.0E-5) {
            throw new IllegalArgumentException("[short_fastest] one of distance_factor or time_factor has to be non-zero");
        }
    }

    private double checkBounds(String string2, double d) {
        if (!(d < 0.0) && !(d > 10.0)) {
            return d;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(" has invalid range should be within [0, 10]");
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    @Override
    public double calcWeight(EdgeIteratorState edgeIteratorState, boolean bl, int n) {
        return super.calcWeight(edgeIteratorState, bl, n) * this.timeFactor + edgeIteratorState.getDistance() * this.distanceFactor;
    }

    @Override
    public double getMinWeight(double d) {
        return super.getMinWeight(d) * this.timeFactor + d * this.distanceFactor;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

