/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeIteratorState;

abstract class EdgeAccess {
    private static final double INT_DIST_FACTOR = 1000.0;
    static double MAX_DIST = 2147483.646;
    static final int NO_NODE = -1;
    int E_DIST;
    int E_FLAGS;
    int E_LINKA;
    int E_LINKB;
    int E_NODEA;
    int E_NODEB;
    private final BitUtil bitUtil;
    final DataAccess edges;
    private boolean flagsSizeIsLong;

    EdgeAccess(DataAccess dataAccess, BitUtil bitUtil) {
        this.edges = dataAccess;
        this.bitUtil = bitUtil;
    }

    private long _getLinkPosInEdgeArea(int n, int n2, long l) {
        n = n <= n2 ? this.E_LINKA : this.E_LINKB;
        return l + (long)n;
    }

    private int distToInt(double d) {
        int n = (int)(1000.0 * d);
        if (n >= 0) {
            if (n >= Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return n;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Distance cannot be negative: ");
        stringBuilder.append(d);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    final void connectNewEdge(int n, int n2, int n3) {
        int n4 = this.getEdgeRef(n);
        if (n4 > -1) {
            long l = this._getLinkPosInEdgeArea(n, n2, this.toPointer(n3));
            this.edges.setInt(l, n4);
        }
        this.setEdgeRef(n, n3);
    }

    abstract BaseGraph.EdgeIterable createSingleEdge(EdgeFilter var1);

    final double getDist(long l) {
        return (double)this.edges.getInt(l + (long)this.E_DIST) / 1000.0;
    }

    final EdgeIteratorState getEdgeProps(int n, int n2) {
        if (n > -1) {
            BaseGraph.EdgeIterable edgeIterable = this.createSingleEdge(EdgeFilter.ALL_EDGES);
            if (edgeIterable.init(n, n2)) {
                return edgeIterable;
            }
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("edgeId invalid ");
        stringBuilder.append(n);
        stringBuilder.append(", ");
        stringBuilder.append(this);
        throw new IllegalStateException(stringBuilder.toString());
    }

    abstract int getEdgeRef(int var1);

    final int getEdgeRef(int n, int n2, long l) {
        return this.edges.getInt(this._getLinkPosInEdgeArea(n, n2, l));
    }

    abstract int getEntryBytes();

    final long getFlags_(long l, boolean bl) {
        int n = this.edges.getInt((long)this.E_FLAGS + l);
        long l2 = n;
        if (this.flagsSizeIsLong) {
            int n2 = this.edges.getInt((long)this.E_FLAGS + l + 4L);
            l2 = this.bitUtil.combineIntsToLong(n, n2);
        }
        long l3 = l2;
        if (bl) {
            l3 = this.reverseFlags(l, l2);
        }
        return l3;
    }

    final int getOtherNode(int n, long l) {
        int n2 = this.edges.getInt((long)this.E_NODEA + l);
        if (n2 == n) {
            return this.edges.getInt(l + (long)this.E_NODEB);
        }
        return n2;
    }

    final void init(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.E_NODEA = n;
        this.E_NODEB = n2;
        this.E_LINKA = n3;
        this.E_LINKB = n4;
        this.E_DIST = n5;
        this.E_FLAGS = n6;
        this.flagsSizeIsLong = bl;
    }

    final int internalEdgeAdd(int n, int n2, int n3) {
        this.writeEdge(n, n2, n3, -1, -1);
        this.connectNewEdge(n2, n3, n);
        if (n2 != n3) {
            this.connectNewEdge(n3, n2, n);
        }
        return n;
    }

    final long internalEdgeDisconnect(int n, long l, int n2, int n3) {
        long l2 = this.toPointer(n);
        n3 = this.getEdgeRef(n2, n3, l2);
        if (l < 0L) {
            this.setEdgeRef(n2, n3);
        } else {
            n = this.edges.getInt((long)this.E_NODEA + l) == n2 ? this.E_LINKA : this.E_LINKB;
            long l3 = n;
            this.edges.setInt(l + l3, n3);
        }
        return l2;
    }

    final void invalidateEdge(long l) {
        this.edges.setInt(l + (long)this.E_NODEA, -1);
    }

    abstract boolean isInBounds(int var1);

    abstract long reverseFlags(long var1, long var3);

    final void setDist(long l, double d) {
        this.edges.setInt(l + (long)this.E_DIST, this.distToInt(d));
    }

    abstract void setEdgeRef(int var1, int var2);

    final long setFlags_(long l, boolean bl, long l2) {
        long l3 = l2;
        if (bl) {
            l3 = this.reverseFlags(l, l2);
        }
        this.edges.setInt((long)this.E_FLAGS + l, this.bitUtil.getIntLow(l3));
        if (this.flagsSizeIsLong) {
            this.edges.setInt(l + (long)this.E_FLAGS + 4L, this.bitUtil.getIntHigh(l3));
        }
        return l3;
    }

    abstract long toPointer(int var1);

    final long writeEdge(int n, int n2, int n3, int n4, int n5) {
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        int n9 = n5;
        if (n2 > n3) {
            n9 = n4;
            n8 = n5;
            n7 = n2;
            n6 = n3;
        }
        if (n >= 0 && n != -1) {
            long l = this.toPointer(n);
            this.edges.setInt((long)this.E_NODEA + l, n6);
            this.edges.setInt((long)this.E_NODEB + l, n7);
            this.edges.setInt((long)this.E_LINKA + l, n8);
            this.edges.setInt((long)this.E_LINKB + l, n9);
            return l;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot write edge with illegal ID:");
        stringBuilder.append(n);
        stringBuilder.append("; nodeThis:");
        stringBuilder.append(n6);
        stringBuilder.append(", nodeOther:");
        stringBuilder.append(n7);
        throw new IllegalStateException(stringBuilder.toString());
    }
}

